/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.files.AbstractRecursiveFileAction;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DeleteFileAction
extends AbstractRecursiveFileAction {
    private boolean backupForRollback = true;
    private List<File> deletedDirs = new ArrayList<File>();

    public boolean isBackupForRollback() {
        return this.backupForRollback;
    }

    public void setBackupForRollback(boolean backupForRollback) {
        this.backupForRollback = backupForRollback;
    }

    @Override
    protected boolean executeForSingleRecursiveFile(Context context, File file, File relativeSourceFile, ProgressAdapter progressAdapter) throws UserCanceledException, IOException {
        if (!file.isDirectory()) {
            boolean success;
            this.deleteFile(file, context);
            boolean bl = success = !file.exists();
            if (!success) {
                Logger.getInstance().log(this, "The file " + file.getPath() + " cannot be deleted", false);
            }
            return success;
        }
        return true;
    }

    @Override
    protected boolean postProcessDirectory(Context context, File file) {
        boolean success;
        this.deleteDir(file);
        boolean bl = success = !this.isRecursive() || !file.exists() || this.getFileFilter() != null || this.getDirectoryFilter() != null;
        if (!success) {
            Logger.getInstance().log(this, "Could not delete directory " + file, false);
        }
        return success;
    }

    private void deleteDir(File usedFile) {
        if (this.backupForRollback) {
            this.deletedDirs.add(usedFile);
        }
        usedFile.delete();
    }

    private void deleteFile(File usedFile, Context context) throws UserCanceledException {
        if (context instanceof InstallerContext && this.backupForRollback) {
            BackupFileForRollbackAction backupFileForRollbackAction = new BackupFileForRollbackAction(usedFile, true, false, false);
            backupFileForRollbackAction.install((InstallerContext)context);
            this.addRollbackAction(backupFileForRollbackAction);
        } else {
            usedFile.delete();
        }
    }

    @Override
    public void rollback(InstallerContext context) {
        for (File deletedDir : this.deletedDirs) {
            deletedDir.mkdirs();
        }
        super.rollback(context);
    }

    @Override
    public boolean isRollbackSupported() {
        return this.backupForRollback;
    }

    @Override
    protected boolean isErrorIfFileMissing() {
        return false;
    }
}

