/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.install4j.api.actions.AutoUninstallAction;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.installer.helper.AppleScriptHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.MenuHelper;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class AddStartupItemAction
extends SystemInstallAction
implements AutoUninstallAction {
    private Properties persistentProperties = new Properties();
    private File executable;
    private String name;
    private boolean allUsers;
    private boolean hide = false;
    private static final String PROPNAME_EXECUTABLE = "executable";

    @Override
    public boolean install(InstallerContext context) throws UserCanceledException {
        try {
            File destinationFile = context.getDestinationFile(this.getExecutable());
            if (InstallerUtil.isWindows()) {
                if (!destinationFile.exists()) {
                    destinationFile = context.getDestinationFile(this.getExecutable() + ".exe");
                }
                Logger.getInstance().info(this, "using " + destinationFile + ", " + destinationFile.exists());
                boolean allUsers = this.isAllUsers();
                if (allUsers && !InstallerUtil.checkWriteable(FolderInfo.getSpecialFolder(4, true))) {
                    allUsers = false;
                }
                MenuHelper.installWindowsMenu(allUsers ? ExecutionContext.MAXIMUM : ExecutionContext.UNELEVATED, new File(FolderInfo.getSpecialFolder(4, allUsers), this.getName()), destinationFile, null);
            } else if (InstallerUtil.isMacOS()) {
                Logger.getInstance().info(this, "using " + destinationFile + ", " + destinationFile.exists());
                AddStartupItemAction.doRollback(destinationFile.getAbsolutePath());
                if (AddStartupItemAction.addOnMac(destinationFile, this.isHide())) {
                    this.getPersistentProperties().setProperty(PROPNAME_EXECUTABLE, destinationFile.getAbsolutePath());
                } else {
                    return false;
                }
            }
            return true;
        }
        catch (IOException e) {
            Logger.getImpl().log(e);
            return false;
        }
    }

    private static boolean addOnMac(final File destinationFile, final boolean hide) {
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

            @Override
            protected boolean fetchValue(Context context) throws Exception {
                String name = destinationFile.getName();
                if (name.endsWith(".app")) {
                    name = name.substring(0, name.length() - 4);
                }
                return AppleScriptHelper.executeScript("tell app \"System Events\" to make login item at end with properties {path:\"" + destinationFile.getAbsolutePath() + "\", hidden:" + hide + ", name:\"" + name + "\"}");
            }
        });
    }

    @Override
    public Properties getPersistentProperties() {
        return this.persistentProperties;
    }

    @Override
    public void setPersistentProperties(Properties properties) {
        this.persistentProperties = properties;
    }

    @Override
    public void rollback(InstallerContext context) {
        if (InstallerUtil.isMacOS()) {
            AddStartupItemAction.doRollback(context.getDestinationFile(this.getExecutable()).getAbsolutePath());
        }
    }

    @Override
    public boolean uninstall(UninstallerContext context) throws UserCanceledException {
        if (InstallerUtil.isMacOS()) {
            AddStartupItemAction.doRollback(this.getPersistentProperties().getProperty(PROPNAME_EXECUTABLE));
        }
        return true;
    }

    private static void doRollback(final String executable) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context) throws Exception {
                if (executable != null) {
                    File destinationFile = new File(executable);
                    String name = destinationFile.getName();
                    if (name.endsWith(".app")) {
                        name = name.substring(0, name.length() - 4);
                    }
                    AppleScriptHelper.executeScript("tell app \"System Events\" to delete login item \"" + name + "\"");
                }
            }
        });
    }

    public boolean isHide() {
        return this.hide;
    }

    public void setHide(boolean hide) {
        this.hide = hide;
    }

    public String getName() {
        return AddStartupItemAction.replaceVariables(this.name, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE);
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getExecutable() {
        return AddStartupItemAction.replaceVariables(this.executable);
    }

    public void setExecutable(File executable) {
        this.executable = executable;
    }

    public boolean isAllUsers() {
        return this.allUsers;
    }

    public void setAllUsers(boolean allUsers) {
        this.allUsers = allUsers;
    }
}

