/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions;

import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.RunningProcessChecker;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class UninstallPreviousAction
extends SystemInstallAction {
    public static final String PROP_UPGRADE_UNINSTALL = "install4j.upgradeUninstall";
    private File installationDirectory;
    private boolean onlyIfSameApplicationId = true;

    public File getInstallationDirectory() {
        return UninstallPreviousAction.replaceVariables(this.installationDirectory);
    }

    public void setInstallationDirectory(File installationDirectory) {
        this.installationDirectory = installationDirectory;
    }

    public boolean isOnlyIfSameApplicationId() {
        return this.onlyIfSameApplicationId;
    }

    public void setOnlyIfSameApplicationId(boolean onlyIfSameApplicationId) {
        this.onlyIfSameApplicationId = onlyIfSameApplicationId;
    }

    @Override
    public boolean install(InstallerContext context) throws UserCanceledException {
        try {
            ProgressInterface progressInterface = context.getProgressInterface();
            Logger.getInstance().info(this, "checking running processes");
            if (!RunningProcessChecker.checkDefaultRunningLauncher("AppRunningError")) {
                throw new UserCanceledException();
            }
            Logger.getInstance().info(this, "checking running processes ok");
            File externalInstallationDirectory = this.getInstallationDirectory();
            File installationDirectory = externalInstallationDirectory == null || externalInstallationDirectory.getPath().trim().length() == 0 ? context.getInstallationDirectory() : externalInstallationDirectory;
            InstallerConfig config = InstallerConfig.getCurrentInstance();
            Logger.getInstance().info(this, "getting previous installation id");
            String oldApplicationId = InstallerUtil.getOldApplicationId(installationDirectory);
            if (oldApplicationId != null && (!this.onlyIfSameApplicationId || config.getApplicationId().equals(oldApplicationId))) {
                progressInterface.setStatusMessage(Messages.getMessages().getString("StatusUninstallingPrevious"));
                progressInterface.setIndeterminateProgress(true);
                UninstallerThread uninstallerThread = new UninstallerThread(installationDirectory, context.getInstallationDirectory().getCanonicalFile().equals(installationDirectory.getCanonicalFile()));
                Logger.getInstance().info(this, "starting uninstaller");
                uninstallerThread.start();
                while (uninstallerThread.isAlive()) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (!context.isCancelling()) continue;
                    uninstallerThread.interrupt();
                }
                progressInterface.setIndeterminateProgress(false);
            } else {
                Logger.getInstance().info(this, "no previous installation detected, uninstaller was not started");
            }
            Logger.getInstance().info(this, "finished");
            return true;
        }
        catch (UserCanceledException e) {
            Logger.getInstance().info(this, "user cancelled");
            throw e;
        }
        catch (Throwable t) {
            Logger.getInstance().log(t);
            return false;
        }
    }

    private class UninstallerThread
    extends Thread {
        private File installationDirectory;
        private boolean upgrade;

        public UninstallerThread(File installationDirectory, boolean upgrade) {
            super("uninstaller waiting thread");
            this.installationDirectory = installationDirectory;
            this.upgrade = upgrade;
        }

        @Override
        public void run() {
            try {
                File logFile = new File("uninstallPrevious.log");
                if (InstallerUtil.isMacOS()) {
                    this.runJavaUninstaller(null);
                } else if (InstallerUtil.isWindows()) {
                    InstallerConfig oldConfig = InstallerUtil.getOldApplicationConfig(this.installationDirectory);
                    File undeletedLogFile = new File("i4j_undel.log.tmp");
                    String[] arguments = new String[]{"-q_i4j_internal", "-q", "-Dwindel.logfile=" + undeletedLogFile.getAbsolutePath(), "-Dinstall4j.alternativeLogfile=" + logFile.getAbsolutePath(), "-Dinstall4j.upgradeUninstall=" + this.upgrade};
                    LaunchDescriptor launchDescriptor = new LaunchDescriptor(new File(this.installationDirectory, oldConfig.getUninstallerPath() + ".exe")).arguments(arguments).workingDirectory(new File(this.installationDirectory, "..")).wait(true);
                    Integer returnValue = LaunchHelper.launchApplication(launchDescriptor);
                    Logger.getInstance().info(this, "native uninstaller process returned " + returnValue);
                    if (returnValue == null || returnValue == 83) {
                        this.runJavaUninstaller(logFile);
                    } else {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        this.deleteWindowsUndelFiles(undeletedLogFile);
                    }
                } else {
                    InstallerConfig oldConfig = InstallerUtil.getOldApplicationConfig(this.installationDirectory);
                    Process process = new ProcessBuilder("/bin/sh", new File(this.installationDirectory, oldConfig.getUninstallerPath()).getAbsolutePath(), "-q", "-Dinstall4j.alternativeLogfile=" + logFile.getAbsolutePath(), "-Dinstall4j.upgradeUninstall=" + this.upgrade).directory(new File(this.installationDirectory, "..")).start();
                    try {
                        if (process.waitFor() == 83) {
                            this.runJavaUninstaller(logFile);
                        }
                    }
                    catch (InterruptedException e) {
                        process.destroy();
                    }
                }
                Logger.getInstance().info(this, "see uninstallPrevious.log for the log file of the uninstaller");
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void runJavaUninstaller(File logFile) throws IOException {
            File runtimeDir = new File(this.installationDirectory, ".install4j");
            String classpath = new File(runtimeDir, "i4jruntime.jar").getAbsolutePath() + File.pathSeparator + new File(runtimeDir, "user.jar").getAbsolutePath();
            File[] userFiles = new File(runtimeDir, "user").listFiles();
            if (userFiles != null) {
                for (File userFile : userFiles) {
                    if (!userFile.getName().endsWith(".jar") && !userFile.getName().endsWith(".zip")) continue;
                    classpath = classpath + File.pathSeparator + userFile.getAbsolutePath();
                }
            }
            String[] arguments = new String[]{"-Dinstall4j.upgradeUninstall=" + this.upgrade, "-Dinstall4j.alternativeLogfile=" + (logFile == null ? "null" : logFile.getAbsolutePath()), "-cp", classpath, "com.install4j.runtime.installer.Uninstaller", "-q"};
            LaunchDescriptor launchDescriptor = new LaunchDescriptor(new File(System.getProperty("java.home"), "bin/java")).arguments(arguments).workingDirectory(new File(this.installationDirectory, "..")).wait(true);
            Integer returnValue = LaunchHelper.launchApplication(launchDescriptor);
            Logger.getInstance().info(this, "uninstaller process returned " + returnValue);
        }

        private void deleteWindowsUndelFiles(File undeletedLogFile) throws IOException {
            if (undeletedLogFile.exists()) {
                BufferedReader reader = new BufferedReader(new FileReader(undeletedLogFile));
                if (reader.readLine() != null) {
                    String name = reader.readLine();
                    while (name != null) {
                        if (!name.equals("") && !new File(name).delete()) {
                            System.out.println("could not delete " + name);
                        }
                        name = reader.readLine();
                    }
                }
                reader.close();
                undeletedLogFile.delete();
            } else {
                System.out.println(undeletedLogFile + " doesn't exist");
            }
        }
    }
}

