/*
 * Decompiled with CFR 0.152.
 */
package com.exe4j.runtime.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class ResourceHelper {
    private static final String URL_JAR_PREFIX = "jar:file:";
    private static final String URL_FILE_PREFIX = "file:";
    private static File runtimeDir;
    private static final String PROPERTY_INSTALL4J_RUNTIME_DIR = "install4j.runtimeDir";

    public static URL getImageURL(String fileName) {
        try {
            return new File(ResourceHelper.getRuntimeDir(), fileName).toURI().toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File getRuntimeDir() {
        if (runtimeDir == null) {
            String className = ResourceHelper.class.getName().replace('.', '/') + ".class";
            String simpleName = className.substring(className.lastIndexOf(47) + 1);
            String classLocation = ResourceHelper.class.getResource(simpleName).toString();
            String baseName = classLocation.substring(0, classLocation.lastIndexOf(className) - 1);
            int lastIndex = (baseName = ResourceHelper.getDecodedPath(baseName)).lastIndexOf(47);
            if (lastIndex == -1) {
                lastIndex = baseName.lastIndexOf(92);
            }
            if (lastIndex == -1 && !classLocation.startsWith("rsrc:")) {
                return null;
            }
            if (baseName.startsWith(URL_FILE_PREFIX)) {
                String externalRuntimeDir = System.getProperty(PROPERTY_INSTALL4J_RUNTIME_DIR);
                if (externalRuntimeDir != null && externalRuntimeDir.length() > 0) {
                    try {
                        runtimeDir = new File(externalRuntimeDir).getCanonicalFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    baseName = baseName.substring(URL_FILE_PREFIX.length(), lastIndex);
                    runtimeDir = new File(baseName, "../../c");
                }
            } else if (baseName.startsWith(URL_JAR_PREFIX)) {
                baseName = baseName.substring(URL_JAR_PREFIX.length(), lastIndex);
                runtimeDir = new File(baseName);
            } else {
                String moduleName = System.getProperty("exe4j.moduleName");
                if (moduleName != null) {
                    File file = new File(moduleName);
                    while (file.getParentFile() != null && !new File(file.getParentFile(), ".install4j").isDirectory()) {
                        file = file.getParentFile();
                    }
                    runtimeDir = new File(file.getParentFile(), ".install4j");
                }
            }
            if (runtimeDir == null) {
                throw new RuntimeException("cannot find runtime dir from " + classLocation + " or " + System.getProperty("exe4j.moduleName"));
            }
        }
        return runtimeDir;
    }

    private static String getDecodedPath(String path) {
        StringBuilder stringbuffer = new StringBuilder();
        int i = 0;
        while (i < path.length()) {
            char c = path.charAt(i);
            if (c != '%') {
                ++i;
            } else {
                try {
                    c = ResourceHelper.unescape(path, i);
                    i += 3;
                    if ((c & 0x80) != 0) {
                        switch (c >> 4) {
                            case 12: 
                            case 13: {
                                char c1 = ResourceHelper.unescape(path, i);
                                i += 3;
                                c = (char)((c & 0x1F) << 6 | c1 & 0x3F);
                                break;
                            }
                            case 14: {
                                char c2 = ResourceHelper.unescape(path, i);
                                char c3 = ResourceHelper.unescape(path, i += 3);
                                i += 3;
                                c = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException();
                }
            }
            stringbuffer.append(c);
        }
        return stringbuffer.toString();
    }

    private static char unescape(String s, int i) {
        return (char)Integer.parseInt(s.substring(i + 1, i + 3), 16);
    }

    private ResourceHelper() {
    }
}

