/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.ejt.framework.gui.ScreenSizeUtil;
import com.install4j.api.Util;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.VersionCheck;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JRootPane;

public abstract class CustomDialog
extends JDialog {
    protected CustomDialog(Window parentWindow) {
        super(parentWindow);
    }

    protected abstract int getFrameHeight();

    protected abstract int getFrameWidth();

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            GUIHelper.applyComponentOrientation(this);
        }
        super.setVisible(visible);
    }

    public Rectangle getFrameBounds() {
        float factor = 1.0f;
        if (InstallerUtil.isLinux() || InstallerUtil.isSolaris()) {
            factor = 1.2f;
        }
        int width = (int)(factor * (float)this.getFrameWidth());
        int height = (int)(factor * (float)this.getFrameHeight());
        if (width < 0 || height < 0) {
            this.pack();
            if (width < 0) {
                width = Math.max(-width, this.getWidth());
            }
            if (height < 0) {
                height = Math.max(-height, this.getHeight());
            }
        }
        return this.getFrameBounds(width, height);
    }

    public Rectangle getFrameBounds(int width, int height) {
        return ScreenSizeUtil.getFrameBounds(width, height, this.getParentWindow());
    }

    public Window getParentWindow() {
        return (Window)this.getParent();
    }

    @Override
    protected JRootPane createRootPane() {
        if (Util.isMacOS() && VersionCheck.checkCompatible("10.11", InstallerUtil.OS_VERSION)) {
            JRootPane rootPane = new JRootPane(){

                @Override
                public void setDefaultButton(final JButton defaultButton) {
                    if (defaultButton != null) {
                        final Color oldForeground = defaultButton.getForeground();
                        final Color correctedForeground = Color.WHITE;
                        defaultButton.setForeground(correctedForeground);
                        defaultButton.addPropertyChangeListener("Frame.active", new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent event) {
                                defaultButton.setForeground((Boolean)event.getNewValue() != false ? correctedForeground : oldForeground);
                            }
                        });
                    }
                    super.setDefaultButton(defaultButton);
                }
            };
            rootPane.setOpaque(true);
            return rootPane;
        }
        return super.createRootPane();
    }
}

