/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.exe4j.runtime.util.ReadIOException;
import com.install4j.api.ApplicationRegistry;
import com.install4j.api.SystemInfo;
import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.FileInfo;
import com.install4j.api.context.FileOptions;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.OverwriteMode;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerFileInstallationEvent;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.AbstractInstallFilesAction;
import com.install4j.runtime.beans.actions.InstallFilesAction;
import com.install4j.runtime.beans.actions.UninstallPreviousAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.frontend.VariableResourceBundleWrapper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchLongAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.content.ContentCollector;
import com.install4j.runtime.installer.helper.content.ContentStats;
import com.install4j.runtime.installer.helper.content.JreInstaller;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.lzma.LzmaInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ContentInstaller {
    public static final double DISK_SPACE_SAFETY_MARGIN_FACTOR = 1.1;
    private static ExecutionContext executionContext = ExecutionContext.UNELEVATED;
    private FileInstaller fileInstaller = FileInstaller.getInstance();
    private JreInstaller jreInstaller = JreInstaller.getInstance();
    private Set<String> installedUserJars = new HashSet<String>();
    private static ContentInstaller instance = new ContentInstaller();
    public static final long FILE_WEIGHT = 153600L;

    public static ContentInstaller getInstance() {
        return instance;
    }

    private ContentInstaller() {
    }

    public static ExecutionContext getExecutionContext() {
        return executionContext;
    }

    public static void setExecutionContext(final ExecutionContext executionContext) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.ALL, new RunAction(){

            @Override
            protected void run(Context context) {
                executionContext = executionContext;
            }
        });
    }

    public void doStandardInstallation(InstallerContext context, ProgressInterface progressInterface, InstallFilesAction installFilesAction) throws IOException, UserCanceledException {
        InstallerConfig config;
        boolean installJre;
        boolean installRuntime;
        if (context.isCancelling()) {
            return;
        }
        if (HelperCommunication.getInstance().isElevatedHelper()) {
            ContentInstaller.setExecutionContext(ExecutionContext.MAXIMUM);
        }
        if (installRuntime = installFilesAction.isInstallRuntime()) {
            this.fileInstaller.createDirectory(context.getInstallationDirectory());
        }
        progressInterface.setStatusMessage(Messages.getMessages().getString("StatusExtractFiles"));
        progressInterface.setDetailMessage("");
        ContentStats contentStats = ContentStats.getInstance();
        long maxProgress = contentStats.getSelectedContentSize();
        long fileCount = contentStats.getSelectedContentCount();
        boolean bl = installJre = !Boolean.getBoolean("install4j.noJreInstallation") && this.jreInstaller.checkJreInstallation(context.getInstallationDirectory(), installFilesAction.isUpdateBundledJre());
        if (installJre && installRuntime) {
            maxProgress += this.jreInstaller.getJreSize();
            fileCount += (long)this.jreInstaller.getJreCount();
        }
        progressInterface.setStatusMessage(Messages.getMessages().getString("StatusExtractFiles"));
        progressInterface.setDetailMessage("");
        ContextInt contextInt = ContextImpl.getContextInt(context);
        contextInt.fireInstallerEvent(new InstallerFileInstallationEvent(contextInt.getEventSource(), context, EventType.FILE_INSTALLATION_STARTED, maxProgress, fileCount));
        maxProgress += 153600L * fileCount;
        long currentProgress = 0L;
        Map<Comparable<String>, InputStream> contentNumbersToStreams = new ContentCollector(context, installFilesAction.isSaveDownloadedFiles(), installFilesAction.isAcceptAllCertificates()).collectContentStreams(null);
        progressInterface.setStatusMessage(Messages.getMessages().getString("StatusExtractFiles"));
        progressInterface.setDetailMessage("");
        if (Util.isMacosInstaller() && (config = InstallerConfig.getCurrentInstance()).getMacSpecificConfig().isSingleBundle()) {
            UnixFileSystem.FileInformation resourceAppDirInfo;
            File resourceAppDir = new File(context.getInstallationDirectory(), config.getMacSpecificConfig().getRuntimeDirParent());
            File realAppDir = new File(resourceAppDir.getParentFile().getParentFile(), "java/app");
            realAppDir.getParentFile().mkdirs();
            if (!(!resourceAppDir.exists() || realAppDir.exists() || (resourceAppDirInfo = UnixFileSystem.getFileInformation(resourceAppDir)) != null && resourceAppDirInfo.isLink())) {
                resourceAppDir.renameTo(realAppDir);
            }
            realAppDir.mkdirs();
            resourceAppDir.getParentFile().mkdirs();
            UnixFileSystem.createLink("../java/app", resourceAppDir);
        }
        if (installJre && installRuntime) {
            currentProgress = this.jreInstaller.installJre(context, progressInterface, installFilesAction, maxProgress, currentProgress);
        }
        for (InputStream contentStream : contentNumbersToStreams.values()) {
            currentProgress = this.installContent(context, contentStream, progressInterface, true, installFilesAction, maxProgress, currentProgress);
        }
        progressInterface.setDetailMessage("");
        if (installRuntime) {
            this.jreInstaller.writePreferredJre(context.getDestinationFile(".install4j"));
            this.createRuntimeDirectory(context, installFilesAction);
        }
        if (!context.isCancelling()) {
            progressInterface.setPercentCompleted(100);
        }
    }

    private long installContent(InstallerContext context, InputStream in, ProgressInterface progressInterface, boolean installInSingleBundle, AbstractInstallFilesAction installFilesAction, long maxProgress, long currentProgress) throws IOException, UserCanceledException {
        ZipEntry zipEntry;
        ZipInputStream zipIn;
        try {
            in = new BufferedInputStream(in);
            if (InstallerConfig.getCurrentInstance().isLzmaCompression()) {
                in = new LzmaInputStream(in);
            }
            zipIn = new ZipInputStream(in);
            zipEntry = zipIn.getNextEntry();
        }
        catch (Exception e) {
            throw new ReadIOException(e);
        }
        while (zipEntry != null) {
            if (context.isCancelling()) {
                throw new UserCanceledException();
            }
            String entryName = zipEntry.getName();
            entryName = InstallerUtil.isWindows() ? entryName.replace('/', '\\') : entryName.replace('\\', '/');
            boolean isUserJarLink = entryName.endsWith(".i4jlnk");
            if (isUserJarLink) {
                entryName = entryName.substring(0, entryName.length() - ".i4jlnk".length());
            }
            FileInfo fileInfo = ContextImpl.getContextInt(context).getDestinationFileInfo(entryName, installInSingleBundle);
            progressInterface.setDetailMessage(InstallerUtil.cleanupName(fileInfo.getRelativeFilePath()));
            File installationDirectoryForFile = fileInfo.getRootResolved();
            boolean shouldInstall = true;
            String filesetId = fileInfo.getFilesetId();
            if (filesetId.length() > 0 && !context.getFileSetById(filesetId).isSelected()) {
                shouldInstall = false;
            } else if (installationDirectoryForFile != null) {
                if (fileInfo.getRootUnresolved() != null && Objects.equals(fileInfo.getRelativeFilePath(), "\\") || Objects.equals(fileInfo.getRelativeFilePath(), "/") || Objects.equals(fileInfo.getRelativeFilePath(), "")) {
                    shouldInstall = false;
                } else {
                    ScriptProperty fileFilterScript = installFilesAction.getFileFilterScript();
                    if (fileFilterScript != null) {
                        try {
                            Boolean shouldInstallBoolean = (Boolean)context.runScript(fileFilterScript, installFilesAction, fileInfo);
                            shouldInstall = shouldInstallBoolean == null || shouldInstallBoolean != false;
                        }
                        catch (Exception e) {
                            Util.printAnnotatedStackTrace(e);
                            Logger.getInstance().log(e);
                            shouldInstall = false;
                        }
                    }
                    ScriptProperty directoryResolverScript = installFilesAction.getDirectoryResolverScript();
                    if (shouldInstall && directoryResolverScript != null) {
                        try {
                            File directory = (File)context.runScript(directoryResolverScript, installFilesAction, fileInfo);
                            if (directory != null) {
                                installationDirectoryForFile = directory;
                            }
                        }
                        catch (Exception e) {
                            Util.printAnnotatedStackTrace(e);
                            Logger.getInstance().log(e);
                            shouldInstall = false;
                        }
                    }
                }
            }
            if (installationDirectoryForFile == null) {
                shouldInstall = false;
            }
            InstallerConfig config = InstallerConfig.getCurrentInstance();
            long nextProgress = currentProgress + 153600L;
            File destFile = new File(installationDirectoryForFile, fileInfo.getRelativeFilePath());
            long lastModified = zipEntry.getTime();
            lastModified += (long)TimeZone.getDefault().getOffset(lastModified);
            if (zipEntry.isDirectory()) {
                if (shouldInstall) {
                    FileOptions fileOptions = config.getOptions(entryName);
                    UninstallMode uninstallMode = UninstallMode.IF_CREATED;
                    if (fileOptions != null) {
                        uninstallMode = fileOptions.getUninstallMode();
                    }
                    this.fileInstaller.createDirectory(destFile, uninstallMode);
                    destFile.setLastModified(lastModified);
                    if (fileOptions != null && !InstallerUtil.isWindows()) {
                        UnixFileSystem.setMode(fileOptions.getMode(), destFile);
                    }
                }
            } else {
                long fileSize = zipEntry.getSize();
                nextProgress += fileSize;
                if (shouldInstall) {
                    FileOptions fileOptions;
                    FilterInputStream usedIn = zipIn;
                    if (isUserJarLink) {
                        String jarName = new File(entryName).getName();
                        this.installedUserJars.add(jarName);
                        File additionalUserJarDir = ContextImpl.getContextInt(context).getAdditionalUserJarsDir();
                        File usedFile = additionalUserJarDir != null ? new File(additionalUserJarDir, jarName) : InstallerUtil.getInstallerFile("user/" + jarName);
                        fileSize = usedFile.length();
                        usedIn = new BufferedInputStream(new FileInputStream(usedFile));
                    }
                    if ((fileOptions = config.getOptions(entryName)) == null) {
                        fileOptions = new FileOptions();
                    }
                    fileOptions.setFileTime(lastModified);
                    fileOptions.setDelayIfNecessary(installFilesAction.isDelay());
                    this.fileInstaller.install(usedIn, destFile, fileOptions, new ProgressAdapter(progressInterface, (int)(currentProgress * 100L / maxProgress), (int)(nextProgress * 100L / maxProgress)), fileSize, config.isPack200Compression());
                    if (isUserJarLink) {
                        ((InputStream)usedIn).close();
                    }
                }
            }
            if (context.isCancelling()) {
                throw new UserCanceledException();
            }
            currentProgress = nextProgress;
            progressInterface.setPercentCompleted((int)(currentProgress * 100L / maxProgress));
            try {
                zipEntry = zipIn.getNextEntry();
            }
            catch (Exception e) {
                throw new ReadIOException(e);
            }
        }
        try {
            zipIn.close();
        }
        catch (Exception e) {
            throw new ReadIOException(e);
        }
        return currentProgress;
    }

    public static String replaceSlashes(String name) {
        return name.replace('/', ' ').replace('\\', ' ').replace(':', ' ').replace(';', ' ');
    }

    private void createRuntimeDirectory(Context context, InstallFilesAction installFilesAction) throws IOException, UserCanceledException {
        boolean addOnInstaller = InstallerConfig.getCurrentInstance().isAddOnInstaller();
        FileOptions runtimeFileOptions = new FileOptions(OverwriteMode.ALWAYS, UninstallMode.ALWAYS);
        runtimeFileOptions.setDelayIfNecessary(installFilesAction.isDelay());
        File currentDir = new File(System.getProperty("user.dir"));
        File runtimeLibrarySource = new File(currentDir, "i4jruntime.jar");
        File runtimeDestDirectory = context.getDestinationFile(".install4j");
        File runtimeLibraryDest = new File(runtimeDestDirectory, "i4jruntime.jar");
        this.fileInstaller.createDirectory(runtimeDestDirectory, UninstallMode.ALWAYS);
        if (!addOnInstaller) {
            this.fileInstaller.install(runtimeLibrarySource, runtimeLibraryDest, runtimeFileOptions);
        }
        String suffix = "";
        if (InstallerConfig.getCurrentInstance().isAddOnInstaller()) {
            suffix = "." + InstallerConfig.getCurrentInstance().getProjectCrc();
        }
        this.fileInstaller.install(new File(currentDir, "MessagesDefault"), new File(runtimeDestDirectory, "MessagesDefault"), runtimeFileOptions);
        this.fileInstaller.install(new File(currentDir, "i4jparams.conf"), new File(runtimeDestDirectory, "i4jparams.conf" + suffix), runtimeFileOptions);
        this.fileInstaller.install(new File(currentDir, "stats.properties"), new File(runtimeDestDirectory, "stats.properties" + suffix), runtimeFileOptions);
        File emptyFontFile = new File(currentDir, "i4jempty.ttf");
        if (emptyFontFile.isFile()) {
            this.fileInstaller.install(emptyFontFile, new File(runtimeDestDirectory, "i4jempty.ttf"), runtimeFileOptions);
        }
        int logFileIndex = 0;
        for (File file : UninstallPreviousAction.getLogFiles()) {
            this.installIfExists(file.getName(), suffix, file.getParentFile(), runtimeDestDirectory, runtimeFileOptions, null, Logger.getUninstallPreviousLogFileName(logFileIndex++));
        }
        new File(runtimeDestDirectory, "launchers.xml" + suffix).delete();
        this.installIfExists("launchers.xml", suffix, currentDir, runtimeDestDirectory, runtimeFileOptions, null);
        this.installIfExists("user.jar", suffix, currentDir, runtimeDestDirectory, runtimeFileOptions, null);
        this.installIfExists("user", suffix, currentDir, runtimeDestDirectory, runtimeFileOptions, this.installedUserJars);
        ContextInt contextInt = ContextImpl.getContextInt(context);
        File additionalUserJars = contextInt.getAdditionalUserJarsDir();
        if (additionalUserJars != null) {
            this.installIfExists(additionalUserJars.getName(), suffix, additionalUserJars.getParentFile(), runtimeDestDirectory, runtimeFileOptions, this.installedUserJars, "user");
        }
        runtimeFileOptions.setMode("755");
        this.installIfExists("install4j", suffix, currentDir, runtimeDestDirectory, runtimeFileOptions, null);
        runtimeFileOptions.setMode("644");
        File[] files = new File(System.getProperty("user.dir")).listFiles();
        if (files != null) {
            for (File file : files) {
                String lcFileName = file.getName().toLowerCase(Locale.ENGLISH);
                if (!ContentInstaller.isAdditionalRuntimeFileInstalled(addOnInstaller, lcFileName)) continue;
                this.fileInstaller.install(file, new File(runtimeDestDirectory, file.getName()), runtimeFileOptions);
            }
        }
    }

    private static boolean isAdditionalRuntimeFileInstalled(boolean addOnInstaller, String lcFileName) {
        if (lcFileName.startsWith("i4j_extf_")) {
            return true;
        }
        if (Objects.equals(lcFileName, "installer.ico")) {
            return true;
        }
        if (!addOnInstaller) {
            return lcFileName.endsWith(".dll") || lcFileName.endsWith(".exe") || lcFileName.endsWith(".dylib");
        }
        return false;
    }

    private void installIfExists(String fileName, String suffix, File currentDir, File runtimeDestDirectory, FileOptions runtimeFileOptions, Set<String> unusedFileNames) throws UserCanceledException, IOException {
        this.installIfExists(fileName, suffix, currentDir, runtimeDestDirectory, runtimeFileOptions, unusedFileNames, fileName);
    }

    private void installIfExists(String fileName, String suffix, File currentDir, File runtimeDestDirectory, FileOptions runtimeFileOptions, Set<String> unusedFileNames, String destName) throws UserCanceledException, IOException {
        File file = new File(currentDir, fileName);
        if (file.exists()) {
            File destFile = new File(runtimeDestDirectory, destName + suffix);
            if (file.isDirectory()) {
                this.fileInstaller.createDirectory(destFile);
                File[] files = file.listFiles();
                if (files != null) {
                    for (File childFile : files) {
                        String name = childFile.getName();
                        if (unusedFileNames != null && (unusedFileNames.contains(name) || name.endsWith(".pack"))) continue;
                        this.installIfExists(name, "", file, destFile, runtimeFileOptions, unusedFileNames);
                    }
                }
            } else {
                this.fileInstaller.install(file, destFile, runtimeFileOptions);
            }
        }
    }

    public void setPreferredJre(String jreHome) {
        this.jreInstaller.setPreferredJre(jreHome);
    }

    public long getMinSize() {
        try {
            return this.jreInstaller.getJreSize() + ContentInstaller.getMinContentSize();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private static long getMinContentSize() {
        return HelperCommunication.getInstance().fetchLong(ExecutionContext.UNELEVATED, new FetchLongAction(){

            @Override
            protected long fetchValue(Context context) throws UserCanceledException {
                long minSize;
                InstallFilesAction installFilesAction = (InstallFilesAction)context.getFirstAction(InstallFilesAction.class, null);
                try {
                    File[] runtimeFiles;
                    File[] userFiles;
                    minSize = ContentStats.getInstance().getSelectedContentSize();
                    File userDir = InstallerUtil.getInstallerFile("user");
                    if (userDir.isDirectory() && (userFiles = userDir.listFiles()) != null) {
                        for (File userFile : userFiles) {
                            if (!userFile.isFile()) continue;
                            minSize += userFile.length();
                        }
                    }
                    if ((runtimeFiles = userDir.getParentFile().listFiles()) != null) {
                        for (File runtimeFile : runtimeFiles) {
                            if (!runtimeFile.isFile() || Objects.equals(runtimeFile.getName(), "jre.tar.gz")) continue;
                            minSize += runtimeFile.length();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return 0L;
                }
                if (installFilesAction != null) {
                    try {
                        Long customMinSize = (Long)context.runScript(installFilesAction.getSizeCalculatorScript(), installFilesAction, minSize);
                        if (customMinSize != null) {
                            minSize = customMinSize;
                        }
                    }
                    catch (Exception e) {
                        Util.printAnnotatedStackTrace(e);
                        Logger.getInstance().log(e);
                    }
                }
                return minSize;
            }
        });
    }

    public static File validateInstallationDir(File dir, boolean validateApplicationId, boolean checkFreeSpace, boolean existingDirWarning, boolean unattended, boolean alternateMessages) {
        boolean update;
        boolean noSingleBundle;
        VariableResourceBundleWrapper messages = Messages.getMessages();
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        boolean bl = noSingleBundle = !Util.isMacosInstaller() || !installerConfig.getMacSpecificConfig().isSingleBundle();
        if (noSingleBundle && !ApplicationRegistry.checkApplicationId(dir)) {
            File singleBundleDir;
            if (validateApplicationId) {
                if (!installerConfig.isAddOnInstaller()) {
                    Util.showMessage(messages.getString(alternateMessages ? "DifferentApplication2" : "DifferentApplication"), 1);
                } else {
                    File singleBundleDir2;
                    if (Util.isMacosInstaller() && ApplicationRegistry.checkApplicationId(singleBundleDir2 = new File(dir, "Contents/Resources/app"))) {
                        return singleBundleDir2;
                    }
                    Util.showMessage(messages.getString(alternateMessages ? "NoTargetApplication2" : "NoTargetApplication"), 1);
                }
                return null;
            }
            if (Util.isMacosInstaller() && installerConfig.isAddOnInstaller() && ApplicationRegistry.checkApplicationId(singleBundleDir = new File(dir, "Contents/Resources/app"))) {
                return singleBundleDir;
            }
        }
        if (!(update = ApplicationRegistry.isUpdateDirectory(dir)) && checkFreeSpace) {
            long minSize = (long)((double)ContentInstaller.getInstance().getMinSize() * 1.1);
            long freeSize = SystemInfo.getFreeDiskSpace(dir);
            if (freeSize != -1L && minSize > freeSize) {
                try {
                    if (InstallerUtil.isUnattended()) {
                        System.err.println("Not enough disk space for target directory: " + dir.getAbsolutePath());
                        return null;
                    }
                    int result = Util.showOptionDialog(Messages.format(messages.getString("DiskSpaceWarning"), String.valueOf(minSize / 1024L), String.valueOf(freeSize / 1024L)), new String[]{messages.getString("ButtonYes"), messages.getString("ButtonNo")}, 3);
                    if (result == 1) {
                        return null;
                    }
                }
                catch (UserCanceledException e) {
                    return null;
                }
            }
        }
        if (!installerConfig.isAddOnInstaller() && existingDirWarning && dir.exists() && !update && !unattended && noSingleBundle) {
            try {
                int result = Util.showOptionDialog(Messages.format(messages.getString("DirExists"), dir.getAbsolutePath()), new String[]{messages.getString("ButtonYes"), messages.getString("ButtonNo")}, 3);
                if (result != 0) {
                    return null;
                }
            }
            catch (UserCanceledException e) {
                return null;
            }
        }
        return dir;
    }

    public void cleanup() {
        ContentInstaller.cleanupInt();
    }

    private static void cleanupInt() {
        HelperCommunication.getInstance().executeAction(executionContext, new RunAction(){

            @Override
            protected void run(Context context) {
                ContentInstaller.getInstance().jreInstaller.cleanup();
            }
        });
    }

    public void rollback() {
        ContentInstaller.rollbackInt();
    }

    private static void rollbackInt() {
        HelperCommunication.getInstance().executeAction(executionContext, new RunAction(){

            @Override
            protected void run(Context context) {
                ContentInstaller.getInstance().jreInstaller.rollback();
            }
        });
    }

    public void doComponentInstallation(InstallerContext context, ProgressInterface progressInterface, String componentId, boolean installInSingleBundle, AbstractInstallFilesAction abstractInstallFilesAction) throws IOException, UserCanceledException {
        if (context.isCancelling()) {
            return;
        }
        if (HelperCommunication.getInstance().isElevatedHelper()) {
            ContentInstaller.setExecutionContext(ExecutionContext.MAXIMUM);
        }
        progressInterface.setStatusMessage(Messages.getMessages().getString("StatusExtractFiles"));
        progressInterface.setDetailMessage("");
        ContentStats contentStats = ContentStats.getInstance();
        long maxProgress = contentStats.getSelectedContentSize(componentId);
        long fileCount = contentStats.getSelectedContentCount(componentId);
        progressInterface.setStatusMessage(Messages.getMessages().getString("StatusExtractFiles"));
        progressInterface.setDetailMessage("");
        maxProgress += 153600L * fileCount;
        long currentProgress = 0L;
        Map<Comparable<String>, InputStream> contentNumbersToStreams = new ContentCollector(context, false, abstractInstallFilesAction.isAcceptAllCertificates()).collectContentStreams(componentId);
        progressInterface.setStatusMessage(Messages.getMessages().getString("StatusExtractFiles"));
        progressInterface.setDetailMessage("");
        for (InputStream contentStream : contentNumbersToStreams.values()) {
            currentProgress = this.installContent(context, contentStream, progressInterface, installInSingleBundle, abstractInstallFilesAction, maxProgress, currentProgress);
        }
        progressInterface.setDetailMessage("");
        if (!context.isCancelling()) {
            progressInterface.setPercentCompleted(100);
        }
    }
}

