/*
 * Decompiled with CFR 0.152.
 */
package com.exe4j.runtime.splash;

import com.exe4j.runtime.LauncherEngine;
import com.exe4j.runtime.util.ArgumentStack;
import java.awt.Color;
import java.awt.Point;
import java.util.StringTokenizer;

public class TextLineConfig {
    private String text;
    private int fontSize;
    private int fontWeight;
    private int fontColorR;
    private int fontColorG;
    private int fontColorB;
    private int positionX;
    private int positionY;

    TextLineConfig(ArgumentStack argStack) {
        this.text = argStack.popString();
        this.positionX = argStack.popInt();
        this.positionY = argStack.popInt();
        argStack.popString();
        this.parseColor(argStack.popString());
        this.fontSize = argStack.popInt();
        this.fontWeight = argStack.popInt();
    }

    public TextLineConfig(int base) {
        this.text = LauncherEngine.getProperty(base + 2);
        this.positionX = LauncherEngine.getIntProperty(base + 0);
        this.positionY = LauncherEngine.getIntProperty(base + 1);
        this.parseColor(LauncherEngine.getProperty(base + 5));
        this.fontSize = LauncherEngine.getIntProperty(base + 4);
        this.fontWeight = LauncherEngine.getIntProperty(base + 6);
    }

    public TextLineConfig(String text, int positionX, int positionY, String color, int fontSize, int fontWeight) {
        this.text = text;
        this.positionX = positionX;
        this.positionY = positionY;
        this.parseColor(color);
        this.fontSize = fontSize;
        this.fontWeight = fontWeight;
    }

    public Color getFontColor() {
        return new Color(this.fontColorR, this.fontColorG, this.fontColorB);
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public int getFontWeight() {
        return this.fontWeight;
    }

    public String getText() {
        return this.text;
    }

    public Point getPosition() {
        return new Point(this.positionX, this.positionY);
    }

    public int getFontStyle() {
        return this.fontWeight > 500 ? 1 : 0;
    }

    private void parseColor(String color) {
        if (color != null) {
            StringTokenizer colorTokenizer = new StringTokenizer(color, ",");
            this.fontColorR = Integer.parseInt(colorTokenizer.nextToken());
            this.fontColorG = Integer.parseInt(colorTokenizer.nextToken());
            this.fontColorB = Integer.parseInt(colorTokenizer.nextToken());
        }
    }
}

