/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quickstart;

import java.io.FileOutputStream;
import java.util.Locale;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.quickstart.PreconfigureDescriptorProcessor;
import org.eclipse.jetty.quickstart.QuickStartConfiguration;
import org.eclipse.jetty.quickstart.QuickStartDescriptorGenerator;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;

public class QuickStartWebApp
extends WebAppContext {
    private static final Logger LOG = Log.getLogger(QuickStartWebApp.class);
    public static final String[] __configurationClasses = new String[]{QuickStartConfiguration.class.getCanonicalName(), EnvConfiguration.class.getCanonicalName(), PlusConfiguration.class.getCanonicalName(), JettyWebXmlConfiguration.class.getCanonicalName()};
    private boolean _preconfigure = false;
    private boolean _autoPreconfigure = false;
    private boolean _startWebapp = false;
    private PreconfigureDescriptorProcessor _preconfigProcessor;
    private String _originAttribute;
    private boolean _generateOrigin;
    public static final String[] __preconfigurationClasses = new String[]{WebInfConfiguration.class.getCanonicalName(), WebXmlConfiguration.class.getCanonicalName(), MetaInfConfiguration.class.getCanonicalName(), FragmentConfiguration.class.getCanonicalName(), EnvConfiguration.class.getCanonicalName(), PlusConfiguration.class.getCanonicalName(), AnnotationConfiguration.class.getCanonicalName()};

    public QuickStartWebApp() {
        this.setConfigurationClasses(__preconfigurationClasses);
    }

    public boolean isPreconfigure() {
        return this._preconfigure;
    }

    public void setPreconfigure(boolean preconfigure) {
        this._preconfigure = preconfigure;
    }

    public boolean isAutoPreconfigure() {
        return this._autoPreconfigure;
    }

    public void setAutoPreconfigure(boolean autoPrecompile) {
        this._autoPreconfigure = autoPrecompile;
    }

    public void setOriginAttribute(String name) {
        this._originAttribute = name;
    }

    public String getOriginAttribute() {
        return this._originAttribute;
    }

    public boolean getGenerateOrigin() {
        return this._generateOrigin;
    }

    public void setGenerateOrigin(boolean generateOrigin) {
        this._generateOrigin = generateOrigin;
    }

    @Override
    public void contextInitialized() throws Exception {
        if (this._startWebapp) {
            super.contextInitialized();
        }
    }

    @Override
    public void contextDestroyed() throws Exception {
        if (this._startWebapp) {
            super.contextDestroyed();
        }
    }

    @Override
    protected void startWebapp() throws Exception {
        if (this.isPreconfigure()) {
            this.generateQuickstartWebXml(this._preconfigProcessor.getXML());
        }
        if (this._startWebapp) {
            super.startWebapp();
        }
    }

    @Override
    protected void stopWebapp() throws Exception {
        if (!this._startWebapp) {
            return;
        }
        super.stopWebapp();
    }

    @Override
    protected void doStart() throws Exception {
        Resource war = null;
        Resource dir = null;
        Resource base = this.getBaseResource();
        if (base == null) {
            base = Resource.newResource(this.getWar());
        }
        if (base.isDirectory()) {
            dir = base;
        } else if (base.toString().toLowerCase(Locale.ENGLISH).endsWith(".war")) {
            war = base;
            String w = war.toString();
            dir = Resource.newResource(w.substring(0, w.length() - 4));
            if (!dir.exists()) {
                LOG.info("Quickstart Extract " + war + " to " + dir, new Object[0]);
                dir.getFile().mkdirs();
                JarResource.newJarResource(war).copyTo(dir.getFile());
            }
            this.setWar(null);
            this.setBaseResource(dir);
        } else {
            throw new IllegalArgumentException();
        }
        Resource qswebxml = dir.addPath("/WEB-INF/quickstart-web.xml");
        if (this.isPreconfigure()) {
            this._preconfigProcessor = new PreconfigureDescriptorProcessor();
            this.getMetaData().addDescriptorProcessor(this._preconfigProcessor);
            this._startWebapp = false;
        } else if (qswebxml.exists()) {
            this.setConfigurationClasses(__configurationClasses);
            this._startWebapp = true;
        } else if (this._autoPreconfigure) {
            LOG.info("Quickstart preconfigure: {}(war={},dir={})", this, war, dir);
            this._preconfigProcessor = new PreconfigureDescriptorProcessor();
            this.getMetaData().addDescriptorProcessor(this._preconfigProcessor);
            this.setPreconfigure(true);
            this._startWebapp = true;
        } else {
            this._startWebapp = true;
        }
        super.doStart();
    }

    public void generateQuickstartWebXml(String extraXML) throws Exception {
        Resource descriptor = this.getWebInf().addPath("quickstart-web.xml");
        if (!descriptor.exists()) {
            descriptor.getFile().createNewFile();
        }
        QuickStartDescriptorGenerator generator = new QuickStartDescriptorGenerator(this, extraXML, this._originAttribute, this._generateOrigin);
        try (FileOutputStream fos = new FileOutputStream(descriptor.getFile());){
            generator.generateQuickStartWebXml(fos);
        }
    }
}

