/*
 * Decompiled with CFR 0.152.
 */
package com.jscape.inet.gateway.adapter.web;

import com.jscape.a.Page;
import com.jscape.a.PageRequest;
import com.jscape.inet.gateway.adapter.web.Encrypted;
import com.jscape.inet.gateway.adapter.web.a;
import com.jscape.inet.gateway.adapter.web.b;
import com.jscape.inet.gateway.adapter.web.c;
import com.jscape.inet.gateway.adapter.web.e;
import com.jscape.inet.gateway.adapter.web.f;
import com.jscape.inet.gateway.adapter.web.h;
import com.jscape.inet.gateway.adapter.web.protocol.messages.ErrorCode;
import com.jscape.inet.gateway.adapter.web.protocol.messages.ErrorSummary;
import com.jscape.inet.gateway.adapter.web.protocol.messages.NewPasswordData;
import com.jscape.inet.gateway.adapter.web.protocol.messages.SubmitState;
import com.jscape.inet.gateway.operation.BlockIpRequest;
import com.jscape.inet.gateway.operation.IpAccessConfiguration;
import com.jscape.inet.gateway.operation.ac;
import com.jscape.inet.gateway.operation.administrator.AdministratorData;
import com.jscape.inet.gateway.operation.administrator.AdministratorSessionSummary;
import com.jscape.inet.gateway.operation.administrator.AdministratorSummary;
import com.jscape.inet.gateway.operation.agent.AgentServiceConfiguration;
import com.jscape.inet.gateway.operation.agent.GatewayAgentData;
import com.jscape.inet.gateway.operation.agent.GatewayAgentSessionSummary;
import com.jscape.inet.gateway.operation.agent.GatewayAgentSummary;
import com.jscape.inet.gateway.operation.authentication.credentials.PasswordCredentials;
import com.jscape.inet.gateway.operation.cluster.ClusterData;
import com.jscape.inet.gateway.operation.cluster.ClusterInfo;
import com.jscape.inet.gateway.operation.cluster.ClusterSummary;
import com.jscape.inet.gateway.operation.database.DatabaseConfiguration;
import com.jscape.inet.gateway.operation.database.DatabaseTestResult;
import com.jscape.inet.gateway.operation.email.EmailServiceConfiguration;
import com.jscape.inet.gateway.operation.j;
import com.jscape.inet.gateway.operation.jmx.JmxServiceConfiguration;
import com.jscape.inet.gateway.operation.key.CertificateGenerationData;
import com.jscape.inet.gateway.operation.key.CertificateImportData;
import com.jscape.inet.gateway.operation.key.ServerKeyGenerationData;
import com.jscape.inet.gateway.operation.key.ServerKeyImportData;
import com.jscape.inet.gateway.operation.key.ServerKeySummary;
import com.jscape.inet.gateway.operation.l;
import com.jscape.inet.gateway.operation.log.LogRecord;
import com.jscape.inet.gateway.operation.log.LogServiceConfiguration;
import com.jscape.inet.gateway.operation.m;
import com.jscape.inet.gateway.operation.monitor.MonitorServiceConfiguration;
import com.jscape.inet.gateway.operation.proxy.ProxyServiceData;
import com.jscape.inet.gateway.operation.proxy.ProxyServiceSummary;
import com.jscape.inet.gateway.operation.proxy.ProxySessionSummary;
import com.jscape.inet.gateway.operation.s;
import com.jscape.inet.gateway.operation.statistics.ServerParameters;
import com.jscape.inet.gateway.operation.statistics.ServerStatistics;
import com.jscape.inet.gateway.operation.web.WebServiceConfiguration;
import com.jscape.util.FileService;
import com.jscape.util.a2;
import com.jscape.util.aH;
import com.jscape.util.aS;
import com.jscape.util.aW;
import com.jscape.util.io.ByteArrayOutputStream;
import com.jscape.util.io.LimitedInputStream;
import com.jscape.util.net.TransportAddress;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="/")
@OpenAPIDefinition(servers={@Server(url="/api", description="Gateway management operations")}, info=@Info(title="Gateway REST API", version="1.6"), tags={@Tag(name="Authentication", description="Authentication Operations"), @Tag(name="Status", description="Status Operations"), @Tag(name="Proxies", description="Proxies Operations"), @Tag(name="Clusters", description="Clusters Operations"), @Tag(name="IP Access", description="IP Access Operations"), @Tag(name="Logs", description="Logs Operations"), @Tag(name="Monitor", description="Monitor Operations"), @Tag(name="Administrators", description="Administrators Operations"), @Tag(name="Agents", description="Agents Operations"), @Tag(name="Database", description="Database Operations"), @Tag(name="Keys", description="Keys Operations"), @Tag(name="Email", description="Email Operations"), @Tag(name="Web", description="Web Operations"), @Tag(name="JMX", description="JMX Operations"), @Tag(name="Files", description="File Operations"), @Tag(name="Service", description="Service Operations"), @Tag(name="Misc", description="Miscellaneous Operations")})
@a2
public class ApiServer {
    private static final int MAX_LICENSE_FILE_SIZE = 2048;
    private final HttpServletRequest request;
    private final boolean debugAllowed;
    private final s sessionManager;
    private final String sessionId;
    private final Logger logger;
    private HttpSession httpSession;
    private static final String[] a;

    public ApiServer(@Context ServletContext servletContext, @Context HttpServletRequest httpServletRequest) {
        aW.a(httpServletRequest);
        this.request = httpServletRequest;
        this.debugAllowed = (Boolean)com.jscape.inet.gateway.adapter.web.a.DEBUG_ALLOWED.of(servletContext);
        this.httpSession = this.request.getSession();
        this.initHttpConnectionAddresses();
        this.sessionManager = (s)com.jscape.inet.gateway.adapter.web.a.SESSION_MANAGER.of(servletContext);
        this.sessionId = (String)c.SESSION_ID.of(this.httpSession);
        this.logger = Logger.getLogger(a[0]);
        this.logRequest();
    }

    @GET
    @Path(value="/test")
    @Produces(value={"text/plain"})
    @Operation(summary="Test API", description="Tests an API accessibility.", responses={@ApiResponse(responseCode="200", description="Test result", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Tags(value={@Tag(name="Misc")})
    public String test() {
        return a[11];
    }

    @GET
    @Path(value="/csrf-token")
    @Produces(value={"text/plain"})
    @Operation(summary="Get CSRF token", description="Obtains current CSRF token.", responses={@ApiResponse(responseCode="200", description="CSRF token", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Tags(value={@Tag(name="Service")})
    public String csrfToken() {
        String string = f.a(this.httpSession.getId());
        c.ENCRYPTION_PASSWORD.set(this.httpSession, string);
        return string;
    }

    @POST
    @Path(value="/login")
    @Consumes(value={"application/json"})
    @Operation(summary="Login API", description="Performs user authentication for accessing API.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Authentication")})
    public void login(@Parameter(description="Authentication credentials", required=true) PasswordCredentials passwordCredentials, @Parameter(description="Encryption required", required=false) @QueryParam(value="encryptionRequired") boolean bl2) throws h {
        this.assertCsrfTokenValid();
        this.logout();
        try {
            this.httpSession = this.request.getSession(true);
            this.initHttpConnectionAddresses();
            ac ac2 = this.sessionManager.a(new e(this.httpSession, null));
            c.SESSION_ID.set(this.httpSession, ac2.a());
            try {
                ac2.a(passwordCredentials);
                c.ENCRYPTION_REQUIRED.set(this.httpSession, bl2);
            }
            catch (Exception exception) {
                ac2.f();
                throw exception;
            }
        }
        catch (l l10) {
            this.cleanupHttpSession();
            String[] stringArray = a;
            throw new h(ErrorCode.NOT_AUTHENTICATED, stringArray[15], "");
        }
        catch (m m10) {
            this.cleanupHttpSession();
            throw new h(ErrorCode.NOT_AUTHENTICATED, a[12], "");
        }
        catch (Throwable throwable) {
            this.cleanupHttpSession();
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/logout")
    @Operation(summary="Logout API", description="Performs user logout.")
    @Tags(value={@Tag(name="Authentication")})
    public void logout() {
        try {
            if (this.sessionId != null) {
                ac ac2 = this.session();
                ac2.f();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.cleanupHttpSession();
            this.closeHttpSession();
        }
    }

    @POST
    @Path(value="/login/test")
    @Operation(summary="Check user logged in", description="Checks if user is still logged in.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Authentication")})
    public void assertLoggedIn() throws h {
        this.assertAuthenticated();
    }

    @POST
    @Path(value="/password-changing/start")
    @Consumes(value={"application/json"})
    @Operation(summary="Start password changing", description="Starts password changing procedure.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Authentication")})
    public void startPasswordChanging(String string) throws h {
        this.assertCsrfTokenValid();
        this.logout();
        try {
            this.httpSession = this.request.getSession(true);
            this.initHttpConnectionAddresses();
            ac ac2 = this.sessionManager.a(new e(this.httpSession, null));
            c.SESSION_ID.set(this.httpSession, ac2.a());
            try {
                ac2.b(string);
            }
            catch (Exception exception) {
                ac2.f();
                throw exception;
            }
        }
        catch (j j10) {
            this.cleanupHttpSession();
            throw new h(ErrorCode.INVALID_OPERATION_DATA, a[2], "");
        }
        catch (Throwable throwable) {
            this.cleanupHttpSession();
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/password-changing/finish")
    @Consumes(value={"application/json"})
    @Operation(summary="Finish password changing", description="Finishes password changing procedure.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Authentication")})
    public void finishPasswordChanging(NewPasswordData newPasswordData) throws h {
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            try {
                ac2.a(newPasswordData.securityCode, newPasswordData.password);
            }
            finally {
                ac2.f();
            }
        }
        catch (Throwable throwable) {
            this.cleanupHttpSession();
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/server/parameters")
    @Produces(value={"application/json"})
    @Operation(summary="Get server parameters", description="Obtains server parameters.", responses={@ApiResponse(responseCode="200", description="Server parameters", content={@Content(schema=@Schema(implementation=ServerParameters.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Status")})
    public ServerParameters serverParameters() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.d();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/server/parameters/addresses")
    @Produces(value={"application/json"})
    @Operation(summary="Get server IP's", description="Obtains available server IP's.", responses={@ApiResponse(responseCode="200", description="Server IP's", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Status")})
    public String[] serverAddresses() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.e();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/server/statistics")
    @Produces(value={"application/json"})
    @Operation(summary="Get server statistics", description="Obtains current server statistics.", responses={@ApiResponse(responseCode="200", description="Server statistics", content={@Content(schema=@Schema(implementation=ServerStatistics.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Status")})
    public ServerStatistics serverStatistics() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.f();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/license")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    @Operation(summary="Import license", description="Imports an application license.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Service")})
    public void importLicense(@Parameter(description="Form", required=true) FormDataMultiPart formDataMultiPart, @Parameter(description="License file", required=true) @FormDataParam(value="dataFile") InputStream inputStream) throws h {
        this.assertCsrfTokenValid(formDataMultiPart);
        this.assertAuthenticated();
        try {
            ac ac2 = this.session();
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.inProgress());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            aH.b((InputStream)new LimitedInputStream(inputStream, 2048L, false), (OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.d();
            ac2.a(byArray);
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.done());
        }
        catch (Throwable throwable) {
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.error(throwable));
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/proxies")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Get proxy services", description="Obtains available proxy services.", responses={@ApiResponse(responseCode="200", description="Proxy service summary", content={@Content(schema=@Schema(implementation=ProxyServiceSummary.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Proxies")})
    public ProxyServiceSummary[] proxyServices() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            List<ProxyServiceSummary> list = ac2.h();
            return list.toArray(new ProxyServiceSummary[0]);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/proxy")
    @Produces(value={"application/json"})
    @Operation(summary="Get proxy service", description="Obtains a proxy service data.", responses={@ApiResponse(responseCode="200", description="Proxy service data", content={@Content(schema=@Schema(implementation=ProxyServiceData.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Proxies")})
    public ProxyServiceData proxyServiceFor(@Parameter(description="Service ID", required=true) @QueryParam(value="id") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.c(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @PUT
    @Path(value="/proxy")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Add proxy service", description="Adds a new proxy service.", responses={@ApiResponse(responseCode="200", description="Proxy service summary", content={@Content(schema=@Schema(implementation=ProxyServiceSummary.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Proxies")})
    public ProxyServiceSummary addProxyService(@Parameter(description="Data", required=true) ProxyServiceData proxyServiceData) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.a(proxyServiceData);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/proxy")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update proxy service", description="Updates a new proxy service.", responses={@ApiResponse(responseCode="200", description="Proxy service summary", content={@Content(schema=@Schema(implementation=ProxyServiceSummary.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Proxies")})
    public ProxyServiceSummary updateProxyService(@Parameter(description="Data", required=true) ProxyServiceData proxyServiceData) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.b(proxyServiceData);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/proxy/start")
    @Operation(summary="Start proxy service", description="Starts a new proxy service.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Proxies")})
    public void startProxyService(@Parameter(description="Service ID", required=true) @QueryParam(value="id") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            ac2.d(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/proxy/stop")
    @Operation(summary="Stop proxy service", description="Stops a new proxy service.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Proxies")})
    public void stopProxyService(@Parameter(description="Service ID", required=true) @QueryParam(value="id") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            ac2.e(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @DELETE
    @Path(value="/proxy")
    @Operation(summary="Delete proxy service", description="Deletes a new proxy service.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Proxies")})
    public void removeProxyService(@Parameter(description="Service ID", required=true) @QueryParam(value="id") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            ac2.f(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/proxy/http/cache/clear")
    @Operation(summary="Clear HTTP service cache", description="Clears an HTTP service cache.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Proxies")})
    public void clearHttpProxyServiceCache(@Parameter(description="Service ID", required=true) @QueryParam(value="id") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            ac2.g(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/proxy/sessions")
    @Produces(value={"application/json"})
    @Operation(summary="Get proxy sessions", description="Obtains current proxy sessions.", responses={@ApiResponse(responseCode="200", description="Proxy session summary", content={@Content(schema=@Schema(implementation=ProxySessionSummary.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Proxies")})
    public ProxySessionSummary[] proxySessions() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            List<ProxySessionSummary> list = ac2.i();
            return list.toArray(new ProxySessionSummary[0]);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/proxy/session/close")
    @Operation(summary="Close proxy session", description="Closes specified proxy session.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Proxies")})
    public void closeProxySession(@Parameter(description="ID", required=true) @QueryParam(value="id") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            ac2.h(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/clusters")
    @Produces(value={"application/json"})
    @Operation(summary="Get clusters", description="Obtains available clusters.", responses={@ApiResponse(responseCode="200", description="Cluster info", content={@Content(schema=@Schema(implementation=ClusterInfo.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Clusters")})
    public ClusterInfo[] clusters() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            List<ClusterInfo> list = ac2.j();
            return list.toArray(new ClusterInfo[0]);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/clusters")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Get clusters", description="Obtains available clusters.", responses={@ApiResponse(responseCode="200", description="Page", content={@Content(schema=@Schema(implementation=Page.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Clusters")})
    public Page<ClusterSummary> clustersFor(@Parameter(description="Page request", required=true) PageRequest pageRequest) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.a(pageRequest);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/cluster")
    @Produces(value={"application/json"})
    @Operation(summary="Get cluster data", description="Obtains a cluster data.", responses={@ApiResponse(responseCode="200", description="Cluster data", content={@Content(schema=@Schema(implementation=ClusterData.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Clusters")})
    public ClusterData clusterFor(@Parameter(description="Name", required=true) @QueryParam(value="name") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.i(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @PUT
    @Path(value="/cluster")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Add cluster", description="Adds a new cluster.", responses={@ApiResponse(responseCode="200", description="Cluster summary", content={@Content(schema=@Schema(implementation=ClusterSummary.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Clusters")})
    public ClusterSummary addCluster(@Parameter(description="Data", required=true) ClusterData clusterData) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.a(clusterData);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/cluster")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update cluster", description="Updates a cluster.", responses={@ApiResponse(responseCode="200", description="Cluster summary", content={@Content(schema=@Schema(implementation=ClusterSummary.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Clusters")})
    public ClusterSummary updateCluster(@Parameter(description="Data", required=true) ClusterData clusterData) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.b(clusterData);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @DELETE
    @Path(value="/cluster")
    @Operation(summary="Delete cluster", description="Deletes a cluster.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Clusters")})
    public void removeCluster(@Parameter(description="Name", required=true) @QueryParam(value="name") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            ac2.j(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/service/ip-access/configuration")
    @Produces(value={"application/json"})
    @Operation(summary="Get IP access service configuration", description="Obtains an IP access service configuration.", responses={@ApiResponse(responseCode="200", description="IP access configuration", content={@Content(schema=@Schema(implementation=IpAccessConfiguration.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="IP Access")})
    public IpAccessConfiguration ipAccessConfiguration() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.k();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/ip-access/configuration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update IP access service configuration", description="Updates an IP access service configuration.", responses={@ApiResponse(responseCode="200", description="IP access configuration", content={@Content(schema=@Schema(implementation=IpAccessConfiguration.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="IP Access")})
    public IpAccessConfiguration updateIpAccessConfiguration(@Parameter(description="Configuration", required=true) IpAccessConfiguration ipAccessConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.a(ipAccessConfiguration);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/ip-access/block-ip")
    @Produces(value={"application/json"})
    @Operation(summary="Block client IP", description="Blocks client IP that corresponds to the server connection.", responses={@ApiResponse(responseCode="200", description="IP access configuration", content={@Content(schema=@Schema(implementation=TransportAddress.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="IP Access")})
    public TransportAddress blockClientIpFor(@Parameter(description="GatewayHost", required=true) @QueryParam(value="gatewayHost") String string, @Parameter(description="GatewayPort", required=true) @QueryParam(value="gatewayPort") int n2, @Parameter(description="ServerHost", required=true) @QueryParam(value="serverHost") String string2, @Parameter(description="ServerPort", required=true) @QueryParam(value="serverPort") int n3, @Parameter(description="Period") @QueryParam(value="period") Long l10) throws h {
        this.assertAuthenticated();
        try {
            ac ac2 = this.session();
            BlockIpRequest blockIpRequest = new BlockIpRequest(new TransportAddress(string, n2), new TransportAddress(string2, n3), l10);
            return ac2.a(blockIpRequest);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/service/log/configuration")
    @Produces(value={"application/json"})
    @Operation(summary="Get log service configuration", description="Obtains a log service configuration.", responses={@ApiResponse(responseCode="200", description="Log service configuration", content={@Content(schema=@Schema(implementation=LogServiceConfiguration.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Logs")})
    @Encrypted
    public LogServiceConfiguration logServiceConfiguration() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.l();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/log/configuration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update log service configuration", description="Updates a log service configuration.", responses={@ApiResponse(responseCode="200", description="Log service configuration", content={@Content(schema=@Schema(implementation=LogServiceConfiguration.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Logs")})
    @Encrypted
    public LogServiceConfiguration updateLogServiceConfiguration(@Parameter(description="Configuration", required=true) LogServiceConfiguration logServiceConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.a(logServiceConfiguration);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/log/configuration/test")
    @Consumes(value={"application/json"})
    @Operation(summary="Test log service configuration", description="Tests a log service configuration.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Logs")})
    public void testLogServiceConfiguration(@Parameter(description="Configuration", required=true) LogServiceConfiguration logServiceConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            ac2.b(logServiceConfiguration);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/log/repository/init")
    @Consumes(value={"application/json"})
    @Operation(summary="Init log service repository", description="Initializes a log service record repository.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Logs")})
    public void initLogRepository(@Parameter(description="Configuration", required=true) LogServiceConfiguration logServiceConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            ac2.c(logServiceConfiguration);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/log")
    @Produces(value={"application/json"})
    @Operation(summary="Get log records", description="Obtains latest log records.", responses={@ApiResponse(responseCode="200", description="Log record", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Logs")})
    public LogRecord[] latestLogRecords(@QueryParam(value="count") @Parameter(description="Records count", required=true) int n2) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            List<LogRecord> list = ac2.a(n2);
            return list.toArray(new LogRecord[0]);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/service/monitor/configuration")
    @Produces(value={"application/json"})
    @Operation(summary="Get monitor service configuration", description="Obtains a monitor service configuration.", responses={@ApiResponse(responseCode="200", description="Monitor service configuration", content={@Content(schema=@Schema(implementation=MonitorServiceConfiguration.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Monitor")})
    public MonitorServiceConfiguration monitorServiceConfiguration() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.m();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/monitor/configuration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update monitor service configuration", description="Updates a monitor service configuration.", responses={@ApiResponse(responseCode="200", description="Monitor service configuration", content={@Content(schema=@Schema(implementation=MonitorServiceConfiguration.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Monitor")})
    public MonitorServiceConfiguration updateMonitorServiceConfiguration(@Parameter(description="Configuration", required=true) MonitorServiceConfiguration monitorServiceConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.a(monitorServiceConfiguration);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/administrators")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Get administrators", description="Obtains available administrators.", responses={@ApiResponse(responseCode="200", description="Administrator summaries", content={@Content(schema=@Schema(implementation=Page.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Administrators")})
    public Page<AdministratorSummary> administratorsFor(@Parameter(description="Page request", required=true) PageRequest pageRequest) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.b(pageRequest);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/administrator")
    @Produces(value={"application/json"})
    @Operation(summary="Get administrator data", description="Obtains an administrator data.", responses={@ApiResponse(responseCode="200", description="Administrator data", content={@Content(schema=@Schema(implementation=AdministratorData.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Administrators")})
    @Encrypted
    public AdministratorData administratorFor(@Parameter(description="Username", required=true) @QueryParam(value="username") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.k(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @PUT
    @Path(value="/administrator")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Add administrator", description="Adds a new administrator.", responses={@ApiResponse(responseCode="200", description="Administrator summary", content={@Content(schema=@Schema(implementation=AdministratorSummary.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Administrators")})
    public AdministratorSummary addAdministrator(@Parameter(description="Data", required=true) AdministratorData administratorData) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.a(administratorData);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/administrator")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update administrator", description="Updates an administrator.", responses={@ApiResponse(responseCode="200", description="Administrator summary", content={@Content(schema=@Schema(implementation=AdministratorSummary.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Administrators")})
    public AdministratorSummary updateAdministrator(@Parameter(description="Data", required=true) AdministratorData administratorData) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.b(administratorData);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @DELETE
    @Path(value="/administrator")
    @Operation(summary="Delete administrator", description="Deletes an administrator.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Administrators")})
    public void removeAdministrator(@Parameter(description="Administrator username", required=true) @QueryParam(value="username") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            ac2.l(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/administrator/sessions")
    @Produces(value={"application/json"})
    @Operation(summary="Get administrator sessions", description="Obtains administrator sessions.", responses={@ApiResponse(responseCode="200", description="Administrator session summaries", content={@Content(schema=@Schema(implementation=AdministratorSessionSummary.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Administrators")})
    public AdministratorSessionSummary[] administratorSessions() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            List<AdministratorSessionSummary> list = ac2.p();
            return list.toArray(new AdministratorSessionSummary[0]);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/agents")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Get agents", description="Obtains available agents.", responses={@ApiResponse(responseCode="200", description="Agent summaries", content={@Content(schema=@Schema(implementation=Page.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Agents")})
    public Page<GatewayAgentSummary> agentsFor(@Parameter(description="Page request", required=true) PageRequest pageRequest) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.c(pageRequest);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/agent")
    @Produces(value={"application/json"})
    @Operation(summary="Get agent data", description="Obtains an agent data.", responses={@ApiResponse(responseCode="200", description="Agent data", content={@Content(schema=@Schema(implementation=GatewayAgentData.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Agents")})
    @Encrypted
    public GatewayAgentData agentFor(@Parameter(description="Username", required=true) @QueryParam(value="username") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.m(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @PUT
    @Path(value="/agent")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Add agent", description="Adds a new agent.", responses={@ApiResponse(responseCode="200", description="Agent summary", content={@Content(schema=@Schema(implementation=GatewayAgentSummary.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Agents")})
    public GatewayAgentSummary addAgent(@Parameter(description="Data", required=true) GatewayAgentData gatewayAgentData) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.a(gatewayAgentData);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/agent")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update agent", description="Updates an agent.", responses={@ApiResponse(responseCode="200", description="Agent summary", content={@Content(schema=@Schema(implementation=GatewayAgentSummary.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Agents")})
    public GatewayAgentSummary updateAgent(@Parameter(description="Data", required=true) GatewayAgentData gatewayAgentData) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.b(gatewayAgentData);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @DELETE
    @Path(value="/agent")
    @Operation(summary="Delete agent", description="Deletes an agent.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Agents")})
    public void removeAgent(@Parameter(description="Username", required=true) @QueryParam(value="username") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            ac2.n(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/agent/installer/update")
    @Operation(summary="Update agent installer", description="Updates an agent installer.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Agents")})
    public void updateAgentInstaller(@Parameter(description="ID", required=true) @QueryParam(value="id") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.inProgress());
            aS.a(String.format(a[1], string)).newThread(() -> this.updateAgentInstaller(ac2, string)).start();
        }
        catch (Throwable throwable) {
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.error(throwable));
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/agent/installer/start")
    @Operation(summary="Start agent installer", description="Starts an agent installer.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Agents")})
    public void startAgentInstaller(@Parameter(description="ID", required=true) @QueryParam(value="id") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            ac2.p(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/keys/server")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Get server keys", description="Obtains available server keys.", responses={@ApiResponse(responseCode="200", description="Key summaries", content={@Content(schema=@Schema(implementation=Page.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Keys")})
    public Page<ServerKeySummary> serverKeysFor(@Parameter(description="Page request", required=true) PageRequest pageRequest) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.d(pageRequest);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/keys/server/names")
    @Produces(value={"application/json"})
    @Operation(summary="Get server key names", description="Obtains available server key names.", responses={@ApiResponse(responseCode="200", description="Key names", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Keys")})
    public String[] serverKeyNames() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            List<String> list = ac2.q();
            return list.toArray(new String[0]);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/key/server/generate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Generate server key", description="Generates a new server key.", responses={@ApiResponse(responseCode="200", description="Server key summary", content={@Content(schema=@Schema(implementation=ServerKeySummary.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Keys")})
    public ServerKeySummary generateServerKey(@Parameter(description="Key data", required=true) ServerKeyGenerationData serverKeyGenerationData) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.a(serverKeyGenerationData);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/key/server")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    @Operation(summary="Import server key", description="Imports a server key.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Keys")})
    public void importServerKey(@Parameter(description="Form", required=true) FormDataMultiPart formDataMultiPart, @Parameter(description="Key file", required=true) @FormDataParam(value="dataFile") InputStream inputStream) throws h {
        this.assertCsrfTokenValid(formDataMultiPart);
        int[] nArray = c.b();
        this.assertAuthenticated();
        int[] nArray2 = nArray;
        try {
            ac ac2 = this.session();
            String[] stringArray = a;
            String string = formDataMultiPart.getField(stringArray[7]).getValue().trim();
            String string2 = formDataMultiPart.getField(stringArray[9]).getValue();
            String string3 = formDataMultiPart.getField(stringArray[16]).getValue().trim();
            String string4 = formDataMultiPart.getField(stringArray[13]).getValue();
            ServerKeyImportData serverKeyImportData = new ServerKeyImportData(string, string2, string3, string4);
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.inProgress());
            ServerKeySummary serverKeySummary = ac2.a(serverKeyImportData, inputStream);
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.done(serverKeySummary));
        }
        catch (Throwable throwable) {
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.error(throwable));
            throw this.wrap(throwable);
        }
        try {
            if (!aW.b()) {
                c.b(new int[2]);
            }
        }
        catch (Throwable throwable) {
            throw ApiServer.a(throwable);
        }
    }

    @POST
    @Path(value="/key/server/certificate")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    @Operation(summary="Import server certificate", description="Imports a server certificate(s).", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    public void importServerCertificate(@Parameter(description="Name", required=true) @QueryParam(value="name") String string, @Parameter(description="Form", required=true) FormDataMultiPart formDataMultiPart, @Parameter(description="Certificate file", required=true) @FormDataParam(value="dataFile") InputStream inputStream) throws h {
        this.assertCsrfTokenValid(formDataMultiPart);
        this.assertAuthenticated();
        try {
            ac ac2 = this.session();
            String[] stringArray = a;
            String string2 = formDataMultiPart.getField(stringArray[4]).getValue();
            String string3 = formDataMultiPart.getField(stringArray[17]).getValue().trim();
            CertificateImportData certificateImportData = new CertificateImportData(string, string2, string3);
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.inProgress());
            ServerKeySummary serverKeySummary = ac2.a(certificateImportData, inputStream);
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.done(serverKeySummary));
        }
        catch (Throwable throwable) {
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.error(throwable));
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/key/server/certificate/generate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Generate server certificate", description="Generates a self-signed server certificate.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Keys")})
    public ServerKeySummary generateServerCertificate(@Parameter(description="Name", required=true) @QueryParam(value="name") String string, @Parameter(description="Certificate data", required=true) CertificateGenerationData certificateGenerationData) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.a(string, certificateGenerationData);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/key/server/{name}.key")
    @Produces(value={"application/octet-stream"})
    @Operation(summary="Export server private key", description="Exports a server private key.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Keys")})
    public InputStream serverKeyFor(@Parameter(description="Key name", required=true) @PathParam(value="name") String string, @Parameter(description="File format", required=true) @QueryParam(value="format") String string2, @Parameter(description="File password", required=true) @QueryParam(value="password") String string3) throws h {
        this.assertAuthenticated();
        try {
            ac ac2 = this.session();
            return ac2.a(string, string2, string3);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/key/server/certificate/{name}.cer")
    @Produces(value={"application/octet-stream"})
    @Operation(summary="Export server certificate", description="Exports a server certificate.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Keys")})
    public InputStream serverCertificateFor(@Parameter(description="Key name", required=true) @PathParam(value="name") String string, @Parameter(description="File format", required=true) @QueryParam(value="format") String string2) throws h {
        this.assertAuthenticated();
        try {
            ac ac2 = this.session();
            return ac2.b(string, string2);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/key/server/public-key/{name}.pub")
    @Produces(value={"application/octet-stream"})
    @Operation(summary="Export server public key", description="Exports a server public key.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Keys")})
    public InputStream serverPublicKeyFor(@Parameter(description="Key name", required=true) @PathParam(value="name") String string, @Parameter(description="File format", required=true) @QueryParam(value="format") String string2) throws h {
        this.assertAuthenticated();
        try {
            ac ac2 = this.session();
            return ac2.c(string, string2);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/key/server/csr/{name}.csr")
    @Produces(value={"application/octet-stream"})
    @Operation(summary="Generate CSR", description="Generates a CSR.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Keys")})
    public InputStream serverKeyCsrFor(@Parameter(description="Key name", required=true) @PathParam(value="name") String string) throws h {
        this.assertAuthenticated();
        try {
            ac ac2 = this.session();
            return ac2.q(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @DELETE
    @Path(value="/key/server")
    @Operation(summary="Delete server key", description="Deletes a server key.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Keys")})
    public void removeServerKey(@Parameter(description="Key name", required=true) @QueryParam(value="name") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            ac2.r(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/service/email/configuration")
    @Produces(value={"application/json"})
    @Operation(summary="Get email service configuration", description="Obtains an email service configuration.", responses={@ApiResponse(responseCode="200", description="Email service configuration", content={@Content(schema=@Schema(implementation=EmailServiceConfiguration.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Email")})
    @Encrypted
    public EmailServiceConfiguration emailServiceConfiguration() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.r();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/email/configuration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update email service configuration", description="Updates an email service configuration.", responses={@ApiResponse(responseCode="200", description="Email service configuration", content={@Content(schema=@Schema(implementation=EmailServiceConfiguration.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Email")})
    @Encrypted
    public EmailServiceConfiguration updateEmailServiceConfiguration(@Parameter(description="Configuration", required=true) EmailServiceConfiguration emailServiceConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.a(emailServiceConfiguration);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/email/configuration/test")
    @Consumes(value={"application/json"})
    @Operation(summary="Test email service configuration", description="Tests an email service configuration.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Email")})
    public void testEmailServiceConfiguration(@Parameter(description="Configuration", required=true) EmailServiceConfiguration emailServiceConfiguration, @Parameter(description="Recipient", required=true) @QueryParam(value="recipient") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            ac2.a(emailServiceConfiguration, string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/service/web/configuration")
    @Produces(value={"application/json"})
    @Operation(summary="Get web service configuration", description="Obtains a web service configuration.", responses={@ApiResponse(responseCode="200", description="Web service configuration", content={@Content(schema=@Schema(implementation=WebServiceConfiguration.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Web")})
    public WebServiceConfiguration webServiceConfiguration() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.s();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/web/configuration/database")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Get web service configuration", description="Obtains a web service configuration from the specified database.", responses={@ApiResponse(responseCode="200", description="Web service configuration", content={@Content(schema=@Schema(implementation=WebServiceConfiguration.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Web")})
    public WebServiceConfiguration webConfigurationFor(@Parameter(description="Database configuration", required=true) DatabaseConfiguration databaseConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.d(databaseConfiguration);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/web/configuration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update web service configuration", description="Updates a web service configuration.", responses={@ApiResponse(responseCode="200", description="Web service configuration", content={@Content(schema=@Schema(implementation=WebServiceConfiguration.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Web")})
    public WebServiceConfiguration updateWebServiceConfiguration(@Parameter(description="Configuration", required=true) WebServiceConfiguration webServiceConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.a(webServiceConfiguration);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/service/jmx/configuration")
    @Produces(value={"application/json"})
    @Operation(summary="Get JMX service configuration", description="Obtains a JMX service configuration.", responses={@ApiResponse(responseCode="200", description="JMX service configuration", content={@Content(schema=@Schema(implementation=JmxServiceConfiguration.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="JMX")})
    public JmxServiceConfiguration jmxServiceConfiguration() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.t();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/jmx/configuration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update JMX service configuration", description="Updates a JMX service configuration.", responses={@ApiResponse(responseCode="200", description="JMX service configuration", content={@Content(schema=@Schema(implementation=JmxServiceConfiguration.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="JMX")})
    public JmxServiceConfiguration updateJmxServiceConfiguration(@Parameter(description="Configuration", required=true) JmxServiceConfiguration jmxServiceConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.a(jmxServiceConfiguration);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/service/agent/configuration")
    @Produces(value={"application/json"})
    @Operation(summary="Get agent service configuration", description="Obtains a agent service configuration.", responses={@ApiResponse(responseCode="200", description="Agent service configuration", content={@Content(schema=@Schema(implementation=AgentServiceConfiguration.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Agents")})
    public AgentServiceConfiguration agentServiceConfiguration() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.u();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/agent/configuration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update agent service configuration", description="Updates a agent service configuration.", responses={@ApiResponse(responseCode="200", description="Agent service configuration", content={@Content(schema=@Schema(implementation=AgentServiceConfiguration.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Agents")})
    public AgentServiceConfiguration updateAgentServiceConfiguration(@Parameter(description="Configuration", required=true) AgentServiceConfiguration agentServiceConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.a(agentServiceConfiguration);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/agent/sessions")
    @Produces(value={"application/json"})
    @Operation(summary="Get agent sessions", description="Obtains current agent sessions.", responses={@ApiResponse(responseCode="200", description="Agent session summary", content={@Content(schema=@Schema(implementation=GatewayAgentSessionSummary.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Agents")})
    public GatewayAgentSessionSummary[] agentSessions() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            List<GatewayAgentSessionSummary> list = ac2.v();
            return list.toArray(new GatewayAgentSessionSummary[0]);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/agent/session/close")
    @Operation(summary="Close agent session", description="Closes specified agent session.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Agents")})
    public void closeAgentSession(@Parameter(description="Session ID", required=true) @QueryParam(value="id") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            ac2.s(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/database/configuration")
    @Produces(value={"application/json"})
    @Operation(summary="Get database configuration", description="Obtains a database configuration.", responses={@ApiResponse(responseCode="200", description="Database configuration", content={@Content(schema=@Schema(implementation=DatabaseConfiguration.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Database")})
    @Encrypted
    public DatabaseConfiguration databaseConfiguration() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.g();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/database/configuration")
    @Consumes(value={"application/json"})
    @Operation(summary="Update database configuration", description="Updates a database configuration.", responses={@ApiResponse(responseCode="200", description="Database configuration", content={@Content(schema=@Schema(implementation=DatabaseConfiguration.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Database")})
    public void updateDatabaseConfiguration(@Parameter(description="Configuration", required=true) DatabaseConfiguration databaseConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            ac2.a(databaseConfiguration);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/database/configuration/test")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Test database configuration", description="Tests a database configuration.", responses={@ApiResponse(responseCode="200", description="Database test result", content={@Content(schema=@Schema(implementation=DatabaseTestResult.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Database")})
    public DatabaseTestResult testDatabaseConfiguration(@Parameter(description="Configuration", required=true) DatabaseConfiguration databaseConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            return ac2.b(databaseConfiguration);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/database/migrate")
    @Consumes(value={"application/json"})
    @Operation(summary="Migrate data", description="Migrates data to the specified configuration.", responses={@ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Database")})
    public void migrateData(@Parameter(description="Configuration", required=true) DatabaseConfiguration databaseConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.inProgress());
            aS.a(a[5]).newThread(() -> this.migrateData(ac2, databaseConfiguration)).start();
        }
        catch (Throwable throwable) {
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.error(throwable));
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/files/log")
    @Produces(value={"application/json"})
    @Operation(summary="List log directory", description="Obtains available log directories.", responses={@ApiResponse(responseCode="200", description="File service entry", content={@Content(schema=@Schema(implementation=FileService.Entry.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Files")})
    public FileService.Entry listLogDirectory(@Parameter(description="Path", required=false) @QueryParam(value="path") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            String string2;
            ac ac2;
            ac ac3 = this.session();
            try {
                ac2 = ac3;
                string2 = string != null ? string.trim() : null;
            }
            catch (Throwable throwable) {
                throw ApiServer.a(throwable);
            }
            return ac2.t(string2);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @PUT
    @Path(value="/files/log")
    @Produces(value={"application/json"})
    @Operation(summary="Create log directory", description="Creates a new log directory.", responses={@ApiResponse(responseCode="200", description="File service entry", content={@Content(schema=@Schema(implementation=FileService.Entry.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Files")})
    public FileService.Entry createLogDirectory(@Parameter(description="Path", required=true) @QueryParam(value="path") String string, @Parameter(description="Name", required=true) @QueryParam(value="name") String string2) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            ac2.d(string.trim(), string2);
            return ac2.t(string.trim());
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/files/cache")
    @Produces(value={"application/json"})
    @Operation(summary="List log directory", description="Obtains available cache directories.", responses={@ApiResponse(responseCode="200", description="File service entry", content={@Content(schema=@Schema(implementation=FileService.Entry.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Files")})
    public FileService.Entry listCacheDirectory(@Parameter(description="Path", required=false) @QueryParam(value="path") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            String string2;
            ac ac2;
            ac ac3 = this.session();
            try {
                ac2 = ac3;
                string2 = string != null ? string.trim() : null;
            }
            catch (Throwable throwable) {
                throw ApiServer.a(throwable);
            }
            return ac2.u(string2);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @PUT
    @Path(value="/files/cache")
    @Produces(value={"application/json"})
    @Operation(summary="Create cache directory", description="Creates a new cache directory.", responses={@ApiResponse(responseCode="200", description="File service entry", content={@Content(schema=@Schema(implementation=FileService.Entry.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Files")})
    public FileService.Entry createCacheDirectory(@Parameter(description="Path", required=true) @QueryParam(value="path") String string, @Parameter(description="Name", required=true) @QueryParam(value="name") String string2) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            ac ac2 = this.session();
            ac2.e(string.trim(), string2);
            return ac2.u(string.trim());
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/submit/state")
    @Produces(value={"application/json"})
    @Operation(summary="Get import state", description="Obtains current operation state.", responses={@ApiResponse(responseCode="200", description="Submit state", content={@Content(schema=@Schema(implementation=SubmitState.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorSummary.class))})})
    @Tags(value={@Tag(name="Service")})
    public SubmitState submitState() throws h {
        SubmitState submitState;
        block10: {
            this.assertAuthenticated();
            this.assertCsrfTokenValid();
            submitState = (SubmitState)c.SUBMIT_STATE.of(this.httpSession);
            try {
                if (submitState == null) {
                    return SubmitState.none();
                }
            }
            catch (h h10) {
                throw ApiServer.a((Throwable)((Object)h10));
            }
            try {
                try {
                    if (submitState.status != SubmitState.Status.DONE && submitState.status != SubmitState.Status.ERROR) break block10;
                }
                catch (h h11) {
                    throw ApiServer.a((Throwable)((Object)h11));
                }
                c.SUBMIT_STATE.set(this.httpSession, SubmitState.none());
            }
            catch (h h12) {
                throw ApiServer.a((Throwable)((Object)h12));
            }
        }
        try {
            if (submitState.status == SubmitState.Status.ERROR) {
                throw this.wrap((Throwable)submitState.data);
            }
        }
        catch (h h13) {
            throw ApiServer.a((Throwable)((Object)h13));
        }
        return submitState;
    }

    private void updateAgentInstaller(ac ac2, String string) {
        try {
            ac2.o(string);
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.done());
        }
        catch (Throwable throwable) {
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.error(throwable));
        }
    }

    private void migrateData(ac ac2, DatabaseConfiguration databaseConfiguration) {
        try {
            ac2.c(databaseConfiguration);
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.done());
        }
        catch (Throwable throwable) {
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.error(throwable));
        }
    }

    private void assertAuthenticated() {
        try {
            if (this.sessionId == null) {
                throw new h(ErrorCode.NOT_AUTHENTICATED, a[10], "");
            }
        }
        catch (h h10) {
            throw ApiServer.a((Throwable)((Object)h10));
        }
    }

    private void assertCsrfTokenValid() {
        String string = this.request.getHeader(a[8]);
        this.assertCsrfTokenValid(string);
    }

    private void assertCsrfTokenValid(FormDataMultiPart formDataMultiPart) {
        String string = formDataMultiPart.getField(a[6]).getValue();
        this.assertCsrfTokenValid(string);
    }

    private void assertCsrfTokenValid(String string) {
        block4: {
            try {
                try {
                    if (string != null && f.a(this.httpSession.getId(), string)) break block4;
                }
                catch (h h10) {
                    throw ApiServer.a((Throwable)((Object)h10));
                }
                throw new h(ErrorCode.PROTOCOL_ERROR, "", "");
            }
            catch (h h11) {
                throw ApiServer.a((Throwable)((Object)h11));
            }
        }
    }

    private void initHttpConnectionAddresses() {
        try {
            c.LOCAL_ADDRESS.set(this.httpSession, new TransportAddress(this.request.getLocalAddr(), this.request.getLocalPort()));
            c.REMOTE_ADDRESS.set(this.httpSession, new TransportAddress(this.request.getRemoteHost(), this.request.getRemotePort()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cleanupHttpSession() {
        c.cleanup(this.httpSession);
    }

    private void closeHttpSession() {
        try {
            this.httpSession.invalidate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ac session() throws Exception {
        try {
            return this.sessionManager.a(this.sessionId);
        }
        catch (j j10) {
            throw new h(ErrorCode.NOT_AUTHENTICATED, a[3], "");
        }
    }

    private h wrap(Throwable throwable) {
        try {
            if (this.debugAllowed) {
                b.ERROR.set(this.request, throwable);
            }
        }
        catch (h h10) {
            throw ApiServer.a((Throwable)((Object)h10));
        }
        return h.a(throwable, this.debugAllowed);
    }

    private void logRequest() {
        try {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, a[14] + this.request);
            }
        }
        catch (h h10) {
            throw ApiServer.a((Throwable)((Object)h10));
        }
    }

    private static Throwable a(Throwable throwable) {
        return throwable;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[18];
                var3_1 = 0;
                var2_2 = "Y\\9f\f<\u0018[C1f\u000f!\u001eN\u001d3)\u0012*\f[Jz)\u0002.\u000bNV&f\u0011*\u0019\"{T1&\u0012o\\\u001f@sh/!\bNR8$\u0003=[oC0)\u0012*[n[&-\u0007+\u0017s]\")\n&\u001f\u001a\\$-\u0014.\u000fS\\:h\u0002.\u000f[\u001d\u0012t\\ h\u0007:\u000fRV:<\u000f,\u001aNV0f\f\\Z8-6.\bID;:\u0002\u0015~R )F\u0002\u0012]A5<\u000f \u0015\u001ag<:\u0003.\u001f\fb\u001e\u0017\u001b4\tVn\\?-\b\u0005[_=)\u0015\fb\u001e\u0017\u001b4\tVn\\?-\b\f\\Z8-6.\bID;:\u0002\u0012t\\ h\u0007:\u000fRV:<\u000f,\u001aNV0f#{P !\u0010*6|gt\u000f\u0007;\u001eMR-h1*\u0019\u001ar\u0004\u0001\\o\u000f_@ h)\u0004U\u0015{F  \u0003!\u000fSP5<\u000f \u0015\u001aV&:\t=U\u000bQV-\u0018\u0007<\bM\\&,\u0016s]7'\u000b&\u0015]\u0013\u0015\u0018/o\t_B!-\u0015;A\u001a*{F  \u0003!\u000fSP5<\u000f \u0015\u001aV&:\t=A\u001aZ:>\u0007#\u0012^\u00137:\u0003+\u001eTG=)\n<U";
                var4_3 = "Y\\9f\f<\u0018[C1f\u000f!\u001eN\u001d3)\u0012*\f[Jz)\u0002.\u000bNV&f\u0011*\u0019\"{T1&\u0012o\\\u001f@sh/!\bNR8$\u0003=[oC0)\u0012*[n[&-\u0007+\u0017s]\")\n&\u001f\u001a\\$-\u0014.\u000fS\\:h\u0002.\u000f[\u001d\u0012t\\ h\u0007:\u000fRV:<\u000f,\u001aNV0f\f\\Z8-6.\bID;:\u0002\u0015~R )F\u0002\u0012]A5<\u000f \u0015\u001ag<:\u0003.\u001f\fb\u001e\u0017\u001b4\tVn\\?-\b\u0005[_=)\u0015\fb\u001e\u0017\u001b4\tVn\\?-\b\f\\Z8-6.\bID;:\u0002\u0012t\\ h\u0007:\u000fRV:<\u000f,\u001aNV0f#{P !\u0010*6|gt\u000f\u0007;\u001eMR-h1*\u0019\u001ar\u0004\u0001\\o\u000f_@ h)\u0004U\u0015{F  \u0003!\u000fSP5<\u000f \u0015\u001aV&:\t=U\u000bQV-\u0018\u0007<\bM\\&,\u0016s]7'\u000b&\u0015]\u0013\u0015\u0018/o\t_B!-\u0015;A\u001a*{F  \u0003!\u000fSP5<\u000f \u0015\u001aV&:\t=A\u001aZ:>\u0007#\u0012^\u00137:\u0003+\u001eTG=)\n<U".length();
                var1_4 = 35;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 8;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = ")-O[gtg\u000e(J_\u000b)-O[gtg\u000e(J_";
                    var4_3 = ")-O[gtg\u000e(J_\u000b)-O[gtg\u000e(J_".length();
                    var1_4 = 11;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 122;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 50;
                            break;
                        }
                        case 1: {
                            v15 = 59;
                            break;
                        }
                        case 2: {
                            v15 = 92;
                            break;
                        }
                        case 3: {
                            v15 = 64;
                            break;
                        }
                        case 4: {
                            v15 = 110;
                            break;
                        }
                        case 5: {
                            v15 = 71;
                            break;
                        }
                        default: {
                            v15 = 115;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        ApiServer.a = var5;
    }
}

