/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import java.io.File;
import java.util.Arrays;
import javax.swing.filechooser.FileFilter;

public class MultiFileFilter
extends FileFilter {
    private String[] suffixes;
    private String description;

    public MultiFileFilter(String[] suffixes, String name) {
        this.suffixes = suffixes;
        StringBuilder buffer = new StringBuilder();
        for (String suffix : suffixes) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            if (suffix.indexOf(46) == -1) {
                buffer.append("*.");
            }
            buffer.append(suffix);
        }
        this.description = name + " (" + buffer.toString() + ")";
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String fileName = file.getName();
        int lastDotPos = fileName.lastIndexOf(".");
        String suffix = lastDotPos > -1 ? fileName.substring(lastDotPos + 1).toLowerCase() : "";
        for (String testSuffix : this.suffixes) {
            if (testSuffix.equals("*")) {
                return true;
            }
            if (suffix.equalsIgnoreCase(testSuffix)) {
                return true;
            }
            if (testSuffix.indexOf(46) <= -1 || !fileName.equalsIgnoreCase(testSuffix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String[] getSuffixes() {
        return this.suffixes;
    }

    public boolean equals(Object other) {
        return other instanceof MultiFileFilter && Arrays.equals(((MultiFileFilter)other).suffixes, this.suffixes);
    }
}

