/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher;

import com.install4j.runtime.launcher.LegacySplashScreen;
import com.install4j.runtime.launcher.WindowChecker;
import java.awt.Frame;
import java.awt.Window;

public class SwingWindowChecker
extends WindowChecker {
    public SwingWindowChecker(Runnable runnable) {
        super(runnable);
    }

    @Override
    protected boolean checkExecute() {
        return SwingWindowChecker.hasVisibleWindows();
    }

    public static boolean hasVisibleWindows() {
        Frame[] frames;
        for (Frame frame : frames = Frame.getFrames()) {
            if (frame.isShowing()) {
                return true;
            }
            if (!SwingWindowChecker.checkWindows(frame.getOwnedWindows())) continue;
            return true;
        }
        return false;
    }

    private static boolean checkWindows(Window[] windows) {
        for (Window window : windows) {
            if (!(window instanceof LegacySplashScreen) && window.isShowing()) {
                return true;
            }
            if (!SwingWindowChecker.checkWindows(window.getOwnedWindows())) continue;
            return true;
        }
        return false;
    }
}

