/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.peer.ComponentPeer;
import java.lang.reflect.Method;

class WinGuiHelper {
    private static Method getHwndMethod;

    WinGuiHelper() {
    }

    public static synchronized long getHwnd(Window window) throws HeadlessException {
        if (window != null) {
            if (GraphicsEnvironment.isHeadless()) {
                throw new HeadlessException("No native windows when headless");
            }
            ComponentPeer componentPeer = window.getPeer();
            if (componentPeer != null) {
                if (getHwndMethod == null) {
                    try {
                        getHwndMethod = componentPeer.getClass().getMethod("getHWnd", new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                }
                if (getHwndMethod != null) {
                    try {
                        Object result = getHwndMethod.invoke((Object)componentPeer, new Object[0]);
                        if (result instanceof Long) {
                            return (Long)result;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        return 0L;
    }
}

