/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.FileOptions;
import com.install4j.api.context.OverwriteMode;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.platform.win32.ShellLink;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;

public class MenuHelper {
    public static void installWindowsMenu(ExecutionContext executionContext, File menuFile, File shortcutTo, File iconFile) throws IOException, UserCanceledException {
        MenuHelper.installWindowsMenu(executionContext, menuFile, shortcutTo, iconFile, null, false, null);
    }

    public static void installWindowsMenu(ExecutionContext executionContext, File menuFile, File shortcutTo, File iconFile, String arguments, boolean runAsAdministrator, String description) throws IOException, UserCanceledException {
        MenuHelper.installWindowsMenu(executionContext, menuFile, shortcutTo, iconFile, arguments, runAsAdministrator, description, null);
    }

    public static void installWindowsMenu(ExecutionContext executionContext, final File menuFile, final File shortcutTo, final File iconFile, final String arguments, final boolean runAsAdministrator, final String description, final File startIn) throws IOException, UserCanceledException {
        HelperCommunication.getInstance().executeActionChecked(executionContext, new RunAction(){

            @Override
            protected void run(Context context) throws Exception {
                MenuHelper.createWindowsMenuInt(menuFile, shortcutTo, iconFile, arguments, runAsAdministrator, description, startIn);
            }
        });
    }

    private static void createWindowsMenuInt(File menuFile, File shortcutTo, File iconFile, String arguments, boolean runAsAdministrator, String description, File startIn) throws IOException, UserCanceledException {
        if (!shortcutTo.exists()) {
            return;
        }
        if (arguments != null && arguments.trim().length() == 0) {
            arguments = null;
        }
        if (shortcutTo.getName().endsWith(".url")) {
            File urlFile = new File(menuFile.getAbsolutePath() + ".url");
            if (iconFile != null) {
                File tempUrlFile = File.createTempFile("i4j", ".url");
                if (FileUtil.copyFile(shortcutTo, tempUrlFile)) {
                    BufferedWriter out = new BufferedWriter(new FileWriter(tempUrlFile, true));
                    out.newLine();
                    out.write("IconIndex=0");
                    out.newLine();
                    out.write("IconFile=" + iconFile);
                    out.close();
                    FileInstaller.getInstance().install(tempUrlFile, urlFile, new FileOptions(shortcutTo.lastModified(), "644", OverwriteMode.ALWAYS, false, UninstallMode.ALWAYS));
                }
                tempUrlFile.delete();
            } else {
                FileInstaller.getInstance().install(shortcutTo, urlFile, new FileOptions(shortcutTo.lastModified(), "644", OverwriteMode.ALWAYS, false, UninstallMode.ALWAYS));
            }
            ShellLink.changeNotify(urlFile);
        } else {
            File lnkFile = new File(menuFile.getAbsolutePath() + ".lnk");
            File pifFile = new File(menuFile.getAbsolutePath() + ".pif");
            File tempLnkFile = File.createTempFile("i4j", ".lnk");
            File tempPifFile = new File(tempLnkFile.getAbsolutePath().substring(0, tempLnkFile.getAbsolutePath().length() - 3) + "pif");
            ShellLink.create(tempLnkFile, shortcutTo, iconFile, arguments, runAsAdministrator, description, startIn, 1);
            if (tempLnkFile.exists()) {
                FileInstaller.getInstance().install(tempLnkFile, lnkFile, new FileOptions(tempLnkFile.lastModified(), "644", OverwriteMode.ALWAYS, false, UninstallMode.ALWAYS));
                pifFile.delete();
            } else if (tempPifFile.exists()) {
                FileInstaller.getInstance().install(tempPifFile, pifFile, new FileOptions(tempPifFile.lastModified(), "644", OverwriteMode.ALWAYS, false, UninstallMode.ALWAYS));
                lnkFile.delete();
            }
            tempLnkFile.delete();
            tempPifFile.delete();
            ShellLink.changeNotify(lnkFile);
        }
    }

    public static File installUnixDesktopFile(File installationDir, File destinationDirectory, File execFile, String name, String categories, String arguments) throws IOException, UserCanceledException {
        if (execFile == null || !execFile.exists()) {
            return null;
        }
        File desktopFile = new File(destinationDirectory, name + ".desktop");
        File tempFile = File.createTempFile("i4j", null);
        PrintWriter pw = new PrintWriter(new FileOutputStream(tempFile));
        pw.println("#!/usr/bin/env xdg-open");
        pw.println("[Desktop Entry]");
        pw.println("Type=Application");
        pw.println("Name=" + name);
        pw.println("Exec=/bin/sh \"" + execFile.getAbsolutePath() + "\"" + (arguments == null ? "" : " " + arguments));
        File iconFile = new File(installationDir, ".install4j/" + execFile.getName() + ".png");
        if (iconFile.exists()) {
            pw.println("Icon=" + iconFile.getAbsolutePath());
        }
        if (categories != null) {
            pw.println("Categories=" + categories + (!categories.trim().endsWith(";") ? ";" : ""));
        }
        pw.close();
        FileInstaller.getInstance().install(tempFile, desktopFile, new FileOptions(new Date().getTime(), "755", OverwriteMode.ALWAYS, false, UninstallMode.ALWAYS));
        tempFile.delete();
        return desktopFile;
    }

    public static void installUnixMenu(File installationDirectory, File execFile, String name, String categories, String arguments) throws IOException, UserCanceledException {
        File menuFile;
        File desktopFile = MenuHelper.installUnixDesktopFile(installationDirectory, installationDirectory, execFile, name, categories, arguments);
        if (desktopFile != null && !execFile.getCanonicalPath().equals(new File(installationDirectory, InstallerConfig.getCurrentInstance().getUninstallerPath()).getCanonicalPath()) && (menuFile = MenuHelper.getMenuFile(name)) != null) {
            FileInstaller.getInstance().install(desktopFile, menuFile, new FileOptions(new Date().getTime(), "644", OverwriteMode.ALWAYS, false, UninstallMode.ALWAYS));
        }
    }

    public static File getMenuFile(String name) {
        File[] applicationDirs;
        for (File applicationDir : applicationDirs = new File[]{new File("/usr/share/applications"), new File("/usr/local/share/applications"), new File(Util.getUserHome(), ".local/share/applications")}) {
            File menuFile;
            File parentDir = applicationDir.getParentFile();
            if (!applicationDir.getPath().startsWith("/usr") && !applicationDir.exists() && parentDir.exists()) {
                applicationDir.mkdir();
            }
            if ((menuFile = MenuHelper.createMenuFile(name, applicationDir)) == null) continue;
            return menuFile;
        }
        return null;
    }

    private static File createMenuFile(String name, File curDir) {
        File menuFile = null;
        if (curDir.canWrite()) {
            int i = 0;
            do {
                menuFile = new File(curDir, name + "-" + i + ".desktop");
                ++i;
            } while (menuFile.exists() && !FileInstaller.getInstance().wasPreviouslyCreated(menuFile));
        }
        return menuFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createUrlLink(File tempFile, String urlSpec, File iconFile, boolean favicon) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileOutputStream(tempFile));
            pw.println("[InternetShortcut]");
            pw.print("URL=");
            pw.println(urlSpec);
            if (favicon) {
                try {
                    URL url = new URL(urlSpec);
                    pw.print("IconFile=");
                    pw.print(url.getProtocol());
                    pw.print("://");
                    pw.print(url.getHost());
                    pw.println("/favicon.ico");
                    pw.println("IconIndex=1");
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            } else if (iconFile != null) {
                pw.print("IconFile=");
                pw.println(iconFile.getPath());
                pw.println("IconIndex=0");
                pw.println("HotKey=0");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    public static void installUrlLink(ExecutionContext executionContext, String url, File targetFile, File iconFile, boolean useFavicon) throws IOException, UserCanceledException {
        File tempFile = File.createTempFile("i4j", ".url");
        MenuHelper.createUrlLink(tempFile, url, iconFile, useFavicon);
        MenuHelper.installWindowsMenu(executionContext, targetFile, tempFile, null, null, false, null);
        tempFile.delete();
    }
}

