/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens.installationcomponents;

import com.install4j.runtime.beans.screens.ComponentsScreen;
import com.install4j.runtime.beans.screens.componentselection.ComponentNode;
import com.install4j.runtime.beans.screens.componentselection.ComponentTree;
import com.install4j.runtime.beans.screens.componentselection.ComponentTreeModel;
import com.install4j.runtime.beans.screens.installationcomponents.InstallationComponentTreeModel;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.ComponentNodeConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import javax.swing.Icon;

public class InstallationComponentTree
extends ComponentTree {
    private static final Icon ICON_COMPONENT = GUIHelper.loadIcon("component_16.png");
    private static final Icon ICON_DOWNLOAD = GUIHelper.loadIcon("download_16.png");

    public InstallationComponentTree(ComponentsScreen componentsScreen) {
        super(componentsScreen);
    }

    @Override
    protected void modelSet() {
        this.checkFolders();
    }

    @Override
    public void nodeToggled() {
        this.getComponentsScreen().nodeToggled();
    }

    @Override
    public void selectionChanged(ComponentNode componentNode, boolean dependency) {
        this.getComponentsScreen().selectionChanged(componentNode, dependency);
    }

    private ComponentsScreen getComponentsScreen() {
        return (ComponentsScreen)this.getDescriptionScreen();
    }

    public void checkFolders() {
        ((InstallationComponentTreeModel)this.getModel()).checkFolders();
    }

    @Override
    protected ComponentTreeModel createTreeModel() {
        return new InstallationComponentTreeModel(this);
    }

    @Override
    public String getIconTooltip(ComponentNodeConfig config) {
        if (config instanceof ComponentConfig && InstallerConfig.getCurrentInstance().getDownloadURL().length() > 0) {
            ComponentConfig componentConfig = (ComponentConfig)config;
            if (componentConfig.isDownloaded()) {
                return Messages.getMessages().getString("ComponentDownloadedFromInternet");
            }
            return Messages.getMessages().getString("ComponentIncludedInInstaller");
        }
        return null;
    }

    @Override
    public Icon getLeafIcon(ComponentNodeConfig config) {
        if (config instanceof ComponentConfig && ((ComponentConfig)config).isDownloaded()) {
            return ICON_DOWNLOAD;
        }
        return ICON_COMPONENT;
    }

    @Override
    public int getLeafIconWidth() {
        return ICON_COMPONENT.getIconWidth();
    }
}

