/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.LeadingLabelComponent;
import com.install4j.runtime.beans.formcomponents.TextComponentUtil;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public abstract class TextComponent
extends LeadingLabelComponent
implements TextComponentUtil.InputVerifierParameterProvider {
    private String variableName;
    private String initialText = "";
    private Font textFont;
    private ScriptProperty keyValidator;
    private ScriptProperty keyListener;
    private ScriptProperty inputVerifier;
    private boolean checkIfEmpty;
    private JTextComponent textComponent;

    protected abstract JTextComponent createTextComponent();

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getInitialText() {
        return TextComponent.replaceVariables(this.initialText, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE);
    }

    public void setInitialText(String initialText) {
        this.initialText = initialText;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font textFont) {
        this.textFont = textFont;
    }

    public ScriptProperty getKeyValidator() {
        return this.keyValidator;
    }

    public void setKeyValidator(ScriptProperty keyValidator) {
        this.keyValidator = keyValidator;
    }

    public ScriptProperty getKeyListener() {
        return this.keyListener;
    }

    public void setKeyListener(ScriptProperty keyListener) {
        this.keyListener = keyListener;
    }

    public ScriptProperty getInputVerifier() {
        return this.inputVerifier;
    }

    public void setInputVerifier(ScriptProperty inputVerifier) {
        this.inputVerifier = inputVerifier;
    }

    public boolean isCheckIfEmpty() {
        return this.checkIfEmpty;
    }

    public void setCheckIfEmpty(boolean checkIfEmpty) {
        this.checkIfEmpty = checkIfEmpty;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.initText(this.textComponent);
    }

    protected void initText(JTextComponent textComponent) {
        Object initValue = this.getInitValue(this.getInitialText(), this.getVariableName(), Object.class);
        if (initValue != null) {
            textComponent.setText(initValue.toString());
            textComponent.setCaretPosition(0);
        }
    }

    @Override
    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.textComponent != null && formEnvironment != null) {
            this.textComponent.setName(formEnvironment.getId(this));
        }
    }

    @Override
    public JComponent createCenterComponent() {
        this.textComponent = this.createTextComponent();
        this.textComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                TextComponent.this.dispatchToKeyValidator(event);
            }

            @Override
            public void keyReleased(KeyEvent event) {
                TextComponent.this.dispatchToKeyListener(event);
            }
        });
        TextComponentUtil.addInputVerifier(this, this.inputVerifier, this.textComponent, this);
        this.applyTextComponentProperties(this.textComponent);
        return this.textComponent;
    }

    @Override
    public Object[] createInputVerifierParameters() {
        return new Object[]{this.getFormEnvironment(), this.textComponent.getText()};
    }

    protected JTextComponent getTextComponent() {
        return this.textComponent;
    }

    protected void applyTextComponentProperties(JTextComponent textComponent) {
        textComponent.setAlignmentX(0.0f);
        if (this.textFont != null) {
            textComponent.setFont(TextComponent.translateFont(this.textFont, textComponent));
        }
    }

    @Override
    public Object getConfigurationObject() {
        return this.textComponent;
    }

    @Override
    public boolean checkCompleted() {
        if (this.checkIfEmpty && this.textComponent.isVisible() && this.textComponent.isEnabled() && this.textComponent.getText().trim().length() == 0) {
            this.getFormEnvironment().makeParentGroupVisible(this);
            this.textComponent.requestFocus();
            GUIHelper.showMessage(this.textComponent, Messages.getMessages().getString("TextfieldEmptyWarning"), 2);
            return false;
        }
        InputVerifier inputVerifier = this.textComponent.getInputVerifier();
        if (this.isVisible() && this.isEnabled() && inputVerifier != null && !inputVerifier.verify(this.textComponent)) {
            if (!InstallerUtil.isUnattended() && !InstallerUtil.isConsole()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TextComponent.this.getFormEnvironment().makeParentGroupVisible(TextComponent.this);
                        TextComponent.this.textComponent.requestFocus();
                    }
                });
            }
            return false;
        }
        this.getContext().setVariable(this.getVariableName(), this.getValue());
        if (this.isRegisterResponseFileVariable()) {
            this.getContext().registerResponseFileVariable(this.getVariableName());
        }
        return true;
    }

    protected boolean isRegisterResponseFileVariable() {
        return true;
    }

    protected Object getValue() {
        return this.textComponent.getText().trim();
    }

    protected void dispatchToKeyValidator(KeyEvent event) {
        if (this.keyValidator != null) {
            try {
                Boolean result = (Boolean)this.getContext().runScript(this.keyValidator, this, new Object[]{this.getFormEnvironment(), Character.valueOf(event.getKeyChar()), event.getKeyCode(), this.textComponent.getText(), this.textComponent.getCaretPosition()});
                if (result != null && !result.booleanValue()) {
                    event.consume();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void dispatchToKeyListener(KeyEvent event) {
        if (this.keyListener != null) {
            try {
                Boolean result = (Boolean)this.getContext().runScript(this.keyListener, this, new Object[]{this.getFormEnvironment(), Character.valueOf(event.getKeyChar()), event.getKeyCode(), this.textComponent.getText(), this.textComponent.getCaretPosition()});
                if (result != null && !result.booleanValue()) {
                    event.consume();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        JTextComponent textField = this.getTextComponent();
        InputVerifier inputVerifier = textField.getInputVerifier();
        String oldValue = textField.getText();
        do {
            textField.setText(oldValue);
            String labelText = this.getConsoleLabelText(false);
            String newValue = this.askString(console, oldValue, labelText);
            textField.setText(newValue);
        } while (inputVerifier != null && !inputVerifier.verify(textField));
        return true;
    }

    protected String askString(Console console, String oldValue, String labelText) throws UserCanceledException {
        return console.askString(labelText, oldValue);
    }
}

