/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.LeadingLabelComponent;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.util.HyperlinkLabel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class HyperlinkActionLabelComponent
extends LeadingLabelComponent {
    private String hyperlinkText;
    private ScriptProperty actionScript;
    private HyperlinkLabel label;

    public String getHyperlinkText() {
        return this.hyperlinkText;
    }

    public void setHyperlinkText(String hyperlinkText) {
        this.hyperlinkText = hyperlinkText;
    }

    public ScriptProperty getActionScript() {
        return this.actionScript;
    }

    public void setActionScript(ScriptProperty actionScript) {
        this.actionScript = actionScript;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.label.setText(HyperlinkActionLabelComponent.replaceVariables(this.hyperlinkText, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE));
    }

    @Override
    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.label != null && formEnvironment != null) {
            this.label.setName(formEnvironment.getId(this));
        }
    }

    @Override
    public JComponent createCenterComponent() {
        this.label = new HyperlinkLabel(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HyperlinkActionLabelComponent.this.doHyperlink();
            }
        });
        return this.label;
    }

    private void doHyperlink() {
        if (this.actionScript != null) {
            try {
                this.getContext().runScript(this.actionScript, this, new Object[]{this.getFormEnvironment()});
            }
            catch (Exception e) {
                Util.printAnnotatedStackTrace(e);
                Logger.getInstance().log(e);
            }
        }
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return false;
    }

    @Override
    public Object getConfigurationObject() {
        return this.label;
    }

    @Override
    public Class getConfigurationObjectClass() {
        return JLabel.class;
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        String labelText = this.getLabelText();
        if (labelText.length() > 0) {
            console.println(labelText);
        }
        if (console.askYesNo(HyperlinkActionLabelComponent.replaceVariables(this.hyperlinkText, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE), false)) {
            this.doHyperlink();
        }
        return true;
    }
}

