/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.formcomponents.AbstractFormComponent;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.Logger;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;

public abstract class AbstractLabelComponent
extends AbstractFormComponent {
    private String labelText = "";
    private ExternalFile labelIconFile = null;
    private int iconTextGap = 4;
    private Color labelColor = null;
    private Font labelFont = null;
    private JLabel label;

    public static Font translateFont(Font font, JComponent component) {
        if (font.getSize() == 0) {
            return font.deriveFont((float)component.getFont().getSize());
        }
        return font;
    }

    public String getLabelText() {
        return AbstractLabelComponent.replaceVariables(this.labelText, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE);
    }

    public void setLabelText(String labelText) {
        this.labelText = labelText;
    }

    public ExternalFile getLabelIconFile() {
        return this.labelIconFile;
    }

    public void setLabelIconFile(ExternalFile labelIconFile) {
        this.labelIconFile = labelIconFile;
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    public void setIconTextGap(int iconTextGap) {
        this.iconTextGap = iconTextGap;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font labelFont) {
        this.labelFont = labelFont;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.labelText.trim().length() > 0) {
            this.initializeLabel(this.label);
        }
    }

    protected JLabel createLabel() {
        this.label = this.createLabel(this.labelIconFile, this.iconTextGap, this.labelColor, this.labelFont);
        return this.label;
    }

    protected JLabel createLabel(ExternalFile labelIconFile, int iconTextGap, Color labelColor, Font labelFont) {
        File actualFile;
        JLabel label = new JLabel();
        if (labelIconFile != null && (actualFile = this.getContext().getExternalFile(labelIconFile, false)).exists()) {
            try {
                label.setIcon(GUIHelper.loadIcon(actualFile));
            }
            catch (Exception e) {
                Util.printAnnotatedStackTrace(e);
                Logger.getInstance().log(e);
            }
        }
        label.setIconTextGap(iconTextGap);
        if (labelColor != null) {
            label.setForeground(labelColor);
        }
        if (labelFont != null) {
            label.setFont(AbstractLabelComponent.translateFont(labelFont, label));
        }
        if (this.labelText.trim().length() > 0) {
            this.initializeLabel(label);
        }
        return label;
    }

    protected void initializeLabel(JLabel label) {
        String labelText = this.getLabelText();
        String textWithoutMnemonics = AbstractLabelComponent.getTextWithoutMnemonics(labelText);
        label.setText(textWithoutMnemonics);
        int index = AbstractLabelComponent.getMnemonicCharIndex(labelText);
        if (index > -1) {
            label.setDisplayedMnemonic(textWithoutMnemonics.charAt(index));
            label.setDisplayedMnemonicIndex(index);
        }
    }

    protected JLabel getLabel() {
        return this.label;
    }
}

