/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.xml;

import com.install4j.api.beans.PropertyLoggingInterceptor;
import com.install4j.api.beans.ReplacementMode;
import com.install4j.api.context.Context;
import com.install4j.runtime.beans.actions.xml.AbstractModifyMultipleXmlFilesAction;
import com.install4j.runtime.installer.helper.XmlHelper;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathReplaceAction
extends AbstractModifyMultipleXmlFilesAction
implements PropertyLoggingInterceptor {
    private String xpathExpression;
    private String regex = ".*";
    private String replacement;
    private boolean replaceAll = false;
    private boolean quoteVariables = true;
    private boolean logReplacement = true;

    public String getXpathExpression() {
        return XPathReplaceAction.replaceVariables(this.xpathExpression);
    }

    public void setXpathExpression(String xpathExpression) {
        this.xpathExpression = xpathExpression;
    }

    public String getRegex() {
        return XPathReplaceAction.replaceVariables(this.regex, this.quoteVariables ? ReplacementMode.REGEXP_MATCH : ReplacementMode.PLAIN);
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public String getReplacement() {
        return XPathReplaceAction.replaceVariables(this.replacement, this.quoteVariables ? ReplacementMode.REGEXP_REPLACEMENT : ReplacementMode.PLAIN);
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public boolean isReplaceAll() {
        return this.replaceAll;
    }

    public void setReplaceAll(boolean replaceAll) {
        this.replaceAll = replaceAll;
    }

    public boolean isQuoteVariables() {
        return this.quoteVariables;
    }

    public void setQuoteVariables(boolean quoteVariables) {
        this.quoteVariables = quoteVariables;
    }

    public boolean isLogReplacement() {
        return this.logReplacement;
    }

    public void setLogReplacement(boolean logReplacement) {
        this.logReplacement = logReplacement;
    }

    @Override
    public Object getLogValueForProperty(String propertyName, Object propertyValue) {
        return this.maybeFilterLogReplacement(propertyName, "replacement", propertyValue, this.logReplacement);
    }

    @Override
    protected boolean modifyFile(File file, Context context) throws IOException {
        Document doc = this.parseFile(file);
        NodeList nodeList = this.applyXpath(doc, this.getXpathExpression());
        if (nodeList == null) {
            return false;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String nodeValue = node.getNodeValue();
            if (nodeValue == null) {
                return false;
            }
            nodeValue = this.isReplaceAll() ? nodeValue.replaceAll(this.getRegex(), this.getReplacement()) : nodeValue.replaceFirst(this.getRegex(), this.getReplacement());
            node.setNodeValue(nodeValue);
        }
        XmlHelper.writeFile(file, doc);
        return true;
    }
}

