/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.properties;

import com.install4j.api.beans.ExternalFile;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import com.install4j.runtime.beans.actions.properties.AbstractPropertiesFileAction;
import com.install4j.runtime.beans.actions.properties.LineSeparator;
import com.install4j.runtime.beans.actions.properties.PropertiesFileParameters;
import com.install4j.runtime.beans.actions.properties.PropertiesSortMode;
import com.install4j.runtime.beans.actions.properties.PropertiesSource;
import com.install4j.runtime.beans.actions.properties.PropertiesWriteParameters;
import com.install4j.runtime.beans.actions.properties.TextProperties;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class WritePropertiesFileAction
extends AbstractPropertiesFileAction {
    private LineSeparator lineSeparator = LineSeparator.SYSTEM;
    private boolean merge = true;
    private boolean updateExistingKeys = false;
    private boolean updateExistingComments = false;
    private PropertiesSource propertiesSource = PropertiesSource.DIRECT;
    private String sourcePropertyDefinitions = "";
    private String sourceVariableName = "";
    private ExternalFile sourceFile;
    private boolean replaceInstallerVariables = true;
    private PropertiesSortMode propertiesSortMode = PropertiesSortMode.UNSORTED_APPEND;

    public LineSeparator getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(LineSeparator lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }

    public boolean isUpdateExistingKeys() {
        return this.updateExistingKeys;
    }

    public void setUpdateExistingKeys(boolean updateExistingKeys) {
        this.updateExistingKeys = updateExistingKeys;
    }

    public boolean isUpdateExistingComments() {
        return this.updateExistingComments;
    }

    public void setUpdateExistingComments(boolean updateExistingComments) {
        this.updateExistingComments = updateExistingComments;
    }

    public PropertiesSource getPropertiesSource() {
        return this.propertiesSource;
    }

    public void setPropertiesSource(PropertiesSource propertiesSource) {
        this.propertiesSource = propertiesSource;
    }

    public String getSourcePropertyDefinitions() {
        return this.sourcePropertyDefinitions;
    }

    public void setSourcePropertyDefinitions(String sourcePropertyDefinitions) {
        this.sourcePropertyDefinitions = sourcePropertyDefinitions;
    }

    public String getSourceVariableName() {
        return WritePropertiesFileAction.replaceVariables(this.sourceVariableName);
    }

    public void setSourceVariableName(String sourceVariableName) {
        this.sourceVariableName = sourceVariableName;
    }

    public ExternalFile getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(ExternalFile sourceFile) {
        this.sourceFile = sourceFile;
    }

    public boolean isReplaceInstallerVariables() {
        return this.replaceInstallerVariables;
    }

    public void setReplaceInstallerVariables(boolean replaceInstallerVariables) {
        this.replaceInstallerVariables = replaceInstallerVariables;
    }

    public PropertiesSortMode getPropertiesSortMode() {
        return this.propertiesSortMode;
    }

    public void setPropertiesSortMode(PropertiesSortMode propertiesSortMode) {
        this.propertiesSortMode = propertiesSortMode;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        TextProperties sourceProperties;
        PropertiesWriteParameters parameters = new PropertiesWriteParameters(this.getEncoding(), this.getCharsetName(), this.getLineSeparator());
        File usedFile = context.getDestinationFile(this.getFile());
        TextProperties targetProperties = new TextProperties();
        if (usedFile.exists()) {
            if (this.isMerge()) {
                try {
                    targetProperties.read(usedFile, (PropertiesFileParameters)parameters);
                }
                catch (IOException e) {
                    Logger.getInstance().error(this, "Could not read properties file");
                    Logger.getInstance().log(e);
                    return false;
                }
                Logger.getInstance().info(this, "Merging existing properties file with " + targetProperties.size() + " properties");
            }
            if (context instanceof InstallerContext) {
                BackupFileForRollbackAction backupAction = new BackupFileForRollbackAction(usedFile, true);
                backupAction.install((InstallerContext)context);
                this.addRollbackAction(backupAction);
            }
        }
        if (!this.fillSourceProperties(sourceProperties = new TextProperties(), context)) {
            return false;
        }
        TextProperties mergedProperties = this.mergeProperties(sourceProperties, targetProperties);
        try {
            mergedProperties.write(usedFile, parameters);
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
            return false;
        }
        return true;
    }

    private boolean fillSourceProperties(TextProperties sourceProperties, Context context) {
        try {
            switch (this.propertiesSource) {
                case DIRECT: {
                    return this.fillSourcePropertiesDirect(sourceProperties);
                }
                case FILE: {
                    return this.fillSourcePropertiesFile(sourceProperties, context);
                }
                case VARIABLE: {
                    return this.fillSourcePropertiesVariable(sourceProperties, context);
                }
            }
            throw new RuntimeException(this.propertiesSource.name());
        }
        catch (IOException e) {
            Logger.getInstance().error(this, "Invalid property definitions");
            Logger.getInstance().log(e);
            return false;
        }
    }

    private boolean fillSourcePropertiesDirect(TextProperties sourceProperties) throws IOException {
        sourceProperties.read(new StringReader(this.sourcePropertyDefinitions));
        return true;
    }

    private boolean fillSourcePropertiesFile(TextProperties sourceProperties, Context context) throws IOException {
        File usedSourceFile = context.getExternalFile(this.getSourceFile(), false);
        if (!usedSourceFile.exists()) {
            Logger.getInstance().error(this, "Properties source file " + usedSourceFile + " does not exist");
            return false;
        }
        PropertiesFileParameters parameters = new PropertiesFileParameters(this.getEncoding(), this.getCharsetName());
        sourceProperties.read(usedSourceFile, parameters);
        return true;
    }

    private boolean fillSourcePropertiesVariable(TextProperties sourceProperties, Context context) {
        String variableName = this.getSourceVariableName();
        Object variable = context.getVariable(variableName);
        if (variable == null) {
            Logger.getInstance().error(this, "Properties source variable " + variableName + " has not been set");
            return false;
        }
        if (!(variable instanceof Map)) {
            Logger.getInstance().error(this, "Properties source variable " + variableName + " is not an instance of java.util.Map");
            return false;
        }
        if (variable instanceof TextProperties) {
            sourceProperties.putAll((TextProperties)variable);
        } else {
            Map map = (Map)variable;
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key == null || value == null) continue;
                sourceProperties.put(key.toString(), value.toString());
            }
        }
        return true;
    }

    private TextProperties mergeProperties(TextProperties sourceProperties, TextProperties targetProperties) {
        TextProperties newProperties = new TextProperties();
        for (Map.Entry entry : sourceProperties.entrySet()) {
            String comment;
            String key = (String)entry.getKey();
            boolean keyAlreadyPresent = targetProperties.containsKey(key);
            String value = this.maybeReplaceVariables((String)entry.getValue());
            if (this.isUpdateExistingKeys() && keyAlreadyPresent) {
                targetProperties.put(key, value);
            } else if (!keyAlreadyPresent) {
                newProperties.put(key, value);
            }
            if ((comment = this.maybeReplaceVariables(sourceProperties.getPrefix(key))) == null) continue;
            if (this.isUpdateExistingComments() && keyAlreadyPresent) {
                targetProperties.setPrefix(key, comment);
                continue;
            }
            if (keyAlreadyPresent) continue;
            newProperties.setPrefix(key, comment);
        }
        PropertiesSortMode propertiesSortMode = this.getPropertiesSortMode();
        switch (propertiesSortMode) {
            case UNSORTED_APPEND: {
                targetProperties.putAll(newProperties);
                return targetProperties;
            }
            case UNSORTED_PREPEND: {
                newProperties.putAll(targetProperties);
                return newProperties;
            }
            case KEYS_ALPHABETICALLY: {
                targetProperties.putAll(newProperties);
                return this.sortKeys(targetProperties);
            }
        }
        throw new RuntimeException(propertiesSortMode.name());
    }

    private TextProperties sortKeys(TextProperties textProperties) {
        ArrayList keys = new ArrayList();
        keys.addAll(textProperties.keySet());
        Collections.sort(keys);
        TextProperties sortedProperties = new TextProperties();
        for (String key : keys) {
            sortedProperties.put(key, textProperties.get(key));
            String prefix = textProperties.getPrefix(key);
            if (prefix == null) continue;
            sortedProperties.setPrefix(key, prefix);
        }
        return sortedProperties;
    }

    private String maybeReplaceVariables(String text) {
        if (text != null && this.isReplaceInstallerVariables()) {
            return WritePropertiesFileAction.replaceVariables(text, VariableErrorHandlingDescriptor.ALWAYS_EXCEPTION);
        }
        return text;
    }
}

