/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.files.AbstractRecursiveFileAction;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class CreateZipFileAction
extends AbstractRecursiveFileAction {
    private File zipFile;
    private boolean addTopLevelDirectoriesToRelativePath;
    private transient ZipOutputStream zipOutputStream;

    public File getZipFile() {
        return CreateZipFileAction.replaceVariables(this.zipFile);
    }

    public void setZipFile(File zipFile) {
        this.zipFile = zipFile;
    }

    @Override
    public boolean isAddTopLevelDirectoriesToRelativePath() {
        return this.addTopLevelDirectoriesToRelativePath;
    }

    public void setAddTopLevelDirectoriesToRelativePath(boolean addTopLevelDirectoriesToRelativePath) {
        this.addTopLevelDirectoriesToRelativePath = addTopLevelDirectoriesToRelativePath;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        try {
            this.zipOutputStream = new ZipOutputStream(new FileOutputStream(this.getZipFile()));
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
            return false;
        }
        boolean success = super.execute(context);
        if (success) {
            try {
                this.zipOutputStream.close();
            }
            catch (IOException e) {
                Logger.getInstance().log(e);
                return false;
            }
        }
        return success;
    }

    @Override
    public boolean isRecursive() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean executeForSingleRecursiveFile(Context context, File file, File relativeSourceFile, ProgressAdapter progressAdapter) throws UserCanceledException, IOException {
        String entryName = relativeSourceFile.getPath().replace('\\', '/');
        if (entryName.startsWith("./")) {
            entryName = entryName.substring(2);
        }
        if (file.isDirectory()) {
            entryName = entryName + "/";
        }
        ZipEntry zipEntry = new ZipEntry(entryName);
        zipEntry.setTime(file.lastModified());
        this.zipOutputStream.putNextEntry(zipEntry);
        if (file.isFile()) {
            FileInputStream in = new FileInputStream(file);
            try {
                FileUtil.pumpStream(in, this.zipOutputStream, progressAdapter);
            }
            finally {
                in.close();
            }
        }
        this.zipOutputStream.closeEntry();
        return true;
    }
}

