/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public abstract class AbstractExtractZipFileAction
extends SystemInstallOrUninstallAction {
    private static final String DEFAULT_DIR_MODE = "755";
    private File zipFile;
    private File destinationDirectory;
    private String mode = "644";
    private String dirMode = "755";
    private boolean showProgress = true;
    private ScriptProperty fileFilter;

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public File getZipFile() {
        return AbstractExtractZipFileAction.replaceVariables(this.zipFile);
    }

    public void setZipFile(File zipFile) {
        this.zipFile = zipFile;
    }

    public File getDestinationDirectory() {
        return AbstractExtractZipFileAction.replaceVariables(this.destinationDirectory);
    }

    public void setDestinationDirectory(File destinationDirectory) {
        this.destinationDirectory = destinationDirectory;
    }

    public String getMode() {
        return AbstractExtractZipFileAction.replaceVariables(this.mode);
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getDirMode() {
        return AbstractExtractZipFileAction.replaceVariables(this.dirMode);
    }

    public void setDirMode(String dirMode) {
        this.dirMode = dirMode;
    }

    public ScriptProperty getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(ScriptProperty fileFilter) {
        this.fileFilter = fileFilter;
    }

    protected abstract void createFile(File var1, ZipInputStream var2, ZipEntry var3, long var4, ProgressAdapter var6) throws UserCanceledException, IOException;

    protected abstract void createDirectory(File var1) throws IOException;

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        File usedSourceFile = context.getDestinationFile(this.getZipFile());
        if (!usedSourceFile.exists()) {
            Logger.getInstance().error(this, usedSourceFile + " does not exist");
            return false;
        }
        File usedDestinationDirectory = context.getDestinationFile(this.getDestinationDirectory());
        try {
            this.extractZip((InstallerContext)context, usedSourceFile, usedDestinationDirectory);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            Logger.getInstance().error(this, "exception " + e);
            Logger.getInstance().log(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractZip(InstallerContext context, File sourceFile, File destDir) throws IOException, UserCanceledException {
        ProgressInterface progressInterface = context.getProgressInterface();
        boolean showProgress = this.isShowProgress();
        ArrayList<Long> fileSizes = new ArrayList<Long>();
        long maxProgress = Long.MAX_VALUE;
        if (showProgress) {
            progressInterface.setPercentCompleted(0);
            progressInterface.setDetailMessage("");
            maxProgress = AbstractExtractZipFileAction.getMaxProgress(sourceFile, fileSizes);
        }
        ZipInputStream zipIn = new ZipInputStream(new BufferedInputStream(new FileInputStream(sourceFile)));
        try {
            long currentProgress = 0L;
            int index = 0;
            ZipEntry zipEntry = zipIn.getNextEntry();
            while (zipEntry != null) {
                if (context.isCancelling()) {
                    throw new UserCanceledException();
                }
                String entryName = AbstractExtractZipFileAction.getEntryName(zipEntry);
                if (this.passesFileFilter(entryName, context)) {
                    if (showProgress) {
                        progressInterface.setDetailMessage(InstallerUtil.cleanupName(entryName));
                    }
                    long nextProgress = currentProgress + 153600L;
                    long currentSize = fileSizes.isEmpty() ? 0L : (Long)fileSizes.get(index++);
                    File destFile = new File(destDir, entryName);
                    if (zipEntry.isDirectory()) {
                        this.createDirectory(destFile);
                        destFile.setLastModified(zipEntry.getTime());
                        if (!InstallerUtil.isWindows()) {
                            UnixFileSystem.setMode(this.getDirMode(), destFile);
                        }
                    } else {
                        nextProgress += currentSize;
                        ProgressAdapter progressAdapter = null;
                        if (showProgress) {
                            progressAdapter = new ProgressAdapter(progressInterface, (int)(currentProgress * 100L / maxProgress), (int)(nextProgress * 100L / maxProgress));
                        }
                        this.createFile(destFile, zipIn, zipEntry, currentSize, progressAdapter);
                    }
                    if (context.isCancelling()) {
                        throw new UserCanceledException();
                    }
                    currentProgress = nextProgress;
                    if (showProgress) {
                        progressInterface.setPercentCompleted((int)(currentProgress * 100L / maxProgress));
                    }
                }
                zipEntry = zipIn.getNextEntry();
            }
        }
        finally {
            zipIn.close();
            if (showProgress) {
                progressInterface.setPercentCompleted(100);
                progressInterface.setDetailMessage("");
            }
        }
    }

    private static String getEntryName(ZipEntry zipEntry) {
        String zipName = zipEntry.getName();
        zipName = InstallerUtil.isWindows() ? zipName.replace('/', '\\') : zipName.replace('\\', '/');
        return zipName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getMaxProgress(File sourceFile, List<Long> fileSizes) throws IOException {
        long maxProgress = 0L;
        ZipFile zipFile = new ZipFile(sourceFile);
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                long size = zipEntry.isDirectory() ? 0L : zipEntry.getSize();
                fileSizes.add(size);
                maxProgress += size + 153600L;
            }
            long l = maxProgress;
            return l;
        }
        finally {
            zipFile.close();
        }
    }

    private boolean passesFileFilter(String entryName, Context context) {
        File entryFile = new File(entryName);
        return ContextImpl.runBooleanScript(context, this.fileFilter, this, new Object[]{entryFile, entryName.endsWith(File.separator)});
    }
}

