/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.launcher;

import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.VariableEncoding;
import com.install4j.runtime.installer.helper.apiimpl.VariablesImpl;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Variables {
    private static Map<String, String> compilerVariables;
    private static Map<String, Object> installerVariables;
    private static String applicationId;

    private Variables() {
    }

    public static String getCompilerVariable(String variableName) throws IOException {
        if (compilerVariables == null) {
            InstallerConfig config = InstallerConfig.getConfigFromFile(InstallerUtil.getInstallerFile("i4jparams.conf"));
            if (config == null) {
                throw new IOException("Could not read config");
            }
            compilerVariables = config.getCompilerVariables();
        }
        return compilerVariables.get(variableName);
    }

    public static synchronized Map<String, Object> getInstallerVariables() {
        Variables.ensureInstallerVariablesRead();
        return installerVariables;
    }

    public static synchronized Object getInstallerVariable(String variableName) {
        Variables.ensureInstallerVariablesRead();
        return installerVariables.get(variableName);
    }

    public static Map<String, Object> loadFromPreferenceStore(boolean userSpecific) throws IOException {
        return Variables.loadFromPreferenceStore(Variables.getApplicationId(), userSpecific);
    }

    public static Map<String, Object> loadFromPreferenceStore(String packageName, boolean userSpecific) throws IOException {
        return VariablesImpl.loadVariablesFromPreferenceStore(packageName, userSpecific);
    }

    public static void saveToPreferenceStore(Map<String, Object> variables, boolean userSpecific) throws IOException {
        Variables.saveToPreferenceStore(variables, Variables.getApplicationId(), userSpecific);
    }

    public static void saveToPreferenceStore(Map<String, Object> variables, String packageName, boolean userSpecific) throws IOException {
        VariablesImpl.saveVariablesToPreferenceStore(variables, packageName, userSpecific);
    }

    public static synchronized void clearInstallerVariablesCache() {
        installerVariables = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void ensureInstallerVariablesRead() {
        if (installerVariables == null) {
            InputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(InstallerUtil.getInstallerFile("response.varfile")));
                Properties properties = new Properties();
                properties.load(in);
                HashMap<String, String> encodedVariables = new HashMap<String, String>();
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    encodedVariables.put((String)entry.getKey(), (String)entry.getValue());
                }
                installerVariables = VariableEncoding.decodeVariables(encodedVariables, true);
            }
            catch (IOException ex) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (installerVariables == null) {
                installerVariables = new HashMap<String, Object>();
            }
            if (System.getProperty("install4j.commIdentifier") == null) {
                InstallerVariables.initUserVars(installerVariables);
                InstallerVariables.initSystemVars(installerVariables);
            }
        }
    }

    private static String getApplicationId() throws IOException {
        if (applicationId == null) {
            applicationId = InstallerConfig.getGeneralConfigFromFile(InstallerUtil.getInstallerFile("i4jparams.conf")).getApplicationId();
        }
        return applicationId;
    }
}

