/* Copyright &#169; JSCAPE Corp. 2009-2019. All Rights Reserved */
jscape.LoginController=Class.extend({init:function(page,changePasswordController,url){this.page=page;this.changePasswordController=changePasswordController;this.url=url;},start:function(){this.page.show(this);},onSubmit:function(){var credentials={username:this.page.getUsername(),password:this.page.getPassword()};jscape.ApiClient.login(credentials,$.proxy(this._loggedIn,this));},onChangePassword:function(){this.changePasswordController.start(this.page.getUsername());},_loggedIn:function(){window.location=this.url;}});jscape.LoginPage=Class.extend({init:function(){this.form=$("#loginForm");this.form.form();this.usernameField=$("#usernameField");this.usernameField.textbox({required:true,missingMessage:jscape.Resources["loginPage.error.emptyUsername.message"],validType:requiredFieldRule("requiredLogin",jscape.Resources["loginPage.error.emptyUsername.message"])});this.usernameField.textbox("textbox").bind("keydown",$.proxy(function(e){if(returnPressed(e.keyCode)){this.passwordField.passwordbox("textbox").focus();}},this));this.passwordField=$("#passwordField");this.passwordField.passwordbox({});this.passwordField.passwordbox("textbox").bind("keydown",$.proxy(function(e){if(returnPressed(e.keyCode)){this._onSubmit();}},this));this.submitButton=$("#submitButton");this.submitButton.linkbutton({width:jscape.Resources.buttonSize()});this.submitButton.click($.proxy(this._onSubmit,this));this.changePasswordButton=$("#changePasswordButton");this.changePasswordButton.click($.proxy(this._onChangePassword,this));},show:function(listener){this.listener=listener;this.form.form("reset");this.usernameField.textbox("textbox").focus();},getUsername:function(){return this.usernameField.textbox("getValue").trim();},getPassword:function(){return this.passwordField.passwordbox("getValue");},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onChangePassword:function(){if(this.form.form("validate")){this.listener.onChangePassword();}}});jscape.ChangePasswordController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(username){jscape.ApiClient.startPasswordChanging(username,$.proxy(this._passwordChangingStarted,this));},onSubmit:function(){var data={securityCode:this.dialog.getSecurityCode(),password:this.dialog.getPassword()};this.dialog.hide();jscape.ApiClient.finishPasswordChanging(data,$.proxy(this._passwordChangingFinished,this));},onCancel:function(){this.dialog.hide();},_passwordChangingStarted:function(){showMessage(jscape.Resources["changePasswordStartedDialog.message"].supplant(this.rowValue));this._showDialog();},_showDialog:function(){this.dialog.reset();this.dialog.show(this);},_passwordChangingFinished:function(){showMessage(jscape.Resources["changePasswordFinishedDialog.message"].supplant(this.rowValue));}});jscape.ChangePasswordDialog=Class.extend({init:function(){this.dialog=$("#changePasswordDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["changePasswordDialog.title"],width:jscape.Resources.intVal("changePasswordDialog.width"),height:jscape.Resources.intVal("changePasswordDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.change.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.securityCodeField=$("#securityCodeField");this.securityCodeField.textbox({required:true,missingMessage:jscape.Resources["changePasswordDialog.error.emptySecurityCode.message"],validType:[requiredFieldRule("requiredSecurityCode",jscape.Resources["changePasswordDialog.error.emptySecurityCode.message"])]});this.newPasswordField=$("#newPasswordField");this.newPasswordField.passwordbox({required:true,missingMessage:jscape.Resources["changePasswordDialog.error.emptyPassword.message"],validType:[requiredFieldRule("requiredNewPassword",jscape.Resources["changePasswordDialog.error.emptyPassword.message"])]});this.newPasswordConfirmationField=$("#newPasswordConfirmationField");this.newPasswordConfirmationField.passwordbox({required:true,missingMessage:jscape.Resources["changePasswordDialog.error.emptyPasswordConfirmation.message"],validType:[requiredFieldRule("requiredNewPasswordConfirmation",jscape.Resources["changePasswordDialog.error.emptyPasswordConfirmation.message"]),validationRule("sameNewPasswords",$.proxy(function(){return this.newPasswordField.val()===this.newPasswordConfirmationField.val();},this),jscape.Resources["changePasswordDialog.error.nonEqualPasswords.message"])]});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.securityCodeField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getSecurityCode:function(){return this.securityCodeField.textbox("getValue").trim();},getPassword:function(){return this.newPasswordField.passwordbox("getValue");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});