/* Copyright &#169; JSCAPE Corp. 2009-2019. All Rights Reserved */
jscape.EmailController=Class.extend({init:function(page,changeEmailConfigurationController,testEmailServiceController){this.page=page;this.changeEmailConfigurationController=changeEmailConfigurationController;this.testEmailServiceController=testEmailServiceController;},start:function(){jscape.ApiClient.emailServiceConfiguration($.proxy(this._configurationLoaded,this));},onTest:function(){this.testEmailServiceController.start(this.configuration);},onChange:function(){this.changeEmailConfigurationController.start($.proxy(this._configurationUpdated,this));},_configurationLoaded:function(configuration){this.configuration=configuration;this._initPage();this.page.show(this);},_configurationUpdated:function(configuration){this.configuration=configuration;this._initPage();},_initPage:function(){this.page.setHost(this.configuration.address.host,this.configuration.address.port);this.page.setProtocol(this.configuration.connectionType);this.page.setUsername(this.configuration.username);this.page.setSender(this.configuration.sender);this.page.setDebugFile(this.configuration.debugFile);}});jscape.EmailPage=Class.extend({init:function(){this.infoPanel=$("#infoPanel");this.infoPanel.tabs({border:true,plain:true});this.emailServerHostField=$("#emailServerHostField");this.emailServerProtocolField=$("#emailServerProtocolField");this.emailServerUsernameField=$("#emailServerUsernameField");this.emailServerDebugFileField=$("#emailServerDebugFileField");this.emailServerSenderField=$("#emailServerSenderField");this.testButton=$("#testButton");this.testButton.linkbutton({width:jscape.Resources.buttonSize()});this.testButton.click($.proxy(function(){if(!this.testButton.linkbutton("options").disabled){this._onTest();}},this));this.changeButton=$("#changeButton");this.changeButton.linkbutton({width:jscape.Resources.buttonSize()});this.changeButton.click($.proxy(this._onChange,this));},show:function(listener){this.listener=listener;this.infoPanel.css("visibility","visible");},setHost:function(host,port){this.emailServerHostField.text("{host}:{port}".supplant({host:host,port:port}));},setProtocol:function(value){this.emailServerProtocolField.text(jscape.Resources["email.protocol."+value]);},setUsername:function(value){this.emailServerUsernameField.text(value);},setSender:function(value){this.emailServerSenderField.text(value);},setDebugFile:function(value){this.emailServerDebugFileField.text(value||"");},_onTest:function(){this.listener.onTest();},_onChange:function(){this.listener.onChange();}});jscape.ChangeEmailConfigurationController=Class.extend({init:function(dialog,selectLogDirectoryController,testEmailServiceController){this.dialog=dialog;this.selectLogDirectoryController=selectLogDirectoryController;this.testEmailServiceController=testEmailServiceController;},start:function(callback){this.callback=callback;jscape.ApiClient.emailServiceConfiguration($.proxy(this._configurationLoaded,this));},onSelectDebugFile:function(){this.selectLogDirectoryController.selectPath($.proxy(function(entry,path){this.dialog.setDebugFile(path);},this));},onTest:function(){var configuration={address:{host:this.dialog.getHost(),port:this.dialog.getPort()},connectionType:this.dialog.getProtocol(),username:this.dialog.getUsername(),password:this.dialog.getPassword(),sender:this.dialog.getSender(),debugFile:this.dialog.getDebugFile()};this.testEmailServiceController.start(configuration);},onSubmit:function(){var configuration={address:{host:this.dialog.getHost(),port:this.dialog.getPort()},connectionType:this.dialog.getProtocol(),username:this.dialog.getUsername(),password:this.dialog.getPassword(),sender:this.dialog.getSender(),debugFile:this.dialog.getDebugFile(),version:this.configuration.version};jscape.ApiClient.updateEmailServiceConfiguration(configuration,$.proxy(this._configurationUpdated,this));},onCancel:function(){this.dialog.hide();this.callback(this.configuration);},_configurationLoaded:function(configuration){this.configuration=configuration;this.dialog.reset();this.dialog.setHost(this.configuration.address.host);this.dialog.setPort(this.configuration.address.port);this.dialog.setProtocol(this.configuration.connectionType);this.dialog.setUsername(this.configuration.username);this.dialog.setPassword(this.configuration.password);this.dialog.setSender(this.configuration.sender);this.dialog.setDebugFile(this.configuration.debugFile);this.dialog.show(this);},_configurationUpdated:function(configuration){this.dialog.hide();showMessage(jscape.Resources["emailServiceConfigurationAppliedDialog.message"]);this.callback(configuration);}});jscape.ChangeEmailConfigurationDialog=Class.extend({init:function(){this.dialog=$("#emailConfigurationDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["emailConfigurationDialog.title"],width:jscape.Resources.intVal("emailConfigurationDialog.width"),height:jscape.Resources.intVal("emailConfigurationDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.test.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onTest,this)},{text:jscape.Resources["button.save.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.hostField=$("#hostField");this.hostField.textbox({required:true,missingMessage:jscape.Resources["emailConfigurationDialog.error.emptyHost.message"],validType:[requiredFieldRule("requiredHost",jscape.Resources["emailConfigurationDialog.error.emptyHost.message"])]});this.portField=$("#portField");this.portField.numberspinner({min:1,max:65535,value:25,increment:1,required:true,missingMessage:jscape.Resources["emailConfigurationDialog.error.emptyPort.message"]});this.protocolField=$("#protocolField");this.protocolField.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.usernameField=$("#usernameField");this.usernameField.textbox({});this.passwordField=$("#passwordField");this.passwordField.passwordbox({});this.debugFileField=$("#debugFileField");this.debugFileField.textbox({});this.selectDebugFileButton=$("#selectDebugFileButton");this.selectDebugFileButton.linkbutton({width:jscape.Resources.intVal("button.browse.width"),height:jscape.Resources.intVal("button.browse.height")});this.selectDebugFileButton.click($.proxy(function(){this.listener.onSelectDebugFile();},this));this.senderField=$("#senderField");this.senderField.textbox({required:true,missingMessage:jscape.Resources["emailConfigurationDialog.error.emptySender.message"],validType:"email"});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.hostField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getHost:function(){return this.hostField.textbox("getValue").trim();},setHost:function(value){this.hostField.textbox("setValue",value);this.hostField.textbox("validate");},getPort:function(){return parseInt(this.portField.numberspinner("getValue"),10);},setPort:function(value){this.portField.numberspinner("setValue",value);},getProtocol:function(){return this.protocolField.combobox("getValue");},setProtocol:function(value){this.protocolField.combobox("setValue",value).combobox("select",value);},getUsername:function(){return this.usernameField.textbox("getValue").trim();},setUsername:function(value){this.usernameField.textbox("setValue",value);},getPassword:function(){return this.passwordField.passwordbox("getValue");},setPassword:function(value){this.passwordField.passwordbox("setValue",value);},getSender:function(){return this.senderField.textbox("getValue").trim();},setSender:function(value){this.senderField.textbox("setValue",value);this.senderField.textbox("validate");},getDebugFile:function(){return this.debugFileField.textbox("getValue").trim();},setDebugFile:function(value){this.debugFileField.textbox("setValue",value||"");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onTest:function(){if(this.form.form("validate")){this.listener.onTest();}},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.TestEmailServiceController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(configuration){this.configuration=configuration;this.dialog.reset();this.dialog.show(this);},onSubmit:function(){jscape.ApiClient.testEmailServiceConfiguration(this.configuration,this.dialog.getRecipient(),$.proxy(this._testPassed,this));},onCancel:function(){this.dialog.hide();},_testPassed:function(){this.dialog.hide();showMessage(jscape.Resources["emailServiceTestPassedDialog.message"]);}});jscape.TestEmailServiceDialog=Class.extend({init:function(){this.dialog=$("#testEmailServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["testEmailServiceDialog.title"],width:jscape.Resources.intVal("testEmailServiceDialog.width"),height:jscape.Resources.intVal("testEmailServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.test.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.recipientField=$("#recipientField");this.recipientField.textbox({required:true,missingMessage:jscape.Resources["testEmailServiceDialog.error.emptyRecipient.message"],validType:"email"});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.recipientField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getRecipient:function(){return this.recipientField.textbox("getValue").trim();},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});