/* Copyright &#169; JSCAPE Corp. 2009-2019. All Rights Reserved */
jscape.DatastoreController=Class.extend({init:function(page,changeDatastoreConfigurationController){this.page=page;this.changeDatastoreConfigurationController=changeDatastoreConfigurationController;},start:function(){jscape.ApiClient.databaseConfiguration($.proxy(this._configurationLoaded,this));},onChange:function(){this.changeDatastoreConfigurationController.start($.proxy(this._configurationUpdated,this));},_configurationLoaded:function(configuration){this.configuration=configuration;this._initPage();this.page.show(this);},_configurationUpdated:function(configuration){this.configuration=configuration;this._initPage();},_initPage:function(){this.page.setJdbcUrl(this.configuration.url);this.page.setUsername(this.configuration.username);this.page.setPoolSize(this.configuration.connectionPoolSize);this.page.setPoolTimeout(this.configuration.idleConnectionTtlMillis);this.page.setSynchronization(this.configuration.synchronizationPeriodMillis);}});jscape.DatastorePage=Class.extend({POOL_TIMEOUT_FACTOR:1000,SYNCHRONIZATION_PERIOD_FACTOR:1000,init:function(){this.infoPanel=$("#infoPanel");this.infoPanel.tabs({border:true,plain:true});this.jdbcUrlLabelField=$("#jdbcUrlLabelField");this.usernameLabelField=$("#usernameLabelField");this.poolSizeLabelField=$("#poolSizeLabelField");this.poolTimeoutLabelField=$("#poolTimeoutLabelField");this.synchronizationLabelField=$("#synchronizationLabelField");this.changeButton=$("#changeButton");this.changeButton.linkbutton({width:jscape.Resources.buttonSize()});this.changeButton.click($.proxy(this._onChange,this));},show:function(listener){this.listener=listener;this.infoPanel.css("visibility","visible");},setJdbcUrl:function(value){this.jdbcUrlLabelField.text(value);},setUsername:function(value){this.usernameLabelField.text(value);},setPoolSize:function(value){this.poolSizeLabelField.text(jscape.Resources["datastorePage.poolSizeLabel.value"].supplant({value:value}));},setPoolTimeout:function(value){this.poolTimeoutLabelField.text(jscape.Resources["datastorePage.poolTimeoutLabel.value"].supplant({value:value/this.POOL_TIMEOUT_FACTOR}));},setSynchronization:function(value){this.synchronizationLabelField.text(value?jscape.Resources["datastorePage.synchronizationLabel.value"].supplant({value:value/this.SYNCHRONIZATION_PERIOD_FACTOR}):jscape.Resources["datastorePage.synchronizationLabel.value.none"]);},_onChange:function(){this.listener.onChange();}});jscape.ChangeDatastoreConfigurationController=Class.extend({init:function(dialog,protocol,uri){this.dialog=dialog;this.protocol=protocol;this.uri=uri;},start:function(callback){this.callback=callback;jscape.ApiClient.databaseConfiguration($.proxy(this._configurationLoaded,this));},onTest:function(){var configuration=this._configuration();jscape.ApiClient.testDatabaseConfiguration(configuration,$.proxy(this._configurationTested,this));},onMigrate:function(){var configuration=this._configuration();jscape.ApiClient.migrateData(configuration,$.proxy(this._dataMigrated,this));},onSubmit:function(){var configuration=this._configuration();jscape.ApiClient.webServiceConfigurationFor(configuration,$.proxy(function(webServiceConfiguration){this._webServiceConfigurationObtained(webServiceConfiguration,configuration);},this));},onCancel:function(){this.dialog.hide();this.callback(this.configuration);},_configurationLoaded:function(configuration){this.configuration=configuration;this.dialog.reset();this.dialog.setJdbcUrl(this.configuration.url);this.dialog.setUsername(this.configuration.username);this.dialog.setPassword(this.configuration.password);this.dialog.setPoolSize(this.configuration.connectionPoolSize);this.dialog.setPoolTimeout(this.configuration.idleConnectionTtlMillis);this.dialog.setSynchronizationPeriod(this.configuration.synchronizationPeriodMillis);this.dialog.show(this);},_configurationUpdated:function(configuration){this.dialog.hide();showMessage(jscape.Resources["datastoreConfigurationAppliedDialog.message"]);this.callback(configuration);},_configurationTested:function(result){showMessage(jscape.Resources[result.administratorPresent?"databaseTestPassedDialog.message.ok":"databaseTestPassedDialog.message.no.admin"]);},_dataMigrated:function(){showMessage(jscape.Resources["dataMigratedDialog.message"]);},_webServiceConfigurationObtained:function(webServiceConfiguration,configuration){jscape.ApiClient.updateDatabaseConfiguration(configuration,$.proxy(function(){this._configurationUpdated(configuration);},this));if(!this._sameConfiguration(configuration)){setTimeout($.proxy(function(){this._reloadPage(webServiceConfiguration);},this),2000);}},_configuration:function(){return{url:this.dialog.getJdbcUrl(),username:this.dialog.getUsername(),password:this.dialog.getPassword(),connectionPoolSize:this.dialog.getPoolSize(),idleConnectionTtlMillis:this.dialog.getPoolTimeout(),synchronizationPeriodMillis:this.dialog.getSynchronizationPeriod()};},_reloadPage:function(configuration){if((this.protocol==="https"||configuration.httpsEnabled)&&!configuration.httpEnabled){var httpsHost=this._adjustHost(configuration.httpsAddress.host);var httpsPort=configuration.httpsAddress.port==="443"?"":":"+configuration.httpsAddress.port;window.location="https://{host}{port}{uri}".supplant({host:httpsHost,port:httpsPort,uri:this.uri});}else{var httpHost=this._adjustHost(configuration.httpAddress.host);var httpPort=configuration.httpAddress.port==="80"?"":":"+configuration.httpAddress.port;window.location="http://{host}{port}{uri}".supplant({host:httpHost,port:httpPort,uri:this.uri});}},_adjustHost:function(host){return host!=="::"&&host!=="0.0.0.0"?host:window.location.hostname;},_sameConfiguration:function(that){if(this.configuration.connectionPoolSize!==that.connectionPoolSize){return false;}
if(this.configuration.idleConnectionTtlMillis!==that.idleConnectionTtlMillis){return false;}
if(this.configuration.url!==that.url){return false;}
if(this.configuration.username!==that.username){return false;}
return this.configuration.password===that.password;}});jscape.ChangeDatastoreConfigurationDialog=Class.extend({POOL_TIMEOUT_FACTOR:1000,SYNCHRONIZATION_PERIOD_FACTOR:1000,init:function(){this.dialog=$("#datastoreConfigurationDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["datastoreConfigurationDialog.title"],width:jscape.Resources.intVal("datastoreConfigurationDialog.width"),height:jscape.Resources.intVal("datastoreConfigurationDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.test.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onTest,this)},{text:jscape.Resources["datastoreConfigurationDialog.migrateButton.text"],width:jscape.Resources.intVal("datastoreConfigurationDialog.migrateButton.width"),handler:$.proxy(this._onMigrate,this)},{text:jscape.Resources["button.save.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.jdbcUrlField=$("#jdbcUrlField");this.jdbcUrlField.textbox({required:true,missingMessage:jscape.Resources["datastoreConfigurationDialog.error.emptyJdbcUrl.message"],validType:[requiredFieldRule("requiredJdbcUrl",jscape.Resources["datastoreConfigurationDialog.error.emptyJdbcUrl.message"])]});this.usernameField=$("#usernameField");this.usernameField.textbox({required:true,missingMessage:jscape.Resources["datastoreConfigurationDialog.error.emptyUsername.message"],validType:[requiredFieldRule("requiredUsername",jscape.Resources["datastoreConfigurationDialog.error.emptyUsername.message"])]});this.passwordField=$("#passwordField");this.passwordField.passwordbox({});this.debugFileField=$("#debugFileField");this.debugFileField.textbox({});this.poolSizeField=$("#poolSizeField");this.poolSizeField.numberspinner({min:1,max:1000,value:100,increment:1,required:true,missingMessage:jscape.Resources["datastoreConfigurationDialog.error.emptyPoolSize.message"]});this.poolTimeoutField=$("#poolTimeoutField");this.poolTimeoutField.numberspinner({min:1,max:10000,value:10,increment:1,required:true,missingMessage:jscape.Resources["datastoreConfigurationDialog.error.emptyPoolTimeout.message"]});this.synchronizationBox=$("#synchronizationBox");this.synchronizationBox.click($.proxy(this._synchronizationBoxClicked,this));this.synchronizationPeriodField=$("#synchronizationPeriodField");this.synchronizationPeriodField.numberspinner({min:1,max:10000,value:600,increment:60,required:true,missingMessage:jscape.Resources["datastoreConfigurationDialog.error.emptySynchronizationTime.message"]});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.jdbcUrlField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getJdbcUrl:function(){return this.jdbcUrlField.textbox("getValue").trim();},setJdbcUrl:function(value){this.jdbcUrlField.textbox("setValue",value);this.jdbcUrlField.textbox("validate");},getUsername:function(){return this.usernameField.textbox("getValue").trim();},setUsername:function(value){this.usernameField.textbox("setValue",value);},getPassword:function(){return this.passwordField.passwordbox("getValue");},setPassword:function(value){this.passwordField.passwordbox("setValue",value);},getPoolSize:function(){return parseInt(this.poolSizeField.numberspinner("getValue"),10);},setPoolSize:function(value){this.poolSizeField.numberspinner("setValue",value);},getPoolTimeout:function(){return parseInt(this.poolTimeoutField.numberspinner("getValue"),10)*this.POOL_TIMEOUT_FACTOR;},setPoolTimeout:function(value){this.poolTimeoutField.numberspinner("setValue",value/this.POOL_TIMEOUT_FACTOR);},getSynchronizationPeriod:function(){return this.synchronizationBox.prop("checked")?parseInt(this.synchronizationPeriodField.numberspinner("getValue"),10)*this.SYNCHRONIZATION_PERIOD_FACTOR:null;},setSynchronizationPeriod:function(value){if(value===null||value===undefined){this.synchronizationBox.prop("checked",false);this._synchronizationBoxClicked();}else{this.synchronizationBox.prop("checked",true);this._synchronizationBoxClicked();this.synchronizationPeriodField.numberspinner("setValue",value/this.POOL_TIMEOUT_FACTOR);}},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onTest:function(){if(this.form.form("validate")){this.listener.onTest();}},_onMigrate:function(){if(this.form.form("validate")){this.listener.onMigrate();}},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();},_synchronizationBoxClicked:function(){this.synchronizationPeriodField.numberspinner(this.synchronizationBox.prop("checked")?"enable":"disable");}});