/* Copyright &#169; JSCAPE Corp. 2009-2019. All Rights Reserved */
jscape.ErrorSummary=Class.extend({init:function(httpStatus,httpReason,responseText,serverResponse,status,error){this.httpStatus=httpStatus;this.httpReason=httpReason;this.responseText=responseText;this.serverResponse=serverResponse;this.status=status;this.error=error;}});jscape.WaitCursorDialog=Class.extend({show:function(){document.body.style.cursor="wait";},hide:function(){document.body.style.cursor="default";}});jscape.ProgressDialog=Class.extend({KILOBYTE:{factor:1024,unit:"KB"},MEGABYTE:{factor:1024*1024,unit:"MB"},show:function(){this.messager=$.messager.progress({title:jscape.Resources["uploading.data.title"]||"Uploading Data...",text:"",interval:100});},hide:function(){$.messager.progress("close");},progress:function(data){var bytes=typeof data==="string"?parseInt(data,10):typeof data==="number"?data:null;if(bytes){var measurement=this._measurementFor(bytes);var value=(bytes/measurement.factor).toFixed(2)+" "+measurement.unit;this.messager.find(".messager-p-msg").html(jscape.Resources["uploaded.bytes.message"].supplant({value:value}));}},_measurementFor:function(value){if(0<=value&&value<this.KILOBYTE.factor){return this.KILOBYTE;}
if(this.KILOBYTE.factor<=value&&value<this.MEGABYTE.factor){return this.KILOBYTE;}
return this.MEGABYTE;}});jscape.ErrorDialog=Class.extend({DEFAULT_WIDTH:450,DEFAULT_HEIGHT:170,DEFAULT_MAX_HEIGHT:450,BODY_TEMPLATE:"<div class='messager-body'><div class='messager-icon messager-error'></div><div>{message}</div><div class='messager-details' style='display:none'>{details}</div></div>",HTTP_TEMPLATE:"<p><strong>{title}</strong>&nbsp;{httpReason} ({httpStatus})</p>",SERVER_TEMPLATE:"<p><strong>{title}</strong>&nbsp;{serverMessage} ({serverCode})</p><p>{serverDetails}</p>",RAW_TEMPLATE:"<p>{responseText}</p>",init:function(){var div=$(document.createElement("div"));this.dialog=div.dialog({title:jscape.Resources["error.title"]||"Error",width:this.DEFAULT_WIDTH,height:this.DEFAULT_HEIGHT,modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["error.button.details.text"]||"Details",width:jscape.Resources.buttonSize(),handler:$.proxy(this._toggleDetails,this)},{text:jscape.Resources["button.close.text"]||"Close",width:jscape.Resources.buttonSize(),handler:$.proxy(this._hide,this)}],onClose:$.proxy(this._onClose,this),closed:true});},show:function(error,callback){this.error=error;this.callback=callback;var message=error.serverResponse?jscape.Resources["error.rest."+error.serverResponse.code].supplant(error.serverResponse.description?error.serverResponse:{description:""})||jscape.Resources["error.rest.general"]||"Server error!":error.httpReason||error.responseText;var httpDetails=error.httpReason?this.HTTP_TEMPLATE.supplant({title:jscape.Resources["error.http.title"]||"HTTP response:",httpReason:error.httpReason,httpStatus:error.httpStatus}):"";var serverDetails=error.serverResponse?this.SERVER_TEMPLATE.supplant({title:jscape.Resources["error.server.title"]||"Server response:",serverCode:error.serverResponse.code,serverMessage:error.serverResponse.description||jscape.Resources["error.rest.general"]||"Internal server error!",serverDetails:error.serverResponse.details}):this.RAW_TEMPLATE.supplant({responseText:error.responseText||""});var details=httpDetails+serverDetails;var content=this.BODY_TEMPLATE.supplant({message:message,details:details});this.dialog.dialog({content:content});this.dialog.dialog("resize",{width:this.DEFAULT_WIDTH,height:this.DEFAULT_HEIGHT});this.dialog.dialog("center");this.dialog.dialog("open");},_hide:function(){if(!this._closed()){this.dialog.dialog("close");}},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_toggleDetails:function(){var details=this.dialog.dialog("body").find(".messager-details");details.toggle();this.dialog.dialog("resize",{width:this.DEFAULT_WIDTH,height:details.is(":visible")?this.DEFAULT_MAX_HEIGHT:this.DEFAULT_HEIGHT});this.dialog.dialog("center");},_onClose:function(){if(this.callback){this.callback();}}});jscape.ApiClient={WAITING_DIALOG:new jscape.WaitCursorDialog(),PROGRESS_DIALOG:new jscape.ProgressDialog(),ERROR_DIALOG:new jscape.ErrorDialog(),TIMEOUT:600000,CONTENT_TYPE:"application/json",DATA_TYPE:"text",LOGIN_URI:null,CSRF_TOKEN:null,login:function(credentials,successCallback){this.start("POST","/api/login",credentials,successCallback,$.proxy(function(){this.CSRF_TOKEN=null;},this));},logout:function(successCallback){this.start("POST","/api/logout",null,successCallback);},assertLoggedIn:function(successCallback){this.start("POST","/api/login/test",null,successCallback);},startPasswordChanging:function(username,successCallback){this.start("POST","/api/password-changing/start",username,$.proxy(function(){this.CSRF_TOKEN=null;successCallback();},this),$.proxy(function(){this.CSRF_TOKEN=null;},this));},finishPasswordChanging:function(newPasswordData,successCallback){this.start("POST","/api/password-changing/finish",newPasswordData,$.proxy(function(){this.CSRF_TOKEN=null;successCallback();},this));},serverParameters:function(successCallback,showError){this.start("GET","/api/server/parameters",null,successCallback,null,function(){return showError;});},serverAddresses:function(successCallback){this.start("GET","/api/server/parameters/addresses",null,successCallback);},serverStatistics:function(successCallback,showError){this.start("GET","/api/server/statistics",null,successCallback,null,function(){return showError;});},importLicense:function(form,successCallback){this.submitForm("/api/license",form,successCallback);},proxyServices:function(successCallback,showError){this.start("GET","/api/proxies",null,successCallback,null,function(){return showError;});},proxyServiceFor:function(id,successCallback,errorCallback){this.start("GET","/api/proxy?id={id}".supplant({id:encodeURIComponent(id)}),null,successCallback,errorCallback);},addProxyService:function(data,successCallback){this.start("PUT","/api/proxy",data,successCallback);},updateProxyService:function(data,successCallback){this.start("POST","/api/proxy",data,successCallback);},startProxyService:function(id,successCallback,errorCallback){this.start("POST","/api/proxy/start?id={id}".supplant({id:encodeURIComponent(id)}),null,successCallback,errorCallback);},stopProxyService:function(id,successCallback,errorCallback){this.start("POST","/api/proxy/stop?id={id}".supplant({id:encodeURIComponent(id)}),null,successCallback,errorCallback);},removeProxyService:function(id,successCallback,errorCallback){this.start("DELETE","/api/proxy?id={id}".supplant({id:encodeURIComponent(id)}),null,successCallback,errorCallback);},clearHttpProxyServiceCache:function(id,successCallback){this.start("POST","/api/proxy/http/cache/clear?id={id}".supplant({id:encodeURIComponent(id)}),null,successCallback);},proxySessions:function(successCallback,showError){this.start("GET","/api/proxy/sessions",null,successCallback,null,function(){return showError;});},closeProxySession:function(sessionId,successCallback,errorCallback){this.start("POST","/api/proxy/session/close?id={sessionId}".supplant({sessionId:encodeURIComponent(sessionId)}),null,successCallback,errorCallback);},clusters:function(successCallback){this.start("GET","/api/clusters",null,successCallback);},clustersFor:function(request,successCallback){this.start("POST","/api/clusters",request,successCallback);},clusterFor:function(name,successCallback){this.start("GET","/api/cluster?name={name}".supplant({name:encodeURIComponent(name)}),null,successCallback);},addCluster:function(data,successCallback){this.start("PUT","/api/cluster",data,successCallback);},updateCluster:function(data,successCallback){this.start("POST","/api/cluster",data,successCallback);},removeCluster:function(name,successCallback,errorCallback){this.start("DELETE","/api/cluster?name={name}".supplant({name:encodeURIComponent(name)}),null,successCallback,errorCallback);},ipAccessConfiguration:function(successCallback){this.start("GET","/api/service/ip-access/configuration",null,successCallback);},updateIpAccessConfiguration:function(configuration,successCallback){this.start("POST","/api/service/ip-access/configuration",configuration,successCallback);},logServiceConfiguration:function(successCallback){this.start("GET","/api/service/log/configuration",null,successCallback);},updateLogServiceConfiguration:function(configuration,successCallback){this.start("POST","/api/service/log/configuration",configuration,successCallback);},testLogServiceConfiguration:function(configuration,successCallback){this.start("POST","/api/service/log/configuration/test",configuration,successCallback);},initLogServiceRepository:function(configuration,successCallback){this.start("POST","/api/service/log/repository/init",configuration,successCallback);},latestLogRecords:function(count,successCallback,showError){this.start("GET","/api/log?count={count}".supplant({count:count}),null,successCallback,null,function(){return showError;});},monitorServiceConfiguration:function(successCallback){this.start("GET","/api/service/monitor/configuration",null,successCallback);},updateMonitorServiceConfiguration:function(configuration,successCallback,errorCallback,showErrorCallback){this.start("POST","/api/service/monitor/configuration",configuration,successCallback,errorCallback,showErrorCallback);},administratorsFor:function(request,successCallback){this.start("POST","/api/administrators",request,successCallback);},administratorFor:function(username,successCallback){this.start("GET","/api/administrator?username={username}".supplant({username:encodeURIComponent(username)}),null,successCallback);},addAdministrator:function(data,successCallback){this.start("PUT","/api/administrator",data,successCallback);},updateAdministrator:function(data,successCallback){this.start("POST","/api/administrator",data,successCallback);},removeAdministrator:function(username,successCallback,errorCallback){this.start("DELETE","/api/administrator?username={username}".supplant({username:encodeURIComponent(username)}),null,successCallback,errorCallback);},agentsFor:function(request,successCallback){this.start("POST","/api/agents",request,successCallback);},agentFor:function(username,successCallback){this.start("GET","/api/agent?username={username}".supplant({username:encodeURIComponent(username)}),null,successCallback);},addAgent:function(data,successCallback){this.start("PUT","/api/agent",data,successCallback);},updateAgent:function(data,successCallback){this.start("POST","/api/agent",data,successCallback);},removeAgent:function(username,successCallback,errorCallback){this.start("DELETE","/api/agent?username={username}".supplant({username:encodeURIComponent(username)}),null,successCallback,errorCallback);},updateAgentInstaller:function(sessionId,successCallback,errorCallback){this.startLong("POST","/api/agent/installer/update?id={sessionId}".supplant({sessionId:encodeURIComponent(sessionId)}),null,successCallback,errorCallback);},startAgentInstaller:function(sessionId,successCallback,errorCallback){this.start("POST","/api/agent/installer/start?id={sessionId}".supplant({sessionId:encodeURIComponent(sessionId)}),null,successCallback,errorCallback);},serverKeysFor:function(request,successCallback){this.start("POST","/api/keys/server",request,successCallback);},serverKeyNames:function(successCallback){this.start("GET","/api/keys/server/names",null,successCallback);},generateServerKey:function(data,successCallback){this.start("POST","/api/key/server/generate",data,successCallback);},importServerKey:function(form,successCallback){this.submitForm("/api/key/server",form,successCallback);},importServerCertificate:function(name,form,successCallback){this.submitForm("/api/key/server/certificate?name={name}".supplant({name:encodeURIComponent(name)}),form,successCallback);},generateServerCertificate:function(name,data,successCallback){this.start("POST","/api/key/server/certificate/generate?name={name}".supplant({name:encodeURIComponent(name)}),data,successCallback);},serverKeyFor:function(name,format,password){window.open("/api/key/server/{name}.key?format={format}&password={password}".supplant({name:encodeURIComponent(name),format:encodeURIComponent(format),password:encodeURIComponent(password)}),"_blank");},serverCertificateFor:function(name,format){window.open("/api/key/server/certificate/{name}.cer?format={format}".supplant({name:encodeURIComponent(name),format:encodeURIComponent(format)}),"_blank");},serverPublicKeyFor:function(name,format){window.open("/api/key/server/public-key/{name}.pub?format={format}".supplant({name:encodeURIComponent(name),format:encodeURIComponent(format)}),"_blank");},serverKeyCsrFor:function(name){window.open("/api/key/server/csr/{name}.csr".supplant({name:encodeURIComponent(name)}),"_blank");},removeServerKey:function(name,successCallback,errorCallback){this.start("DELETE","/api/key/server?name={name}".supplant({name:encodeURIComponent(name)}),null,successCallback,errorCallback);},emailServiceConfiguration:function(successCallback){this.start("GET","/api/service/email/configuration",null,successCallback);},updateEmailServiceConfiguration:function(configuration,successCallback){this.start("POST","/api/service/email/configuration",configuration,successCallback);},testEmailServiceConfiguration:function(configuration,recipient,successCallback){this.start("POST","/api/service/email/configuration/test?recipient={recipient}".supplant({recipient:encodeURIComponent(recipient)}),configuration,successCallback);},webServiceConfiguration:function(successCallback){this.start("GET","/api/service/web/configuration",null,successCallback);},webServiceConfigurationFor:function(configuration,successCallback){this.start("POST","/api/service/web/configuration/database",configuration,successCallback);},updateWebServiceConfiguration:function(configuration,successCallback,errorCallback,showErrorCallback){this.start("POST","/api/service/web/configuration",configuration,successCallback,errorCallback,showErrorCallback);},agentServiceConfiguration:function(successCallback){this.start("GET","/api/service/agent/configuration",null,successCallback);},updateAgentConnectorFactoryConfiguration:function(configuration,successCallback,errorCallback,showErrorCallback){this.start("POST","/api/service/agent/configuration",configuration,successCallback,errorCallback,showErrorCallback);},agentSessions:function(successCallback,showError){this.start("GET","/api/agent/sessions",null,successCallback,null,function(){return showError;});},closeAgentSession:function(sessionId,successCallback,errorCallback){this.start("POST","/api/agent/session/close?id={sessionId}".supplant({sessionId:encodeURIComponent(sessionId)}),null,successCallback,errorCallback);},databaseConfiguration:function(successCallback){this.start("GET","/api/database/configuration",null,successCallback);},updateDatabaseConfiguration:function(configuration,successCallback){this.start("POST","/api/database/configuration",configuration,successCallback);},testDatabaseConfiguration:function(configuration,successCallback){this.start("POST","/api/database/configuration/test",configuration,successCallback);},migrateData:function(configuration,successCallback){this.startLong("POST","/api/database/migrate",configuration,successCallback);},listLogDirectory:function(path,successCallback){if(path){this.start("GET","/api/files/log?path={path}".supplant({path:encodeURIComponent(path)}),null,successCallback);}else{this.start("GET","/api/files/log",null,successCallback);}},createLogDirectory:function(path,name,successCallback){this.start("PUT","/api/files/log?path={path}&name={name}".supplant({path:encodeURIComponent(path),name:encodeURIComponent(name)}),null,successCallback);},listCacheDirectory:function(path,successCallback){if(path){this.start("GET","/api/files/cache?path={path}".supplant({path:encodeURIComponent(path)}),null,successCallback);}else{this.start("GET","/api/files/cache",null,successCallback);}},createCacheDirectory:function(path,name,successCallback){this.start("PUT","/api/files/cache?path={path}&name={name}".supplant({path:encodeURIComponent(path),name:encodeURIComponent(name)}),null,successCallback);},start:function(method,url,data,successCallback,errorCallback,showErrorCallback){var request=function(){var requestData=data?typeof data!=="string"&&typeof data!=="number"?JSON.stringify(data):data:"";this._showWaitingDialog();var csrfToken=this.CSRF_TOKEN;return $.ajax({type:method,url:url,cache:false,timeout:this.TIMEOUT,contentType:this.CONTENT_TYPE,data:requestData,processData:false,dataType:this.DATA_TYPE,beforeSend:function(jqXhr){jqXhr.setRequestHeader("X-CSRF-Token",csrfToken);},success:$.proxy(function(data,textStatus,request){this._onSuccess(data,textStatus,request,successCallback,errorCallback,showErrorCallback);},this),error:$.proxy(function(request,status,error){this._onError(request,status,error,errorCallback,showErrorCallback);},this)});};if(this.CSRF_TOKEN){return request.apply(this);}else{this._initCsrf().done($.proxy(request,this));}},startLong:function(method,url,data,successCallback,errorCallback,showErrorCallback){var request=function(){var requestData=data?typeof data!=="string"&&typeof data!=="number"?JSON.stringify(data):data:"";this._showWaitingDialog();var csrfToken=this.CSRF_TOKEN;return $.ajax({type:method,url:url,cache:false,timeout:this.TIMEOUT,contentType:this.CONTENT_TYPE,data:requestData,processData:false,dataType:this.DATA_TYPE,beforeSend:function(jqXhr){jqXhr.setRequestHeader("X-CSRF-Token",csrfToken);},success:$.proxy(function(data,textStatus,request){this._hideWaitingDialog();this._showProgressDialog();this._scheduleSubmitStateUpdate("/api/submit/state",successCallback,errorCallback,showErrorCallback);},this),error:$.proxy(function(request,status,error){this._onError(request,status,error,errorCallback,showErrorCallback);},this)});};if(this.CSRF_TOKEN){return request.apply(this);}else{this._initCsrf().done($.proxy(request,this));}},submitForm:function(url,form,successCallback,errorCallback,showErrorCallback){var request=function(){this._showProgressDialog();this._scheduleSubmitStateUpdate("/api/submit/state",successCallback,errorCallback,showErrorCallback);form.append("<input id='csrf' type='hidden' name='X-CSRF-Token' value='{csrfToken}'/>".supplant({csrfToken:this.CSRF_TOKEN}));form.form("submit",{url:url});$("#csrf").remove();};if(this.CSRF_TOKEN){return request.apply(this);}else{this._initCsrf().done($.proxy(request,this));}},_initCsrf:function(){return $.ajax({type:"GET",url:"/api/csrf-token",cache:false,timeout:this.TIMEOUT,contentType:this.CONTENT_TYPE,processData:false,dataType:this.DATA_TYPE,success:$.proxy(function(data,textStatus,request){this._onSuccess(data,textStatus,request,$.proxy(function(value){this.CSRF_TOKEN=value},this));},this),error:$.proxy(function(request,status,error){this._onError(request,status,error);},this)});},_showWaitingDialog:function(){if(this.WAITING_DIALOG&&typeof this.WAITING_DIALOG.show==="function"){this.WAITING_DIALOG.show();}},_hideWaitingDialog:function(){if(this.WAITING_DIALOG&&typeof this.WAITING_DIALOG.hide==="function"){this.WAITING_DIALOG.hide();}},_showProgressDialog:function(){if(this.PROGRESS_DIALOG&&typeof this.PROGRESS_DIALOG.show==="function"){this.PROGRESS_DIALOG.show();}},_hideProgressDialog:function(){if(this.PROGRESS_DIALOG&&typeof this.PROGRESS_DIALOG.hide==="function"){this.PROGRESS_DIALOG.hide();}},_updateProgressDialog:function(value){if(this.PROGRESS_DIALOG&&typeof this.PROGRESS_DIALOG.progress==="function"){this.PROGRESS_DIALOG.progress(value);}},_scheduleSubmitStateUpdate:function(url,successCallback,errorCallback,showErrorCallback){this.submitStateTimer=setInterval($.proxy(function(){this._updateSubmitState(url,successCallback,errorCallback,showErrorCallback);},this),300);},_cancelSubmitStateUpdate:function(){if(this.submitStateTimer){clearInterval(this.submitStateTimer);this.submitStateTimer=null;}},_updateSubmitState:function(url,successCallback,errorCallback,showErrorCallback){var csrfToken=this.CSRF_TOKEN;$.ajax({type:"GET",url:url,cache:false,timeout:this.TIMEOUT,contentType:this.CONTENT_TYPE,data:"",processData:false,dataType:this.DATA_TYPE,beforeSend:function(jqXhr){jqXhr.setRequestHeader("X-CSRF-Token",csrfToken);},success:$.proxy(function(data,textStatus,request){this._onSubmitStateUpdated(data,textStatus,request,successCallback,errorCallback,showErrorCallback);},this),error:$.proxy(function(request,status,error){this._onSubmitStateError(request,status,error,errorCallback,showErrorCallback);},this)});},_showErrorDialog:function(error,errorCallback,showErrorCallback){var showDialog=typeof showErrorCallback!=="function"||showErrorCallback(error);var callback=$.proxy(function(){if(errorCallback){errorCallback(error);}
if(error&&error.serverResponse&&error.serverResponse.code==="NOT_AUTHENTICATED"&&this.LOGIN_URI){window.location=this.LOGIN_URI;}},this);if(showDialog&&this.ERROR_DIALOG&&typeof this.WAITING_DIALOG.show==="function"){this.ERROR_DIALOG.show(error,callback);}else{callback();}},_onSuccess:function(data,status,request,successCallback,errorCallback,showErrorCallback){this._hideWaitingDialog();if(request.status!==0){var result=this._parseResponse(data);successCallback(result||data);}else{var errorData=new jscape.ErrorSummary("0",jscape.Resources["error.connection.text"]||"Connection error","",null,status,null);this._showErrorDialog(errorData,errorCallback,showErrorCallback);}},_onError:function(request,status,error,errorCallback,showErrorCallback){this._hideWaitingDialog();var errorData=this._errorFor(request,status,error);this._showErrorDialog(errorData,errorCallback,showErrorCallback);},_onSubmitStateUpdated:function(data,status,request,successCallback,errorCallback,showErrorCallback){if(request.status!==0){var state=this._parseResponse(data);if(state.status==="IN_PROGRESS"){this._updateProgressDialog(state.data);}else if(state.status==="DONE"){this._hideProgressDialog();this._cancelSubmitStateUpdate();successCallback(state.data);}}else{this._hideProgressDialog();this._cancelSubmitStateUpdate();var errorData=new jscape.ErrorSummary("0",jscape.Resources["error.connection.text"]||"Connection error","",null,status,null);this._showErrorDialog(errorData,errorCallback,showErrorCallback);}},_onSubmitStateError:function(request,status,error,errorCallback,showErrorCallback){this._hideProgressDialog();this._cancelSubmitStateUpdate();var errorData=this._errorFor(request,status,error);this._showErrorDialog(errorData,errorCallback,showErrorCallback);},_onSubmitResult:function(data,successCallback,errorCallback,showErrorCallback){this._cancelSubmitStateUpdate();this._hideProgressDialog();if(!data){this._showErrorDialog(new jscape.ErrorSummary(0,"Connection error.",null,null,null,null),errorCallback,showErrorCallback);return;}
var result=this._parseResponse(data);if(this._isError(result)){this._showErrorDialog(new jscape.ErrorSummary(500,"Server error.",data,result,null,null),errorCallback,showErrorCallback);}else{successCallback(result||data);}},_errorFor:function(request,status,error){var serverResponse=this._parseResponse(request.responseText);return new jscape.ErrorSummary(request.status,request.statusText,request.responseText,serverResponse,status,error);},_parseResponse:function(data){try{return data?$.parseJSON(data):null;}catch(e){return null;}},_isError:function(result){return result&&result.hasOwnProperty("code")&&result.hasOwnProperty("message")&&result.hasOwnProperty("details");}};