/* Copyright &#169; JSCAPE Corp. 2009-2019. All Rights Reserved */
jscape.AdministratorsController=Class.extend({init:function(page,addAdministratorController,editAdministratorController,deleteAdministratorController){this.page=page;this.addAdministratorController=addAdministratorController;this.editAdministratorController=editAdministratorController;this.deleteAdministratorController=deleteAdministratorController;},start:function(){this.page.show(this);},onReload:function(request,successCallback){jscape.ApiClient.administratorsFor(request,function(page){successCallback({total:page.totalRecords,rows:page.records});});},onCreateAdministrator:function(){this.addAdministratorController.start($.proxy(function(){this.page.reload();},this));},onEditAdministrator:function(summary){this.editAdministratorController.start(summary,$.proxy(function(){this.page.reload();},this));},onDeleteAdministrators:function(summaries){this.deleteAdministratorController.start(summaries,$.proxy(function(){this.page.reload();},this));}});jscape.AdministratorsPage=Class.extend({init:function(){this.infoPanel=$("#infoPanel");this.infoPanel.tabs({border:true,plain:true});this.administratorsTable=$("#administratorsTable");this.administratorsTable.datagrid({fitColumns:true,pagination:true,search:true,remoteSearch:true,remoteSort:true,sortName:"name",sortOrder:"asc",singleSelect:false,ctrlSelect:true,columns:[[{field:"name",title:jscape.Resources["administratorsPage.administratorsTable.column.0"],width:40,halign:"left",align:"left",sortable:true,searchable:true},{field:"username",title:jscape.Resources["administratorsPage.administratorsTable.column.1"],width:40,halign:"left",align:"left",sortable:true,searchable:true},{field:"email",title:jscape.Resources["administratorsPage.administratorsTable.column.2"],width:40,halign:"left",align:"left",sortable:true,searchable:true},{field:"managementAllowed",title:jscape.Resources["administratorsPage.administratorsTable.column.3"],width:30,halign:"left",align:"left",sortable:true,searchable:true,formatter:function(value,row){return row.managementAllowed?jscape.Resources["administrator.permission.manage"]:"";},finder:{type:"combobox",options:{panelHeight:"auto",data:[{text:jscape.Resources["administrator.permission.manage"],value:1},{text:jscape.Resources["administrator.permission.none"],value:0}]}}},{field:"enabled",title:jscape.Resources["administratorsPage.administratorsTable.column.4"],width:10,halign:"center",align:"center",sortable:true,searchable:true,formatter:function(value){return"<input type='checkbox' {checked} disabled='disabled'/>".supplant({checked:value?" checked='checked'":""});},finder:{type:"combobox",options:{panelHeight:"auto",data:[{text:jscape.Resources["true"],value:1},{text:jscape.Resources["false"],value:0}]}}}]],onSelect:$.proxy(this._rowSelected,this),onUnselect:$.proxy(this._rowUnselected,this),loader:$.proxy(function(params,success){this.listener.onReload(asPageRequest(params),success);},this),onLoadSuccess:$.proxy(this._dataLoaded,this),onBeforeLoad:$.proxy(function(){return!!this.listener;},this),onDblClickRow:$.proxy(function(){this.listener.onEditAdministrator(this.rowValue);},this)});this.addAdministratorButton=$("#addAdministratorButton");this.addAdministratorButton.linkbutton({width:jscape.Resources.buttonSize()});this.addAdministratorButton.click($.proxy(function(){this.listener.onCreateAdministrator();},this));this.editAdministratorButton=$("#editAdministratorButton");this.editAdministratorButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.editAdministratorButton.click($.proxy(function(){if(!this.editAdministratorButton.linkbutton("options").disabled){this.listener.onEditAdministrator(this.rowValue);}},this));this.deleteAdministratorButton=$("#deleteAdministratorButton");this.deleteAdministratorButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.deleteAdministratorButton.click($.proxy(this._delete,this));},show:function(listener){this.listener=listener;this.infoPanel.css("visibility","visible");this.administratorsTable.datagrid("reload");},reload:function(){this.administratorsTable.datagrid("reload");},_rowSelected:function(row,value){this.row=row;this.rowValue=value;this.editAdministratorButton.linkbutton("enable");this.deleteAdministratorButton.linkbutton("enable");},_rowUnselected:function(){if(this.administratorsTable.datagrid("getSelections").length===0){this._resetButtons();}},_dataLoaded:function(data){this._resetButtons();if(data.rows.length!==0){this._restoreSelection();}else if(data.total>0){var pageNumber=this.administratorsTable.datagrid("options").pageNumber;if(pageNumber>1){this.administratorsTable.datagrid("gotoPage",pageNumber-1);}}},_delete:function(){var values=this.administratorsTable.datagrid("getSelections");if(values.length>0){this.listener.onDeleteAdministrators(values);}},_resetButtons:function(){this.editAdministratorButton.linkbutton("disable");this.deleteAdministratorButton.linkbutton("disable");},_restoreSelection:function(){if(this.row>=0){this.administratorsTable.datagrid("selectRow",this.row);}}});jscape.AddAdministratorController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(callback){this.callback=callback;this.dialog.reset();this.dialog.show(this);},onSubmit:function(){var administrator={name:this.dialog.getName(),username:this.dialog.getLogin(),password:this.dialog.getPassword(),email:this.dialog.getEmail(),managementAllowed:this.dialog.isManagementAllowed(),enabled:this.dialog.isEnabled()};jscape.ApiClient.addAdministrator(administrator,$.proxy(this._administratorCreated,this));},onCancel:function(){this.dialog.hide();},_administratorCreated:function(summary){this.dialog.hide();showMessage(jscape.Resources["administratorCreatedDialog.message"].supplant(summary));this.callback();}});jscape.AddAdministratorDialog=Class.extend({init:function(){this.dialog=$("#addAdministratorDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["addAdministratorDialog.title"],width:jscape.Resources.intVal("addAdministratorDialog.width"),height:jscape.Resources.intVal("addAdministratorDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.add.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.nameField=$("#addAdministratorNameField");this.nameField.textbox({required:false,validType:[validationRule("addAdministratorNameFieldValid",function(value){return new XRegExp("^[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.,\\(\\)/&']+[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.,\\(\\)/&' ]*[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.,\\(\\)/&']+$").test(value);},jscape.Resources["addAdministratorDialog.error.validName.message"])]});this.loginField=$("#addAdministratorLoginField");this.loginField.textbox({required:true,missingMessage:jscape.Resources["addAdministratorDialog.error.validLogin.message"],validType:[requiredFieldRule("addAdministratorLoginFieldEmpty",jscape.Resources["addAdministratorDialog.error.validLogin.message"]),validationRule("addAdministratorLoginFieldValid",function(value){return new XRegExp("^[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']+[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']*[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']+$").test(value);},jscape.Resources["addAdministratorDialog.error.validLogin.message"])]});this.passwordField=$("#addAdministratorPasswordField");this.passwordField.passwordbox({required:true,missingMessage:jscape.Resources["addAdministratorDialog.error.emptyPassword.message"],validType:[requiredFieldRule("requiredPassword",jscape.Resources["addAdministratorDialog.error.emptyPassword.message"])]});this.passwordConfirmationField=$("#addAdministratorPasswordConfirmationField");this.passwordConfirmationField.passwordbox({required:true,missingMessage:jscape.Resources["addAdministratorDialog.error.emptyPasswordConfirmation.message"],validType:[requiredFieldRule("requiredPasswordConfirmation",jscape.Resources["addAdministratorDialog.error.emptyPasswordConfirmation.message"]),validationRule("samePasswords",$.proxy(function(){return this.passwordField.val()===this.passwordConfirmationField.val();},this),jscape.Resources["addAdministratorDialog.error.nonEqualPasswords.message"])]});this.emailField=$("#addAdministratorEmailField");this.emailField.textbox({required:true,missingMessage:jscape.Resources["addAdministratorDialog.error.emptyEmail.message"],validType:"email"});this.managementAllowedBox=$("#addManagementAllowedBox");this.enabledBox=$("#addAdministratorEnabledBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.enabledBox.prop("checked",true);this.nameField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getName:function(){return this.nameField.textbox("getValue").trim();},getLogin:function(){return this.loginField.textbox("getValue").trim();},getPassword:function(){return this.passwordField.passwordbox("getValue");},getEmail:function(){return this.emailField.textbox("getValue").trim();},isManagementAllowed:function(){return this.managementAllowedBox.prop("checked");},isEnabled:function(){return this.enabledBox.prop("checked");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.EditAdministratorController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(summary,callback){this.data=summary;this.callback=callback;jscape.ApiClient.administratorFor(this.data.username,$.proxy(this._administratorLoaded,this));},onSubmit:function(){var administrator={name:this.dialog.getName(),username:this.data.username,password:this.dialog.getPassword(),email:this.dialog.getEmail(),managementAllowed:this.dialog.isManagementAllowed(),enabled:this.dialog.isEnabled(),version:this.data.version};jscape.ApiClient.updateAdministrator(administrator,$.proxy(this._administratorUpdated,this));},onCancel:function(){this.dialog.hide();},_administratorLoaded:function(data){this.data=data;this.dialog.reset();this.dialog.setName(this.data.name);this.dialog.setLogin(this.data.username);this.dialog.setEmail(this.data.email);this.dialog.setManagementAllowed(this.data.managementAllowed);this.dialog.setEnabled(this.data.enabled);this.dialog.show(this);},_administratorUpdated:function(summary){this.dialog.hide();showMessage(jscape.Resources["administratorUpdatedDialog.message"].supplant(summary));this.callback();}});jscape.EditAdministratorDialog=Class.extend({init:function(){this.dialog=$("#editAdministratorDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["editAdministratorDialog.title"],width:jscape.Resources.intVal("editAdministratorDialog.width"),height:jscape.Resources.intVal("editAdministratorDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.save.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.nameField=$("#editAdministratorNameField");this.nameField.textbox({required:false,validType:[validationRule("editAdministratorNameFieldValid",function(value){return new XRegExp("^[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.,\\(\\)/&']+[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.,\\(\\)/&' ]*[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.,\\(\\)/&']+$").test(value);},jscape.Resources["editAdministratorDialog.error.validName.message"])]});this.passwordField=$("#editAdministratorPasswordField");this.passwordField.passwordbox({});this.passwordConfirmationField=$("#editAdministratorPasswordConfirmationField");this.passwordConfirmationField.passwordbox({validType:[validationRule("sameEditUserPasswords",$.proxy(function(){return this.passwordField.val()===this.passwordConfirmationField.val();},this),jscape.Resources["editAdministratorDialog.error.nonEqualPasswords.message"])]});this.emailField=$("#editAdministratorEmailField");this.emailField.textbox({required:true,missingMessage:jscape.Resources["editAdministratorDialog.error.emptyEmail.message"],validType:"email"});this.managementAllowedBox=$("#editManagementAllowedBox");this.enabledBox=$("#editAdministratorEnabledBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.nameField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getName:function(){return this.nameField.textbox("getValue").trim();},setName:function(value){this.nameField.textbox("setValue",value);},setLogin:function(value){this.dialog.dialog("setTitle",jscape.Resources["editAdministratorDialog.title"].supplant({username:value}));},getPassword:function(){return this.passwordField.passwordbox("getValue");},getEmail:function(){return this.emailField.textbox("getValue");},setEmail:function(value){this.emailField.textbox("setValue",value);this.emailField.textbox("validate");},isManagementAllowed:function(){return this.managementAllowedBox.prop("checked");},setManagementAllowed:function(value){this.managementAllowedBox.prop("checked",value);},isEnabled:function(){return this.enabledBox.prop("checked");},setEnabled:function(value){this.enabledBox.prop("checked",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.DeleteAdministratorController=Class.extend({start:function(values,callback){this.values=values;this.callback=callback;this._showConfirmation();},_showConfirmation:function(){$.messager.confirm(jscape.Resources["deleteAdministratorDialog.title"],this.values.length===1?jscape.Resources["deleteAdministratorDialog.message"].supplant(this.values[0]):jscape.Resources["deleteAdministratorDialog.message.selected"],$.proxy(function(confirmed){if(confirmed){this._confirmed();}},this));},_confirmed:function(){this.valueIndex=0;this._operation();},_operation:function(){if(this.valueIndex<this.values.length){jscape.ApiClient.removeAdministrator(this.values[this.valueIndex++].username,$.proxy(this._operation,this));}else{this._operationCompleted();}},_operationCompleted:function(){showMessage(this.values.length===1?jscape.Resources["administratorDeletedDialog.message"].supplant(this.values[0]):jscape.Resources["administratorDeletedDialog.message.selected"].supplant({count:this.valueIndex===this.values.length?this.valueIndex:this.valueIndex-1}));this.callback();}});