CREATE TABLE proxy (
  id      VARCHAR(256)   NOT NULL,
  version VARCHAR(256)   NOT NULL,
  data    VARBINARY(MAX) NOT NULL,
  PRIMARY KEY (id)
);


CREATE TABLE proxy_cluster (
  name               VARCHAR(256)   NOT NULL,
  protocol           VARCHAR(256)   NOT NULL,
  balancingAlgorithm VARCHAR(256)   NOT NULL,
  version            VARCHAR(256)   NOT NULL,
  data               VARBINARY(MAX) NOT NULL,
  PRIMARY KEY (name)
);


CREATE TABLE administrator (
  name              VARCHAR(256) NOT NULL,
  username          VARCHAR(256) NOT NULL,
  passwordHash      VARCHAR(256) NOT NULL,
  email             VARCHAR(256) NOT NULL,
  managementAllowed INTEGER      NOT NULL,
  enabled           INTEGER      NOT NULL,
  lastLoginDate     BIGINT,
  version           VARCHAR(256) NOT NULL,
  PRIMARY KEY (username)
);


CREATE TABLE server_key (
  name                    VARCHAR(256)   NOT NULL,
  keyAlgorithm            VARCHAR(50)    NOT NULL,
  keySize                 INTEGER        NOT NULL,
  certificateSerialNumber VARCHAR(1024),
  certificateBeginDate    BIGINT         NOT NULL,
  certificateEndDate      BIGINT         NOT NULL,
  certificateIssuer       VARCHAR(1024),
  certificateSubject      VARCHAR(1024),
  keyData                 VARBINARY(MAX) NOT NULL,
  certificateData         VARBINARY(MAX) NOT NULL,
  PRIMARY KEY (name)
);


CREATE TABLE agent (
  username     VARCHAR(256) NOT NULL,
  passwordHash VARCHAR(256) NOT NULL,
  enabled      INTEGER      NOT NULL,
  version      VARCHAR(256) NOT NULL,
  PRIMARY KEY (username)
);


CREATE TABLE configuration (
  name    VARCHAR(256)   NOT NULL,
  version VARCHAR(256)   NOT NULL,
  data    VARBINARY(MAX) NOT NULL,
  PRIMARY KEY (name)
);
