import com.jscape.inet.gateway.operation.authentication.credentials.PasswordCredentials;
import com.jscape.inet.gateway.operation.cluster.ClusterData;
import com.jscape.inet.gateway.port.web.WebApiClient;
import com.jscape.util.Time;
import com.jscape.util.net.TransportAddress;
import com.jscape.util.net.ssl.NullHostnameVerifier;
import com.jscape.util.net.ssl.SslContextFactory;

import javax.net.ssl.SSLSocketFactory;
import java.io.Console;
import java.util.UUID;
import java.util.logging.Logger;

/**
 * @author Alex Usun
 */
public class GetCluster {
    
    public static void main(String[] args)
            throws Exception {
        Console console = System.console();
        String host = console.readLine("Gateway host:");
        int port = Integer.parseInt(console.readLine("Gateway port:"));
        String username = console.readLine("Username:");
        String password = new String(console.readPassword("Password:"));
        String clusterName = console.readLine("Cluster name:");
        
        TransportAddress transportAddress = new TransportAddress(host, port);
        Time connectionTimeout = Time.seconds(30);
        SSLSocketFactory sslSocketFactory = SslContextFactory.defaultContext().getSocketFactory();
        NullHostnameVerifier hostnameVerifier = new NullHostnameVerifier();
        Logger logger = Logger.getLogger(UUID.randomUUID().toString());
        
        try (WebApiClient client = new WebApiClient(WebApiClient.Protocol.HTTP, transportAddress, connectionTimeout, sslSocketFactory, hostnameVerifier, logger)) {
            PasswordCredentials credentials = new PasswordCredentials(username, password);
            client.login(credentials);
    
            ClusterData clusterData = client.clusterFor(clusterName);
            
            System.out.println("Cluster data:");
            System.out.println(clusterData);
        }
    }
}
