/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.runtime.installer.frontend.GUIHelper;
import java.lang.reflect.Constructor;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;

public class ToolTipHelpLabel
extends JLabel {
    private static final Icon ICON_16 = GUIHelper.loadIcon("help_16.png");
    private static final Icon ICON_DISABLED_16 = GUIHelper.loadIcon("help_disabled_16.png");
    private static ToolTipManager toolTipManager;
    private String tooltipText;

    public static ToolTipManager getToolTipManager() {
        ToolTipHelpLabel.initTooltipManager();
        return toolTipManager;
    }

    private static void initTooltipManager() {
        if (toolTipManager == null) {
            try {
                Constructor constructor = ToolTipManager.class.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                toolTipManager = (ToolTipManager)constructor.newInstance(new Object[0]);
                toolTipManager.setDismissDelay(Integer.MAX_VALUE);
                toolTipManager.setInitialDelay(0);
            }
            catch (Exception e) {
                toolTipManager = ToolTipManager.sharedInstance();
            }
        }
    }

    public ToolTipHelpLabel(String tooltipText) {
        super(ICON_16);
        this.setDisabledIcon(ICON_DISABLED_16);
        this.tooltipText = tooltipText;
        this.registerWithToolTipManager();
    }

    @Override
    public String getToolTipText() {
        return this.isEnabled() ? this.tooltipText : null;
    }

    @Override
    public void setToolTipText(String tooltipText) {
        this.tooltipText = tooltipText;
    }

    private void registerWithToolTipManager() {
        InputMap inputMap = this.getInputMap();
        this.getActionMap();
        boolean removeKeyStroke = false;
        KeyStroke[] ks = inputMap.keys();
        if (ks == null || ks.length == 0) {
            inputMap.put(KeyStroke.getKeyStroke(92, 0), "backSlash");
            removeKeyStroke = true;
        }
        ToolTipHelpLabel.initTooltipManager();
        toolTipManager.registerComponent(this);
        if (removeKeyStroke) {
            inputMap.remove(KeyStroke.getKeyStroke(92, 0));
        }
    }

    @Override
    public boolean isFocusable() {
        return false;
    }
}

