/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.fileinst;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.fileinst.BackupPair;
import com.install4j.runtime.installer.helper.fileinst.FileLogger;
import com.install4j.runtime.installer.helper.fileinst.HelperFileInstallerState;
import com.install4j.runtime.installer.helper.fileinst.InstallFile;
import com.install4j.runtime.installer.helper.fileinst.MainFileInstallerState;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

abstract class FileInstallerState
implements Serializable {
    private transient boolean respondedOverwriteNever = false;
    private transient boolean respondedOverwriteAlways = false;
    protected transient int currentId = 0;
    protected transient int maxId = 0;
    private static FileInstallerState instance = HelperCommunication.getInstance().isElevatedHelper() ? new HelperFileInstallerState() : new MainFileInstallerState();
    private Set<Integer> rolledBackIds = new HashSet<Integer>();

    public static FileInstallerState getInstance() {
        return instance;
    }

    public abstract void setRollbackBarrier();

    public abstract void setLogDir(File var1);

    public abstract void writeLog() throws IOException, UserCanceledException;

    public abstract boolean wasPreviouslyCreated(File var1);

    public abstract boolean hasRollbackFiles();

    public abstract boolean hasUnrollbackedFiles();

    public abstract void addReplacedFile(BackupPair var1);

    public abstract void addCreatedDir(InstallFile var1);

    public abstract void registerCleanupFile(File var1);

    public abstract void addCreatedFile(InstallFile var1, boolean var2);

    public abstract FileLogger getRollbackFileLogger();

    public abstract List<BackupPair> getReplacedFiles();

    public abstract List<File> getCleanupFiles();

    public abstract boolean isCurrentRebootRequired();

    public abstract void setCurrentRebootRequired(boolean var1);

    protected FileInstallerState() {
    }

    public boolean isRespondedOverwriteNever() {
        return this.respondedOverwriteNever;
    }

    public boolean isRespondedOverwriteAlways() {
        return this.respondedOverwriteAlways;
    }

    public void setRespondedOverwriteNever(final boolean respondedOverwriteNever) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.ALL, new RunAction(){

            @Override
            protected void run(Context context) {
                FileInstallerState.getInstance().respondedOverwriteNever = respondedOverwriteNever;
            }
        });
    }

    public void setRespondedOverwriteAlways(final boolean respondedOverwriteAlways) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.ALL, new RunAction(){

            @Override
            protected void run(Context context) {
                FileInstallerState.getInstance().respondedOverwriteAlways = respondedOverwriteAlways;
            }
        });
    }

    public void setRollbackIds(final int currentId, final int maxId) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.ALL, new RunAction(){

            @Override
            protected void run(Context context) {
                FileInstallerState.getInstance().currentId = currentId;
                FileInstallerState.getInstance().maxId = maxId;
            }
        });
    }

    public Set<Integer> getRolledBackIds() {
        return this.rolledBackIds;
    }

    public void addRolledBackId(final int id) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.ALL, new RunAction(){

            @Override
            protected void run(Context context) {
                for (int i = id; i <= FileInstallerState.this.maxId; ++i) {
                    FileInstallerState.getInstance().rolledBackIds.add(i);
                }
            }
        });
    }
}

