/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.runtime.installer.helper.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class VariableEncoding {
    public static final String BOOLEAN_SUFFIX = "$Boolean";
    public static final String DATE_SUFFIX = "$Date";
    public static final String INTEGER_SUFFIX = "$Integer";
    public static final String LONG_SUFFIX = "$Long";
    public static final String INT_ARRAY_SUFFIX = "$IntArray";
    public static final String STRING_ARRAY_SUFFIX = "$StringArray";

    public static Map<String, Object> decodeVariables(Map<String, String> encodedVars, boolean ignoreErrors) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : encodedVars.entrySet()) {
            String variableName = entry.getKey();
            String variableString = entry.getValue();
            String realName = variableName;
            int i = variableName.indexOf(36);
            if (i > -1) {
                realName = variableName.substring(0, i);
            }
            try {
                result.put(realName, VariableEncoding.decodeVariable(variableName, variableString));
            }
            catch (Exception e) {
                if (ignoreErrors) continue;
                String errorMessage = "Could not decode variable " + variableName + ": " + e.toString();
                Logger.getInstance().error(null, errorMessage);
                System.err.println(errorMessage);
            }
        }
        return result;
    }

    private static Object decodeVariable(String variableName, String variableString) {
        if (variableName.endsWith(BOOLEAN_SUFFIX)) {
            return Boolean.valueOf(variableString);
        }
        if (variableName.endsWith(DATE_SUFFIX)) {
            return new Date(Long.parseLong(variableString));
        }
        if (variableName.endsWith(INTEGER_SUFFIX)) {
            return new Integer(variableString);
        }
        if (variableName.endsWith(LONG_SUFFIX)) {
            return new Long(variableString);
        }
        if (variableName.endsWith(INT_ARRAY_SUFFIX)) {
            return VariableEncoding.decodeIntegerArray(variableString);
        }
        if (variableName.endsWith(STRING_ARRAY_SUFFIX)) {
            return VariableEncoding.decodeStringArray(variableString);
        }
        return variableString;
    }

    public static Object decodeIntegerArray(String variableString) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(variableString, ",");
        while (tokenizer.hasMoreTokens()) {
            String sVal = tokenizer.nextToken();
            list.add(sVal.trim());
        }
        int[] ret = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String s = (String)list.get(i);
            ret[i] = Integer.parseInt(s);
        }
        return ret;
    }

    public static Object decodeStringArray(String variableString) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer curVal = null;
        for (int i = 0; i < variableString.length(); ++i) {
            char c = variableString.charAt(i);
            if (i == 0 && c != '\"') {
                throw new IllegalArgumentException("Missing quote at the beginning of " + variableString);
            }
            if (c == '\"') {
                if (curVal == null) {
                    curVal = new StringBuffer();
                    continue;
                }
                list.add(curVal.toString());
                curVal = null;
                continue;
            }
            if (c == '\\') {
                ++i;
                if (curVal == null) continue;
                curVal.append(variableString.charAt(i));
                continue;
            }
            if (curVal != null) {
                curVal.append(c);
                continue;
            }
            if (c == ',' || Character.isWhitespace(c)) continue;
            throw new IllegalArgumentException("Illegal separator \"" + c + "\" in " + variableString);
        }
        if (curVal != null) {
            throw new IllegalArgumentException("Unmatched quotes in " + variableString);
        }
        String[] ret = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = (String)list.get(i);
        }
        return ret;
    }

    public static boolean encodeVariable(Map<String, String> properties, String variableName, Object variableValue) {
        if (variableValue == null) {
            return false;
        }
        if (variableValue instanceof String) {
            properties.put(variableName, (String)variableValue);
        } else if (variableValue instanceof Boolean) {
            properties.put(variableName + BOOLEAN_SUFFIX, variableValue.toString());
        } else if (variableValue instanceof Date) {
            properties.put(variableName + DATE_SUFFIX, String.valueOf(((Date)variableValue).getTime()));
        } else if (variableValue instanceof Integer) {
            properties.put(variableName + INTEGER_SUFFIX, variableValue.toString());
        } else if (variableValue instanceof Long) {
            properties.put(variableName + LONG_SUFFIX, variableValue.toString());
        } else if (variableValue instanceof int[]) {
            int[] intArray = (int[])variableValue;
            StringBuilder value = new StringBuilder();
            for (int i = 0; i < intArray.length; ++i) {
                value.append(intArray[i]);
                if (i >= intArray.length - 1) continue;
                value.append(",");
            }
            properties.put(variableName + INT_ARRAY_SUFFIX, value.toString());
        } else if (variableValue instanceof String[]) {
            String[] stringArray = (String[])variableValue;
            StringBuilder value = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                value.append("\"").append(VariableEncoding.encodeArrayString(stringArray[i])).append("\"");
                if (i >= stringArray.length - 1) continue;
                value.append(",");
            }
            properties.put(variableName + STRING_ARRAY_SUFFIX, value.toString());
        } else {
            return false;
        }
        return true;
    }

    private static String encodeArrayString(String str) {
        if (str == null) {
            return "";
        }
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\"') {
                value.append("\\\"");
                continue;
            }
            if (c == '\\') {
                value.append("\\\\");
                continue;
            }
            value.append(c);
        }
        return value.toString();
    }

    public static void main(String[] args) {
        HashMap<String, String> props = new HashMap<String, String>();
        VariableEncoding.encodeVariable(props, "stringVar", "test\\\"");
        VariableEncoding.encodeVariable(props, "booleanVar", Boolean.TRUE);
        VariableEncoding.encodeVariable(props, "integerVar", 123);
        VariableEncoding.encodeVariable(props, "dateVar", new Date());
        VariableEncoding.encodeVariable(props, "intArray", new int[0]);
        VariableEncoding.encodeVariable(props, "stringArray", new String[0]);
        VariableEncoding.encodeVariable(props, "stringArray2", new String[]{"One", "Two\" c\\3"});
        System.out.println(props);
        HashMap<String, String> encoded = new HashMap<String, String>();
        for (Map.Entry entry : props.entrySet()) {
            encoded.put((String)entry.getKey(), (String)entry.getValue());
        }
        System.out.println("decode");
        Map<String, Object> result = VariableEncoding.decodeVariables(encoded, false);
        for (Map.Entry<String, Object> entry : result.entrySet()) {
            System.out.println(entry.getKey());
            List<String> value = entry.getValue();
            List<String> displayValue = value instanceof String[] ? Arrays.asList((String[])value) : value;
            System.out.println(entry.getValue().getClass().getName() + ": " + displayValue);
            System.out.println("---------");
        }
    }
}

