/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class PreferencesUtil {
    private static boolean disableSystemRoot = false;

    public static void setDisableSystemRoot(boolean disableSystemRoot) {
        PreferencesUtil.disableSystemRoot = disableSystemRoot;
    }

    public static boolean isDisableSystemRoot() {
        return disableSystemRoot;
    }

    public static Preferences getPackageNode(String name, boolean userSpecific) {
        return PreferencesUtil.getRootNode(userSpecific).node(PreferencesUtil.sanitizePackageName(name));
    }

    public static Preferences getPackageNodeNoCreation(String name, boolean userSpecific) throws BackingStoreException {
        String sanitizedPackageName;
        Preferences rootNode = PreferencesUtil.getRootNode(userSpecific);
        if (rootNode.nodeExists(sanitizedPackageName = PreferencesUtil.sanitizePackageName(name))) {
            return rootNode.node(sanitizedPackageName);
        }
        return null;
    }

    private static String sanitizePackageName(String name) {
        if (!(name = name.replace('.', '/').replace('_', '-')).startsWith("/")) {
            name = "/" + name;
        }
        return name;
    }

    public static Preferences getRootNode(boolean userSpecific) {
        return userSpecific || PreferencesUtil.isDisableSystemRoot() ? Preferences.userRoot() : Preferences.systemRoot();
    }
}

