/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.Util;
import com.install4j.api.actions.Action;
import com.install4j.api.beans.Bean;
import com.install4j.api.beans.PropertyLoggingInterceptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerEvent;
import com.install4j.api.events.InstallerEventListener;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.util.StringUtil;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;

public class LoggerImpl
extends Logger
implements InstallerEventListener {
    private PrintWriter out;
    private File logFile;
    private boolean moved;
    private WeakReference<Object> lastSource;
    private String lastPrefix;
    private Action currentAction;
    private Screen currentScreen;
    private File finalLogFile;

    LoggerImpl() {
        InstallerConfig config = InstallerConfig.getCurrentInstance();
        try {
            String alternativeLogfile;
            String altLogProp = System.getProperty("install4j.alternativeLogfile");
            if ("null".equals(altLogProp)) {
                altLogProp = null;
            }
            if ((alternativeLogfile = altLogProp) != null) {
                this.logFile = new File(alternativeLogfile);
                this.logFile.getParentFile().mkdirs();
            } else {
                String logFilePrefix = "i4j_log";
                String shortName = null;
                if (config != null) {
                    shortName = InstallerConfig.getCurrentInstance().getCompilerVariables().get("sys.shortName");
                }
                if (shortName != null) {
                    logFilePrefix = logFilePrefix + "_" + shortName + "_";
                }
                this.logFile = File.createTempFile(logFilePrefix, ".log");
            }
            Runtime.getRuntime().addShutdownHook(new Thread("delete_log"){

                @Override
                public void run() {
                    if (!Boolean.getBoolean("install4j.keepLog") && alternativeLogfile == null && LoggerImpl.this.logFile != null && !LoggerImpl.this.moved) {
                        LoggerImpl.this.out.close();
                        LoggerImpl.this.logFile.delete();
                    }
                }
            });
            String logEncoding = System.getProperty("install4j.logEncoding");
            this.out = logEncoding != null ? new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile), logEncoding)) : new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.logFile)));
        }
        catch (IOException e) {
            e.printStackTrace();
            this.out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(FileDescriptor.out)));
        }
        InstallerVariables.registerVariableProvider("sys.logFile", new InstallerVariables.VariableProvider(){

            @Override
            public Object getVariable() {
                try {
                    return LoggerImpl.this.logFile.getCanonicalPath();
                }
                catch (IOException e) {
                    return LoggerImpl.this.logFile.getAbsolutePath();
                }
            }

            @Override
            public void setVariable(Object value) {
            }
        });
        this.info(null, "logger started at " + new Date());
        this.info(null, "executable name: " + System.getProperty("exe4j.moduleName"));
        if (config != null) {
            this.info(null, "install4j version: " + config.getInstall4jVersion() + " (build " + config.getInstall4jBuild() + ")");
        }
        this.info(null, "Properties: ");
        System.getProperties().list(this.out);
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void closeLogFile() {
        this.out.close();
    }

    public synchronized void moveLogFile() {
        if (this.logFile != null && this.finalLogFile != null && !Boolean.getBoolean("install4j.noPermanentLogFile")) {
            this.moved = true;
            this.closeLogFile();
            if (LoggerImpl.moveInt(this.logFile, this.finalLogFile)) {
                this.logFile = this.finalLogFile;
            }
        }
    }

    private static boolean moveInt(final File logFile, final File finalLogFile) {
        final String accessMode = System.getProperty("install4j.runtimeAccessMode");
        return HelperCommunication.getInstance().fetchBoolean(ContentInstaller.getExecutionContext(), new FetchBooleanAction(){

            @Override
            protected boolean fetchValue(Context context) throws UserCanceledException {
                try {
                    FileUtil.copyFile(logFile, finalLogFile);
                    if (!Boolean.getBoolean("install4j.keepLog")) {
                        logFile.delete();
                    }
                    if (accessMode != null && !Util.isWindows()) {
                        VersionSpecificHelper.setPosixFilePermissions(finalLogFile, accessMode);
                    }
                    return true;
                }
                catch (IOException e) {
                    if (Boolean.getBoolean("install4j.logFileError")) {
                        System.err.println("could not copy log file: " + e.getMessage());
                    }
                    return false;
                }
            }
        });
    }

    @Override
    public void installerEvent(InstallerEvent event) {
        EventType type = event.getType();
        if (LOGGED_EVENT_TYPES.contains((Object)type) || !event.wasSuccessful() && LOGGED_EVENT_TYPES_FAILURE_ONLY.contains((Object)type)) {
            this.log(event.getSource(), event.getVerbose(), event.wasSuccessful());
        }
        if (type == EventType.BEFORE_EXECUTE_ACTION) {
            this.logActionProperties(event.getSource());
        }
    }

    public void switchToSecondaryProcess() {
        System.getProperties().remove("install4j.alternativeLogfile");
    }

    @Override
    public synchronized void log(Throwable e) {
        this.error(null, e.toString());
        this.out.print(Util.getAnnotatedStackTrace(e));
        this.out.flush();
        if (Boolean.getBoolean("install4j.logToStderr")) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void log(Object source, String text, boolean success) {
        boolean sameOrigin;
        if (source instanceof Context) {
            source = null;
        }
        if (source == null && this.currentAction != null) {
            source = this.currentAction;
        }
        if (source == null && this.currentScreen != null) {
            source = this.currentScreen;
        }
        StringBuilder buffer = new StringBuilder();
        String prefix = this.getPrefix(success);
        boolean bl = sameOrigin = this.lastSource != null && source != null && this.lastSource.get() == source && prefix.equals(this.lastPrefix);
        if (sameOrigin) {
            buffer.append(StringUtil.repeat(" ", prefix.length()));
        } else {
            buffer.append(prefix);
            if (source != null) {
                String id;
                if (source instanceof Class) {
                    buffer.append(((Class)source).getName());
                } else {
                    buffer.append(source.getClass().getName());
                }
                if (source instanceof Bean && (id = AbstractBeanConfig.getId((Bean)source)) != null) {
                    buffer.append(" [ID ");
                    buffer.append(id);
                    buffer.append("]");
                }
                buffer.append(": ");
            }
            this.lastSource = new WeakReference<Object>(source);
            this.lastPrefix = prefix;
        }
        buffer.append(text);
        this.out.println(buffer.toString());
        this.out.flush();
        if (Boolean.getBoolean("install4j.logToStderr")) {
            System.err.println(buffer.toString());
        }
    }

    private String getPrefix(boolean success) {
        if (success) {
            return "[INFO] ";
        }
        return "[ERROR] ";
    }

    private void logActionProperties(Object source) {
        Method[] methods;
        for (Method method : methods = source.getClass().getMethods()) {
            String name = method.getName();
            if (method.getParameterTypes().length != 0 || name.equals("getClass") || (!name.startsWith("get") || name.length() <= 3) && (!name.startsWith("is") || name.length() <= 2)) continue;
            try {
                this.logProperty(source, name, method.invoke(source, new Object[0]));
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
    }

    private void logProperty(Object source, String methodName, Object value) {
        String propertyName = methodName.startsWith("get") ? methodName.substring(3, 4).toLowerCase() + methodName.substring(4) : methodName.substring(2, 3).toLowerCase() + methodName.substring(3);
        if (source instanceof PropertyLoggingInterceptor) {
            value = ((PropertyLoggingInterceptor)source).getLogValueForProperty(propertyName, value);
        }
        this.info(source, "Property " + propertyName + ": " + StringUtil.toStringWithArrays(value));
    }

    public void resetOrigin() {
        this.lastSource = null;
        this.lastPrefix = null;
    }

    public void setCurrentScreen(Screen currentScreen) {
        this.currentScreen = currentScreen;
    }

    public void setCurrentAction(Action currentAction) {
        this.currentAction = currentAction;
    }

    public void setFinalLogFile(File finalLogFile) {
        this.finalLogFile = finalLogFile;
    }
}

