/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.headless;

import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.context.WizardContext;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.DummyWizardContext;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ActionCallback;
import com.install4j.runtime.installer.controller.CommandSink;
import com.install4j.runtime.installer.controller.ControllerCommand;
import com.install4j.runtime.installer.controller.FinishCommand;
import com.install4j.runtime.installer.controller.GoForwardCommand;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.FormPanel;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.ConsoleImpl;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.FileDescriptor;
import java.net.InetAddress;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Collections;
import javax.swing.JEditorPane;

public abstract class AbstractHeadlessScreenExecutor
implements ScreenExecutor {
    private CommandSink commandSink;
    private ContextImpl contextImpl;
    private boolean exitCalled = false;
    private WizardContext dummyWizardContext = this.createWizardContext();
    private boolean fileInstallerProgressInterfaceSet;

    public AbstractHeadlessScreenExecutor() {
        this.contextImpl = this.createContext();
    }

    protected abstract ContextImpl createContext();

    protected abstract ControllerCommand handleScreen(ScreenBeanConfig var1) throws UserCanceledException;

    protected DummyWizardContext createWizardContext() {
        return new DummyWizardContext();
    }

    protected void init(boolean headless) {
        if (headless) {
            System.setProperty("java.awt.headless", "true");
        }
        Policy.setPolicy(new AllowAllPolicy());
        System.setSecurityManager(new CheckExitSecurityManager());
        Runtime.getRuntime().addShutdownHook(new Thread("shutdown hook"){

            @Override
            public void run() {
                if (!AbstractHeadlessScreenExecutor.this.exitCalled && AbstractHeadlessScreenExecutor.this.commandSink != null) {
                    ConsoleImpl.getInstance().cancel();
                    ContextImpl.setCancelling();
                    AbstractHeadlessScreenExecutor.this.commandSink.returnToController(ControllerCommand.CANCEL);
                    AbstractHeadlessScreenExecutor.this.commandSink.waitForFinish();
                }
            }
        });
        if (!HelperCommunication.getInstance().isElevatedHelper()) {
            new FormPanel(Collections.emptyList(), this.getContext(), false, null);
            new JEditorPane("text/plain", "init text");
        }
    }

    @Override
    public void execute(ScreenBeanConfig screenConfig, CommandSink commandSink, boolean previousPossible, ControllerCommand lastCommand) {
        this.setCommandSink(commandSink);
        if (!this.fileInstallerProgressInterfaceSet) {
            FileInstaller.getInstance().setDefaultProgressInterface(this.getProgressInterface());
            this.fileInstallerProgressInterfaceSet = true;
        }
        try {
            ControllerCommand specialCommand = this.handleScreen(screenConfig);
            if (specialCommand != null) {
                commandSink.returnToController(specialCommand);
            } else {
                commandSink.returnToController(new GoForwardCommand(1, true, true, null));
            }
        }
        catch (UserCanceledException e) {
            commandSink.returnToController(ControllerCommand.CANCEL);
        }
        catch (Throwable e) {
            this.getContext().handleCriticalException(e);
        }
    }

    @Override
    public void setCommandSink(CommandSink commandSink) {
        this.commandSink = commandSink;
    }

    @Override
    public CommandSink getCommandSink() {
        return this.commandSink;
    }

    @Override
    public ProgressInterface getDefaultProgressInterface() {
        return this.getProgressInterface();
    }

    @Override
    public WizardContext getWizardContext() {
        return this.dummyWizardContext;
    }

    @Override
    public void setRollback() {
        this.getProgressInterface().setStatusMessage(Messages.getMessages().getString("StatusRollback"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ControllerCommand runValidationScript(ScreenBeanConfig screenConfig, Screen screen, Object[] scriptParameters) {
        ControllerCommand storedCommand;
        boolean validated;
        this.getCommandSink().startStoreCommand();
        try {
            validated = this.getContext().runBooleanScript(screenConfig.getValidationClassName(), screen, scriptParameters);
        }
        finally {
            storedCommand = this.getCommandSink().finishStoreCommand();
        }
        if (storedCommand != null) {
            return storedCommand;
        }
        if (!validated) {
            return ControllerCommand.CANCEL;
        }
        if (screenConfig.isFinishScreen()) {
            return new FinishCommand(null);
        }
        return null;
    }

    @Override
    public void closeWindows() {
    }

    @Override
    public ActionCallback getActionCallback() {
        return null;
    }

    @Override
    public void register(Screen screen, ScreenBeanConfig config) {
        this.getContext().applyToScreen(screen, config);
    }

    @Override
    public ContextImpl getContext() {
        return this.contextImpl;
    }

    @Override
    public void initializeLazilyLoadedScreens() {
    }

    private static class AllowAllPolicy
    extends Policy {
        private AllowAllPolicy() {
        }

        @Override
        public PermissionCollection getPermissions(CodeSource codesource) {
            Permissions permission = new Permissions();
            permission.add(new AllPermission());
            return permission;
        }

        @Override
        public PermissionCollection getPermissions(ProtectionDomain domain) {
            Permissions permission = new Permissions();
            permission.add(new AllPermission());
            return permission;
        }

        @Override
        public void refresh() {
        }
    }

    private class CheckExitSecurityManager
    extends SecurityManager {
        private CheckExitSecurityManager() {
        }

        @Override
        public void checkPermission(Permission perm) {
        }

        @Override
        public void checkPermission(Permission perm, Object context) {
        }

        @Override
        public void checkCreateClassLoader() {
        }

        @Override
        public void checkAccess(Thread t) {
        }

        @Override
        public void checkAccess(ThreadGroup g) {
        }

        @Override
        public void checkExit(int status) {
            AbstractHeadlessScreenExecutor.this.exitCalled = true;
        }

        @Override
        public void checkExec(String cmd) {
        }

        @Override
        public void checkLink(String lib) {
        }

        @Override
        public void checkRead(FileDescriptor fd) {
        }

        @Override
        public void checkRead(String file) {
        }

        @Override
        public void checkRead(String file, Object context) {
        }

        @Override
        public void checkWrite(FileDescriptor fd) {
        }

        @Override
        public void checkWrite(String file) {
        }

        @Override
        public void checkDelete(String file) {
        }

        @Override
        public void checkConnect(String host, int port) {
        }

        @Override
        public void checkConnect(String host, int port, Object context) {
        }

        @Override
        public void checkListen(int port) {
        }

        @Override
        public void checkAccept(String host, int port) {
        }

        @Override
        public void checkMulticast(InetAddress maddr) {
        }

        @Override
        public void checkMulticast(InetAddress maddr, byte ttl) {
        }

        @Override
        public void checkPropertiesAccess() {
        }

        @Override
        public void checkPropertyAccess(String key) {
        }

        public boolean checkTopLevelWindow(Object window) {
            return true;
        }

        @Override
        public void checkPrintJobAccess() {
        }

        public void checkSystemClipboardAccess() {
        }

        public void checkAwtEventQueueAccess() {
        }

        @Override
        public void checkPackageAccess(String pkg) {
        }

        @Override
        public void checkPackageDefinition(String pkg) {
        }

        @Override
        public void checkSetFactory() {
        }

        public void checkMemberAccess(Class clazz, int which) {
        }

        @Override
        public void checkSecurityAccess(String target) {
        }
    }
}

