/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.controller;

import com.install4j.api.screens.Screen;
import com.install4j.runtime.beans.groups.ControlFlowGroup;
import com.install4j.runtime.beans.groups.Group;
import com.install4j.runtime.beans.screens.FormScreen;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.GroupBeanConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import java.util.LinkedList;
import java.util.List;

public class ScreenNavigator {
    private LinkedList<HistoryEntry> screenConfigHistory = new LinkedList();
    private LinkedList<GroupStackEntry> groupStack = new LinkedList();
    private ContextImpl context;

    public ScreenNavigator(ContextImpl context) {
        this.context = context;
        this.groupStack.add(new GroupStackEntry(null, context.getScreenConfigs(), -1));
    }

    public void sync(ScreenBeanConfig currentScreenConfig) {
        this.groupStack.clear();
        this.fillGroupStack(null, this.context.getScreenConfigs(), currentScreenConfig);
    }

    private boolean fillGroupStack(GroupBeanConfig parentGroupConfig, List screenConfigs, ScreenBeanConfig currentScreenConfig) {
        for (int i = 0; i < screenConfigs.size(); ++i) {
            AbstractBeanConfig config = (AbstractBeanConfig)screenConfigs.get(i);
            if (config instanceof ScreenBeanConfig) {
                ScreenBeanConfig screenConfig = (ScreenBeanConfig)config;
                if (screenConfig != currentScreenConfig) continue;
                this.groupStack.add(new GroupStackEntry(parentGroupConfig, screenConfigs, i));
                return true;
            }
            GroupBeanConfig childGroupConfig = (GroupBeanConfig)config;
            if (!this.fillGroupStack(childGroupConfig, childGroupConfig.getBeanConfigs(), currentScreenConfig)) continue;
            this.groupStack.addFirst(new GroupStackEntry(parentGroupConfig, screenConfigs, i));
            return true;
        }
        return false;
    }

    public ScreenBeanConfig findNextScreenConfig(ScreenBeanConfig currentScreenConfig, int number, boolean checkCondition) {
        if (this.getCurrentConfig() != currentScreenConfig) {
            this.sync(currentScreenConfig);
        }
        boolean checkLoop = number == 1;
        for (int i = 0; i < number; ++i) {
            if (this.forward(checkLoop, checkCondition)) continue;
            return null;
        }
        return (ScreenBeanConfig)this.getCurrentConfig();
    }

    public ScreenBeanConfig findPreviousScreenConfig(ScreenBeanConfig currentScreenConfig, int number) {
        if (this.getCurrentConfig() != currentScreenConfig) {
            this.sync(currentScreenConfig);
        }
        for (int i = 0; i < number; ++i) {
            if (this.backward()) continue;
            return null;
        }
        return (ScreenBeanConfig)this.getCurrentConfig();
    }

    private AbstractBeanConfig getCurrentConfig() {
        GroupStackEntry currentStackEntry = this.getCurrentStackEntry();
        if (currentStackEntry == null) {
            return null;
        }
        return currentStackEntry.getCurrentConfig();
    }

    public ScreenBeanConfig findPreviousScreenConfigInHistory(boolean updateGroupStack, List<AbstractBeanConfig> hiddenForPreviousActionConfigs, int number) {
        ScreenBeanConfig screenBeanConfig = null;
        for (int i = 0; i < number && (screenBeanConfig = this.backwardInHistory(updateGroupStack, hiddenForPreviousActionConfigs)) != null; ++i) {
        }
        return screenBeanConfig;
    }

    private ScreenBeanConfig backwardInHistory(boolean updateGroupStack, List<AbstractBeanConfig> hiddenForPreviousActionConfigs) {
        ScreenBeanConfig screenBeanConfig = null;
        int i = this.screenConfigHistory.size() - 1;
        if (!updateGroupStack) {
            --i;
        }
        HistoryEntry historyEntry = null;
        while (i >= 0) {
            Screen screen;
            historyEntry = this.screenConfigHistory.get(i);
            screenBeanConfig = historyEntry.screenConfig;
            if (updateGroupStack) {
                this.screenConfigHistory.remove(i);
            }
            if (!(screen = screenBeanConfig.getOrInstantiateScreen(false)).isHiddenForPrevious()) break;
            if (hiddenForPreviousActionConfigs != null) {
                hiddenForPreviousActionConfigs.addAll(screenBeanConfig.getActionConfigs());
            }
            --i;
        }
        if (updateGroupStack && historyEntry != null) {
            this.groupStack = historyEntry.groupStack;
            ContextImpl.GroupState parentGroupState = null;
            for (GroupStackEntry groupStackEntry : this.groupStack) {
                Group group;
                if (groupStackEntry.groupConfig != null && (group = groupStackEntry.groupConfig.getOrInstantiateGroup(false)) instanceof ControlFlowGroup && parentGroupState != null) {
                    ControlFlowGroup controlFlowGroup = (ControlFlowGroup)group;
                    this.context.setLoopIndexInstallerVariable(controlFlowGroup, parentGroupState);
                }
                parentGroupState = groupStackEntry.groupState;
            }
        }
        return screenBeanConfig;
    }

    private boolean forward(boolean checkLoop, boolean checkCondition) {
        GroupStackEntry stackEntry = this.getCurrentStackEntry();
        while (stackEntry.index < stackEntry.screenConfigs.size() - 1) {
            stackEntry.index++;
            AbstractBeanConfig beanConfig = (AbstractBeanConfig)stackEntry.screenConfigs.get(stackEntry.index);
            if (beanConfig instanceof GroupBeanConfig) {
                GroupBeanConfig groupConfig = (GroupBeanConfig)beanConfig;
                if (checkCondition && !this.context.checkGroupCondition(groupConfig)) continue;
                this.context.initLoopIndex(groupConfig, stackEntry.groupState);
                return this.enterGroup(groupConfig, checkLoop, checkCondition);
            }
            if (!(beanConfig instanceof ScreenBeanConfig)) continue;
            ScreenBeanConfig screenConfig = (ScreenBeanConfig)beanConfig;
            Screen screen = screenConfig.getOrInstantiateScreen(false);
            if (checkCondition && (screen.isHidden() || screen.isHiddenForNext() || !this.context.runBooleanScript(screenConfig.getConditionClassName(), screen))) continue;
            return true;
        }
        if (this.groupStack.size() > 1) {
            GroupBeanConfig groupConfig;
            this.groupStack.removeLast();
            if (checkLoop && this.context.isGroupLoop(groupConfig = (GroupBeanConfig)this.getCurrentConfig(), this.getCurrentStackEntry().groupState)) {
                this.resetInitializationOfContainedFormScreens(groupConfig);
                return this.enterGroup(groupConfig, true, checkCondition);
            }
            if (this.forward(checkLoop, checkCondition)) {
                return true;
            }
        }
        return false;
    }

    private boolean backward() {
        GroupStackEntry stackEntry = this.getCurrentStackEntry();
        while (stackEntry.index > 0) {
            stackEntry.index--;
            AbstractBeanConfig beanConfig = (AbstractBeanConfig)stackEntry.screenConfigs.get(stackEntry.index);
            if (beanConfig instanceof GroupBeanConfig) {
                GroupBeanConfig groupConfig = (GroupBeanConfig)beanConfig;
                this.groupStack.add(new GroupStackEntry(groupConfig, groupConfig.getBeanConfigs(), groupConfig.getBeanConfigs().size()));
                if (this.backward()) {
                    return true;
                }
                this.groupStack.removeLast();
                continue;
            }
            if (!(beanConfig instanceof ScreenBeanConfig)) continue;
            return true;
        }
        return false;
    }

    private void resetInitializationOfContainedFormScreens(GroupBeanConfig groupBeanConfig) {
        if (this.context.isUnattended()) {
            return;
        }
        for (AbstractBeanConfig beanConfig : groupBeanConfig.getBeanConfigs()) {
            if (beanConfig instanceof ScreenBeanConfig) {
                Screen screen = ((ScreenBeanConfig)beanConfig).getOrInstantiateScreen(true);
                if (!(screen instanceof FormScreen)) continue;
                ((FormScreen)screen).resetFormComponents();
                continue;
            }
            if (!(beanConfig instanceof GroupBeanConfig)) continue;
            this.resetInitializationOfContainedFormScreens((GroupBeanConfig)beanConfig);
        }
    }

    private boolean enterGroup(GroupBeanConfig groupConfig, boolean checkLoop, boolean checkCondition) {
        this.groupStack.add(new GroupStackEntry(groupConfig, groupConfig.getBeanConfigs(), -1));
        return this.forward(checkLoop, checkCondition);
    }

    private GroupStackEntry getCurrentStackEntry() {
        if (this.groupStack.isEmpty()) {
            return null;
        }
        return this.groupStack.getLast();
    }

    public void addHistory(ScreenBeanConfig screenConfig) {
        LinkedList<GroupStackEntry> groupStackCopy = new LinkedList<GroupStackEntry>();
        for (GroupStackEntry groupStackEntry : this.groupStack) {
            groupStackCopy.add(groupStackEntry.copy());
        }
        HistoryEntry historyEntry = new HistoryEntry(screenConfig, groupStackCopy);
        this.screenConfigHistory.add(historyEntry);
    }

    public ScreenBeanConfig removeLastHistoryItem() {
        if (this.screenConfigHistory.isEmpty()) {
            return null;
        }
        HistoryEntry historyEntry = this.screenConfigHistory.removeLast();
        if (historyEntry == null) {
            return null;
        }
        return historyEntry.screenConfig;
    }

    private static class GroupStackEntry {
        private GroupBeanConfig groupConfig;
        private List screenConfigs;
        private int index;
        private ContextImpl.GroupState groupState = new ContextImpl.GroupState();

        private GroupStackEntry(GroupBeanConfig groupConfig, List screenConfigs, int index) {
            this.groupConfig = groupConfig;
            this.screenConfigs = screenConfigs;
            this.index = index;
        }

        public AbstractBeanConfig getCurrentConfig() {
            if (this.index < 0 || this.index > this.screenConfigs.size()) {
                return null;
            }
            return (AbstractBeanConfig)this.screenConfigs.get(this.index);
        }

        public GroupStackEntry copy() {
            GroupStackEntry copy = new GroupStackEntry(this.groupConfig, this.screenConfigs, this.index);
            copy.groupState = this.groupState.copy();
            return copy;
        }
    }

    private static class HistoryEntry {
        private ScreenBeanConfig screenConfig;
        private LinkedList<GroupStackEntry> groupStack;

        private HistoryEntry(ScreenBeanConfig screenConfig, LinkedList<GroupStackEntry> groupStack) {
            this.screenConfig = screenConfig;
            this.groupStack = groupStack;
        }
    }
}

