/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.InstallerEvent;
import com.install4j.api.events.InstallerEventListener;
import com.install4j.api.events.InstallerVariableEvent;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.screens.CustomizableScreen;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.components.DirectorySelector;
import com.install4j.runtime.installer.frontend.components.FileValidator;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.io.File;
import java.io.IOException;
import javax.swing.JPanel;

public class CustomizableDirectoryScreen
extends CustomizableScreen
implements FileValidator {
    private String variableName = "";
    private String initialDirectory = "";
    private String standardDirectoryName = "";
    private boolean onlyWritable = false;
    private String directoryDescription = "";
    private String infoText = "";
    private boolean allowSpacesOnUnix = false;
    private boolean allowNewFolderCreation = false;
    private boolean manualEntryAllowed = true;
    private boolean allowEmpty = false;
    private boolean standardValidation = true;
    private ScriptProperty validationScript;
    private DirectorySelector directorySelector;
    private boolean initialized;

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getInitialDirectory() {
        return CustomizableDirectoryScreen.replaceVariables(this.initialDirectory);
    }

    public void setInitialDirectory(String initialDirectory) {
        this.initialDirectory = initialDirectory;
    }

    public String getStandardDirectoryName() {
        return CustomizableDirectoryScreen.replaceVariables(this.standardDirectoryName);
    }

    public void setStandardDirectoryName(String standardDirectoryName) {
        this.standardDirectoryName = standardDirectoryName;
    }

    public boolean isOnlyWritable() {
        return this.onlyWritable;
    }

    public void setOnlyWritable(boolean onlyWritable) {
        this.onlyWritable = onlyWritable;
    }

    public String getDirectoryDescription() {
        return this.directoryDescription;
    }

    public void setDirectoryDescription(String directoryDescription) {
        this.directoryDescription = directoryDescription;
    }

    public String getInfoText() {
        return this.infoText;
    }

    public void setInfoText(String infoText) {
        this.infoText = infoText;
    }

    public boolean isAllowSpacesOnUnix() {
        return this.allowSpacesOnUnix;
    }

    public void setAllowSpacesOnUnix(boolean allowSpacesOnUnix) {
        this.allowSpacesOnUnix = allowSpacesOnUnix;
    }

    public boolean isAllowNewFolderCreation() {
        return this.allowNewFolderCreation;
    }

    public void setAllowNewFolderCreation(boolean allowNewFolderCreation) {
        this.allowNewFolderCreation = allowNewFolderCreation;
    }

    public boolean isManualEntryAllowed() {
        return this.manualEntryAllowed;
    }

    public void setManualEntryAllowed(boolean manualEntryAllowed) {
        this.manualEntryAllowed = manualEntryAllowed;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public void setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    public boolean isStandardValidation() {
        return this.standardValidation;
    }

    public void setStandardValidation(boolean standardValidation) {
        this.standardValidation = standardValidation;
    }

    public ScriptProperty getValidationScript() {
        return this.validationScript;
    }

    public void setValidationScript(ScriptProperty validationScript) {
        this.validationScript = validationScript;
    }

    @Override
    public boolean handleUnattended() {
        this.setDirectory(new File(this.getUsedInitialDirectory()));
        return true;
    }

    private String getUsedInitialDirectory() {
        Object value = this.getContext().getVariable(this.getVariableName());
        if (value != null && value instanceof String) {
            return (String)value;
        }
        return this.getInitialDirectory();
    }

    @Override
    public void setInstallerContext(InstallerContext context) {
        super.setInstallerContext(context);
        this.addVariableListener();
    }

    @Override
    public void setUninstallerContext(UninstallerContext context) {
        super.setUninstallerContext(context);
        this.addVariableListener();
    }

    private void addVariableListener() {
        this.getContext().addInstallerEventListener(new InstallerEventListener(){

            @Override
            public void installerEvent(InstallerEvent event) {
                if (!CustomizableDirectoryScreen.this.getContext().isConsole() && !CustomizableDirectoryScreen.this.getContext().isUnattended() && event instanceof InstallerVariableEvent && ((InstallerVariableEvent)event).getVariableName().equals(CustomizableDirectoryScreen.this.variableName)) {
                    CustomizableDirectoryScreen.this.initDirectorySelector();
                    Object value = CustomizableDirectoryScreen.this.getContext().getVariable(CustomizableDirectoryScreen.this.variableName);
                    if (value != null && value instanceof String) {
                        CustomizableDirectoryScreen.this.directorySelector.setDirectory(new File((String)value));
                    } else {
                        CustomizableDirectoryScreen.this.directorySelector.initDirectory(new File(CustomizableDirectoryScreen.this.getUsedInitialDirectory()), CustomizableDirectoryScreen.this.getStandardDirectoryName());
                    }
                }
            }
        });
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        if (!super.handleConsole(console)) {
            return false;
        }
        this.ensureDirectorySelectorCreated();
        while (true) {
            String answer = console.askString(null, this.getUsedInitialDirectory());
            try {
                File selectedDir = new File(answer).getCanonicalFile();
                this.directorySelector.setSelectedFile(selectedDir);
                if (!new File(answer).isAbsolute() || selectedDir.exists() && !selectedDir.isDirectory()) {
                    console.println(Messages.format(this.getMessage("InvalidDirectory"), answer));
                    continue;
                }
                if (!this.directorySelector.checkSelectedFile() || this.onlyWritable && !InstallerUtil.checkWritableInstallationDirectory(selectedDir, true)) continue;
                this.setDirectory(this.directorySelector.getSelectedFile());
                return true;
            }
            catch (IOException e) {
                console.println(Messages.format(this.getMessage("InvalidDirectory"), answer));
                continue;
            }
            break;
        }
    }

    private void setDirectory(File selectedDir) {
        this.getContext().setVariable(this.getVariableName(), selectedDir.getPath());
        this.getContext().registerResponseFileVariable(this.getVariableName());
    }

    @Override
    public boolean next() {
        this.setDirectory(this.getSelectedDir());
        return super.next();
    }

    @Override
    public void willActivate() {
        super.willActivate();
        this.initDirectorySelector();
    }

    private void initDirectorySelector() {
        if (!this.initialized) {
            this.directorySelector.initDirectory(new File(this.getUsedInitialDirectory()), this.getStandardDirectoryName());
            this.directorySelector.setAllowSpacesOnUnix(this.allowSpacesOnUnix);
            this.directorySelector.setAllowNewFolderCreation(this.allowNewFolderCreation);
            this.directorySelector.setAllowEmpty(this.allowEmpty);
            this.directorySelector.setStandardValidation(this.standardValidation);
            this.directorySelector.setManualEntryAllowed(this.manualEntryAllowed);
            this.initialized = true;
        }
    }

    @Override
    public void activated() {
        super.activated();
        this.directorySelector.focusTextField();
    }

    @Override
    protected boolean checkCompleted() {
        boolean checkOK;
        boolean bl = checkOK = this.directorySelector.checkSelectedFile() && super.checkCompleted();
        if (checkOK) {
            File destDir = this.getSelectedDir();
            return !this.onlyWritable || InstallerUtil.checkWritableInstallationDirectory(destDir, true);
        }
        return false;
    }

    @Override
    protected void addScreenContent(JPanel panel, GridBagConstraints gc) {
        if (this.infoText.trim().length() > 0) {
            this.addDisplayTextArea(this.infoText, panel, gc);
        }
        gc.insets.top = 25;
        panel.add((Component)this.directorySelector, gc);
        gc.insets.top = 0;
        ++gc.gridy;
    }

    @Override
    public boolean isFillVertical() {
        return false;
    }

    @Override
    protected void setupControls() {
        super.setupControls();
        this.ensureDirectorySelectorCreated();
        this.directorySelector.activateNextScreenOnEnter(this.getContext().getWizardContext());
    }

    private void ensureDirectorySelectorCreated() {
        this.directorySelector = new DirectorySelector(this.directoryDescription, false);
        this.directorySelector.setValidator(this);
    }

    private File getSelectedDir() {
        this.initDirectorySelector();
        return this.directorySelector.getSelectedFile();
    }

    @Override
    public boolean isValidFile(File file) {
        if (this.validationScript != null) {
            return ContextImpl.getContextInt(this.getContext()).runBooleanScript(this.validationScript.getValue(), this, new Object[]{file});
        }
        return true;
    }
}

