/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.services;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.LauncherSetup;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.macos.PlistHelper;
import com.install4j.runtime.installer.platform.win32.Win32Services;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.Document;

public abstract class AbstractControlServiceAction
extends SystemInstallOrUninstallAction {
    protected static final String METHOD_START = "start";
    protected static final String METHOD_STOP = "stop";
    private File executable;
    private String serviceName;
    private String launcherId = "";

    public String getLauncherId() {
        return this.launcherId;
    }

    public void setLauncherId(String launcherId) {
        this.launcherId = launcherId;
    }

    public File getExecutable() {
        return AbstractControlServiceAction.replaceVariables(this.executable);
    }

    public void setExecutable(File executable) {
        this.executable = executable;
    }

    public String getServiceName() {
        return AbstractControlServiceAction.replaceVariables(this.serviceName);
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    protected boolean controlService(Context context, String method) {
        return this.controlService(context, method, false);
    }

    protected boolean controlService(Context context, String method, boolean autostartOnly) {
        File usedExecutable;
        String usedName;
        if (this.getLauncherId() == null) {
            usedName = this.getServiceName();
            usedExecutable = context.getDestinationFile(this.getExecutable());
        } else {
            LauncherSetup launcherSetup = context.getLauncherById(this.getLauncherId());
            if (launcherSetup == null) {
                Logger.getInstance().log(this, "The launcher with ID " + this.getLauncherId() + " cannot be found", false);
                return false;
            }
            usedExecutable = context.getDestinationFile(launcherSetup.getRelativeFileName());
            usedName = launcherSetup.getName();
        }
        if (InstallerUtil.isWindows() && autostartOnly) {
            try {
                if (Win32Services.getStartType(usedName) != 2) {
                    return true;
                }
            }
            catch (Win32Services.ServiceException e) {
                Logger.getInstance().log(e);
            }
        }
        Logger.getInstance().info(this, "usedExecutable: " + usedExecutable);
        if (Util.isWindows()) {
            try {
                return this.execute(method, usedName);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        if (!usedExecutable.exists()) {
            Logger.getInstance().log(this, "The executable " + usedExecutable + " does not exist", false);
            return false;
        }
        if (Util.isMacOS()) {
            String identifier = method.equals(METHOD_STOP) ? null : this.findIdentifier(usedExecutable, autostartOnly);
            Logger.getInstance().log(this, "Mac OS X identifier: " + identifier, true);
            if (identifier != null) {
                if (identifier.length() > 0) {
                    LaunchDescriptor launchDescriptor = new LaunchDescriptor(new File("/bin/launchctl")).wait(true).executionContext(ExecutionContext.MAXIMUM).suidRoot(true);
                    Integer returnValue = LaunchHelper.launchApplication(launchDescriptor.arguments(new String[]{"load", new File("/Library/LaunchDaemons", identifier + ".plist").getAbsolutePath()}));
                    if (returnValue != null && returnValue == 0) {
                        returnValue = LaunchHelper.launchApplication(launchDescriptor.arguments(new String[]{method, identifier}));
                        return returnValue != null && returnValue == 0;
                    }
                    return false;
                }
                return true;
            }
            Integer returnValue = LaunchHelper.launchApplication(new LaunchDescriptor(usedExecutable).arguments(new String[]{method}).wait(true).executionContext(ExecutionContext.MAXIMUM).suidRoot(true));
            return returnValue != null && returnValue == 0;
        }
        Integer returnValue = LaunchHelper.launchApplication(new LaunchDescriptor(usedExecutable).arguments(new String[]{method}).wait(true).executionContext(ExecutionContext.MAXIMUM));
        if (returnValue != null && returnValue == 0) {
            return true;
        }
        Logger.getInstance().info(this, usedExecutable + " " + method + " returned " + returnValue);
        return false;
    }

    private String findIdentifier(File usedExecutable, boolean autostartOnly) {
        File[] plistFiles = new File("/Library/LaunchDaemons").listFiles();
        if (plistFiles != null) {
            for (File plistFile : plistFiles) {
                try {
                    Document document = XmlHelper.parseFile(plistFile);
                    String fileName = XmlHelper.getTextValue(PlistHelper.getFirstChild(PlistHelper.findValue(PlistHelper.getFirstChild(document.getDocumentElement(), "dict"), "ProgramArguments"), "string"));
                    if (usedExecutable.getCanonicalPath().equals(fileName)) {
                        if (autostartOnly && !Boolean.valueOf(PlistHelper.findValue(PlistHelper.getFirstChild(document.getDocumentElement(), "dict"), "RunAtLoad").getNodeName()).booleanValue()) {
                            return "";
                        }
                        return XmlHelper.getTextValue(PlistHelper.findValue(PlistHelper.getFirstChild(document.getDocumentElement(), "dict"), "Label"));
                    }
                }
                catch (PlistHelper.NotFoundException e) {
                }
                catch (IOException e) {
                    Logger.getInstance().log(e);
                }
            }
        }
        return null;
    }

    public boolean execute(String method, String usedName) {
        try {
            if (method.equals(METHOD_START)) {
                Win32Services.startService(usedName);
            } else {
                Win32Services.stopService(usedName);
            }
            return true;
        }
        catch (Win32Services.ServiceException e) {
            if (e.getErrorCode() == 1056) {
                Logger.getInstance().info(this, "Service '" + usedName + "' already running.");
                return true;
            }
            if (e.getErrorCode() == 1062) {
                Logger.getInstance().info(this, "Service '" + usedName + "' is not running.");
                return true;
            }
            if (e.getErrorCode() == 1057) {
                Logger.getInstance().error(this, "Invalid service account.");
            } else if (e.getErrorCode() == 5) {
                Logger.getInstance().error(this, "Access denied. Need to be elevated administrator.");
            } else if (e.getErrorCode() == 1060) {
                Logger.getInstance().error(this, "Service '" + usedName + "' does not exist. You need to install it first.");
            } else if (e.getErrorCode() == 1069) {
                Logger.getInstance().error(this, "Logon to service account failed. Password is wrong.");
            } else {
                Logger.getInstance().log(e);
            }
            return false;
        }
    }
}

