/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;

public abstract class AbstractFileAction
extends SystemInstallOrUninstallAction {
    private File[] files;
    private ScriptProperty fileFilter;
    private ScriptProperty directoryFilter;

    public File[] getFiles() {
        return AbstractFileAction.replaceVariables(this.files);
    }

    public void setFiles(File[] files) {
        this.files = files;
    }

    public ScriptProperty getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(ScriptProperty fileFilter) {
        this.fileFilter = fileFilter;
    }

    public ScriptProperty getDirectoryFilter() {
        return this.directoryFilter;
    }

    public void setDirectoryFilter(ScriptProperty directoryFilter) {
        this.directoryFilter = directoryFilter;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        return this.executeForMultipleFilesAction(context, this.getFiles());
    }

    protected boolean executeForMultipleFilesAction(Context context, File[] files) throws UserCanceledException {
        if (files == null) {
            return true;
        }
        boolean success = true;
        for (File file : files) {
            File usedFile = context.getDestinationFile(file);
            if (!usedFile.exists()) {
                Util.logInfo(this, "The file \"" + usedFile.getPath() + "\" does not exist");
                if (!this.isErrorIfFileMissing()) continue;
                success = false;
                continue;
            }
            try {
                success &= this.executeForSingleFile(context, usedFile);
            }
            catch (IOException e) {
                success = false;
                Logger.getInstance().log(e);
            }
        }
        return success;
    }

    protected boolean isErrorIfFileMissing() {
        return true;
    }

    protected abstract boolean executeForSingleFile(Context var1, File var2) throws UserCanceledException, IOException;

    protected boolean passesFileOrDirectoryFilter(File file, Context context) {
        return ContextImpl.runBooleanScript(context, file.isDirectory() ? this.directoryFilter : this.fileFilter, this, new Object[]{file});
    }
}

