/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsPeer;
import org.bouncycastle.tls.CertificateStatusRequest;
import org.bouncycastle.tls.DefaultTlsDHGroupVerifier;
import org.bouncycastle.tls.DefaultTlsSRPConfigVerifier;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.OCSPStatusRequest;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsClientContext;
import org.bouncycastle.tls.TlsDHGroupVerifier;
import org.bouncycastle.tls.TlsECCUtils;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsPSKIdentity;
import org.bouncycastle.tls.TlsSRPConfigVerifier;
import org.bouncycastle.tls.TlsSRPIdentity;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.util.Integers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AbstractTlsClient
extends AbstractTlsPeer
implements TlsClient {
    protected TlsClientContext context;
    protected int[] cipherSuites;
    protected Vector supportedGroups;
    protected Vector supportedSignatureAlgorithms;

    public AbstractTlsClient(TlsCrypto tlsCrypto) {
        super(tlsCrypto);
    }

    protected boolean allowUnexpectedServerExtension(Integer n, byte[] byArray) throws IOException {
        switch (n) {
            case 10: {
                TlsExtensionsUtils.readSupportedGroupsExtension(byArray);
                return true;
            }
            case 11: {
                TlsExtensionsUtils.readSupportedPointFormatsExtension(byArray);
                return true;
            }
        }
        return false;
    }

    protected Vector getNamedGroupRoles() {
        Vector vector = TlsUtils.getNamedGroupRoles(this.getCipherSuites());
        if (null == this.supportedSignatureAlgorithms || TlsUtils.containsAnySignatureAlgorithm(this.supportedSignatureAlgorithms, (short)3)) {
            TlsUtils.addToSet(vector, 3);
        }
        return vector;
    }

    protected void checkForUnexpectedServerExtension(Hashtable hashtable, Integer n) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, n);
        if (byArray != null && !this.allowUnexpectedServerExtension(n, byArray)) {
            throw new TlsFatalAlert(47);
        }
    }

    public TlsPSKIdentity getPSKIdentity() throws IOException {
        return null;
    }

    public TlsSRPIdentity getSRPIdentity() throws IOException {
        return null;
    }

    public TlsDHGroupVerifier getDHGroupVerifier() {
        return new DefaultTlsDHGroupVerifier();
    }

    public TlsSRPConfigVerifier getSRPConfigVerifier() {
        return new DefaultTlsSRPConfigVerifier();
    }

    protected Vector getProtocolNames() {
        return null;
    }

    protected CertificateStatusRequest getCertificateStatusRequest() {
        return new CertificateStatusRequest(1, new OCSPStatusRequest(null, null));
    }

    protected Vector getSNIServerNames() {
        return null;
    }

    protected abstract int[] getSupportedCipherSuites();

    protected Vector getSupportedGroups(Vector vector) {
        TlsCrypto tlsCrypto = this.getCrypto();
        Vector vector2 = new Vector();
        if (vector.contains(Integers.valueOf((int)2))) {
            TlsUtils.addIfSupported(vector2, tlsCrypto, 29);
        }
        if (vector.contains(Integers.valueOf((int)2)) || vector.contains(Integers.valueOf((int)3))) {
            TlsUtils.addIfSupported(vector2, tlsCrypto, new int[]{23, 24});
        }
        if (vector.contains(Integers.valueOf((int)1))) {
            TlsUtils.addIfSupported(vector2, tlsCrypto, new int[]{256, 257, 258});
        }
        return vector2;
    }

    protected Vector getSupportedSignatureAlgorithms() {
        return TlsUtils.getDefaultSupportedSignatureAlgorithms(this.context);
    }

    public void init(TlsClientContext tlsClientContext) {
        this.context = tlsClientContext;
        this.cipherSuites = this.getSupportedCipherSuites();
    }

    public void notifyHandshakeBeginning() throws IOException {
        super.notifyHandshakeBeginning();
        this.supportedGroups = null;
        this.supportedSignatureAlgorithms = null;
    }

    public TlsSession getSessionToResume() {
        return null;
    }

    public boolean isFallback() {
        return false;
    }

    public int[] getCipherSuites() {
        return this.cipherSuites;
    }

    public Hashtable getClientExtensions() throws IOException {
        Vector vector;
        Vector vector2;
        ProtocolVersion protocolVersion;
        CertificateStatusRequest certificateStatusRequest;
        Vector vector3;
        Hashtable hashtable = new Hashtable();
        TlsExtensionsUtils.addEncryptThenMACExtension(hashtable);
        Vector vector4 = this.getProtocolNames();
        if (vector4 != null) {
            TlsExtensionsUtils.addALPNExtensionClient(hashtable, vector4);
        }
        if ((vector3 = this.getSNIServerNames()) != null) {
            TlsExtensionsUtils.addServerNameExtensionClient(hashtable, vector3);
        }
        if ((certificateStatusRequest = this.getCertificateStatusRequest()) != null) {
            TlsExtensionsUtils.addStatusRequestExtension(hashtable, certificateStatusRequest);
        }
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion = this.context.getClientVersion())) {
            this.supportedSignatureAlgorithms = this.getSupportedSignatureAlgorithms();
            TlsExtensionsUtils.addSignatureAlgorithmsExtension(hashtable, this.supportedSignatureAlgorithms);
        }
        if ((vector2 = this.getSupportedGroups(vector = this.getNamedGroupRoles())) != null && !vector2.isEmpty()) {
            this.supportedGroups = vector2;
            TlsExtensionsUtils.addSupportedGroupsExtension(hashtable, vector2);
        }
        if (vector.contains(Integers.valueOf((int)2)) || vector.contains(Integers.valueOf((int)3))) {
            TlsExtensionsUtils.addSupportedPointFormatsExtension(hashtable, new short[]{0});
        }
        return hashtable;
    }

    public void notifyServerVersion(ProtocolVersion protocolVersion) throws IOException {
    }

    public void notifySessionID(byte[] byArray) {
    }

    public void notifySelectedCipherSuite(int n) {
    }

    public void processServerExtensions(Hashtable hashtable) throws IOException {
        if (hashtable != null) {
            this.checkForUnexpectedServerExtension(hashtable, TlsUtils.EXT_signature_algorithms);
            this.checkForUnexpectedServerExtension(hashtable, TlsUtils.EXT_signature_algorithms_cert);
            this.checkForUnexpectedServerExtension(hashtable, TlsExtensionsUtils.EXT_supported_groups);
            int n = this.context.getSecurityParametersHandshake().getCipherSuite();
            if (TlsECCUtils.isECCCipherSuite(n)) {
                TlsExtensionsUtils.getSupportedPointFormatsExtension(hashtable);
            } else {
                this.checkForUnexpectedServerExtension(hashtable, TlsExtensionsUtils.EXT_ec_point_formats);
            }
            this.checkForUnexpectedServerExtension(hashtable, TlsExtensionsUtils.EXT_padding);
        }
    }

    public void processServerSupplementalData(Vector vector) throws IOException {
        if (vector != null) {
            throw new TlsFatalAlert(10);
        }
    }

    public Vector getClientSupplementalData() throws IOException {
        return null;
    }

    public void notifyNewSessionTicket(NewSessionTicket newSessionTicket) throws IOException {
    }
}

