/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsClientContext;
import org.bouncycastle.tls.TlsDHGroupVerifier;
import org.bouncycastle.tls.TlsPSKIdentity;
import org.bouncycastle.tls.TlsPeer;
import org.bouncycastle.tls.TlsSRPConfigVerifier;
import org.bouncycastle.tls.TlsSRPIdentity;
import org.bouncycastle.tls.TlsSession;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface TlsClient
extends TlsPeer {
    public void init(TlsClientContext var1);

    public TlsSession getSessionToResume();

    public boolean isFallback();

    public int[] getCipherSuites();

    public Hashtable getClientExtensions() throws IOException;

    public void notifyServerVersion(ProtocolVersion var1) throws IOException;

    public void notifySessionID(byte[] var1);

    public void notifySelectedCipherSuite(int var1);

    public void processServerExtensions(Hashtable var1) throws IOException;

    public void processServerSupplementalData(Vector var1) throws IOException;

    public TlsPSKIdentity getPSKIdentity() throws IOException;

    public TlsSRPIdentity getSRPIdentity() throws IOException;

    public TlsDHGroupVerifier getDHGroupVerifier() throws IOException;

    public TlsSRPConfigVerifier getSRPConfigVerifier() throws IOException;

    public TlsAuthentication getAuthentication() throws IOException;

    public Vector getClientSupplementalData() throws IOException;

    public void notifyNewSessionTicket(NewSessionTicket var1) throws IOException;
}

