/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class FipsUtils {
    private static final boolean provAllowRSAKeyExchange = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.fips.allowRSAKeyExchange", true);
    private static final boolean canSupportGCM = FipsUtils.lookup("org.bouncycastle.crypto.fips.FipsNonceGenerator") != null;
    private static final Set<String> FIPS_SUPPORTED_CIPHERSUITES = FipsUtils.createFipsSupportedCipherSuites();

    FipsUtils() {
    }

    private static Set<String> createFipsSupportedCipherSuites() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA");
        hashSet.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA");
        hashSet.add("TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA");
        hashSet.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA");
        hashSet.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA");
        hashSet.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA");
        hashSet.add("TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA");
        hashSet.add("TLS_DHE_DSS_WITH_AES_128_CBC_SHA");
        hashSet.add("TLS_DHE_DSS_WITH_AES_256_CBC_SHA");
        hashSet.add("TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA");
        hashSet.add("TLS_DH_DSS_WITH_AES_128_CBC_SHA");
        hashSet.add("TLS_DH_DSS_WITH_AES_256_CBC_SHA");
        hashSet.add("TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA");
        hashSet.add("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA");
        hashSet.add("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA");
        hashSet.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256");
        if (canSupportGCM) {
            hashSet.add("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256");
            hashSet.add("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384");
        }
        hashSet.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256");
        if (canSupportGCM) {
            hashSet.add("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        }
        hashSet.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384");
        hashSet.add("TLS_DHE_DSS_WITH_AES_128_CBC_SHA256");
        hashSet.add("TLS_DHE_DSS_WITH_AES_256_CBC_SHA256");
        if (canSupportGCM) {
            hashSet.add("TLS_DHE_DSS_WITH_AES_128_GCM_SHA256");
            hashSet.add("TLS_DHE_DSS_WITH_AES_256_GCM_SHA384");
        }
        hashSet.add("TLS_DH_DSS_WITH_AES_128_CBC_SHA256");
        hashSet.add("TLS_DH_DSS_WITH_AES_256_CBC_SHA256");
        if (canSupportGCM) {
            hashSet.add("TLS_DH_DSS_WITH_AES_128_GCM_SHA256");
            hashSet.add("TLS_DH_DSS_WITH_AES_256_GCM_SHA384");
        }
        hashSet.add("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256");
        hashSet.add("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384");
        if (canSupportGCM) {
            hashSet.add("TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256");
            hashSet.add("TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384");
        }
        if (provAllowRSAKeyExchange) {
            hashSet.add("TLS_RSA_WITH_3DES_EDE_CBC_SHA");
            hashSet.add("TLS_RSA_WITH_AES_128_CBC_SHA");
            if (canSupportGCM) {
                hashSet.add("TLS_RSA_WITH_AES_128_GCM_SHA256");
            }
            hashSet.add("TLS_RSA_WITH_AES_256_CBC_SHA");
            if (canSupportGCM) {
                hashSet.add("TLS_RSA_WITH_AES_256_GCM_SHA384");
            }
            hashSet.add("TLS_RSA_WITH_AES_128_CBC_SHA256");
            hashSet.add("TLS_RSA_WITH_AES_256_CBC_SHA256");
            hashSet.add("TLS_RSA_WITH_AES_128_CCM");
            hashSet.add("TLS_RSA_WITH_AES_256_CCM");
        }
        return Collections.unmodifiableSet(hashSet);
    }

    static int getFipsDefaultDH(int n) {
        return n <= 2048 ? 256 : (n <= 3072 ? 257 : (n <= 4096 ? 258 : (n <= 6144 ? 259 : (n <= 8192 ? 260 : -1))));
    }

    static int getFipsDefaultECDH(int n) {
        return n <= 256 ? 23 : (n <= 384 ? 24 : -1);
    }

    static int getFipsMaximumCurveBits() {
        return 384;
    }

    static int getFipsMaximumFiniteFieldBits() {
        return 8192;
    }

    static boolean isFipsCipherSuite(String string) {
        return string != null && FIPS_SUPPORTED_CIPHERSUITES.contains(string);
    }

    static boolean isFipsNamedGroup(int n) {
        switch (n) {
            case 23: 
            case 24: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: {
                return true;
            }
        }
        return false;
    }

    static void removeNonFipsCipherSuites(Collection<String> collection) {
        collection.retainAll(FIPS_SUPPORTED_CIPHERSUITES);
    }

    private static Class lookup(String string) {
        try {
            Class<?> clazz = ProvSSLContextSpi.class.getClassLoader().loadClass(string);
            return clazz;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

