/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLSessionImpl;
import org.bouncycastle.tls.SessionID;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.crypto.TlsCrypto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvSSLSessionContext
implements SSLSessionContext {
    private static Logger LOG = Logger.getLogger(ProvSSLSessionContext.class.getName());
    private static final int provSessionCacheSize = PropertyUtils.getIntegerSystemProperty("javax.net.ssl.sessionCacheSize", 0, 0, Integer.MAX_VALUE);
    protected final Map<SessionID, SessionEntry> sessionsByID = new LinkedHashMap<SessionID, SessionEntry>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<SessionID, SessionEntry> entry) {
            boolean bl;
            boolean bl2 = bl = ProvSSLSessionContext.this.sessionCacheSize > 0 && this.size() > ProvSSLSessionContext.this.sessionCacheSize;
            if (bl) {
                ProvSSLSessionContext.this.removeSessionByPeer(entry.getValue());
            }
            return bl;
        }
    };
    protected final Map<String, SessionEntry> sessionsByPeer = new HashMap<String, SessionEntry>();
    protected final ReferenceQueue<ProvSSLSessionImpl> sessionsQueue = new ReferenceQueue();
    protected final ProvSSLContextSpi sslContext;
    protected final TlsCrypto crypto;
    protected int sessionCacheSize = provSessionCacheSize;
    protected int sessionTimeoutSeconds = 86400;

    ProvSSLSessionContext(ProvSSLContextSpi provSSLContextSpi, TlsCrypto tlsCrypto) {
        this.sslContext = provSSLContextSpi;
        this.crypto = tlsCrypto;
    }

    ProvSSLContextSpi getSSLContext() {
        return this.sslContext;
    }

    TlsCrypto getCrypto() {
        return this.crypto;
    }

    synchronized ProvSSLSessionImpl getSessionImpl(byte[] byArray) {
        this.processQueue();
        return this.accessSession(ProvSSLSessionContext.mapGet(this.sessionsByID, ProvSSLSessionContext.makeSessionID(byArray)));
    }

    synchronized ProvSSLSessionImpl getSessionImpl(String string, int n) {
        this.processQueue();
        SessionEntry sessionEntry = ProvSSLSessionContext.mapGet(this.sessionsByPeer, ProvSSLSessionContext.makePeerKey(string, n));
        ProvSSLSessionImpl provSSLSessionImpl = this.accessSession(sessionEntry);
        if (provSSLSessionImpl != null) {
            this.sessionsByID.get(sessionEntry.getSessionID());
        }
        return provSSLSessionImpl;
    }

    synchronized ProvSSLSessionImpl reportSession(TlsSession tlsSession, String string, int n) {
        ProvSSLSessionImpl provSSLSessionImpl;
        this.processQueue();
        SessionID sessionID = new SessionID(tlsSession.getSessionID());
        SessionEntry sessionEntry = this.sessionsByID.get(sessionID);
        ProvSSLSessionImpl provSSLSessionImpl2 = provSSLSessionImpl = sessionEntry == null ? null : (ProvSSLSessionImpl)sessionEntry.get();
        if (provSSLSessionImpl == null || provSSLSessionImpl.getTlsSession() != tlsSession) {
            provSSLSessionImpl = new ProvSSLSessionImpl(this, tlsSession, string, n);
            sessionEntry = new SessionEntry(sessionID, provSSLSessionImpl, this.sessionsQueue);
            this.sessionsByID.put(sessionID, sessionEntry);
        }
        ProvSSLSessionContext.mapAdd(this.sessionsByPeer, sessionEntry.getPeerKey(), sessionEntry);
        return provSSLSessionImpl;
    }

    @Override
    public synchronized Enumeration<byte[]> getIds() {
        this.removeAllExpiredSessions();
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(this.sessionsByID.size());
        for (SessionID sessionID : this.sessionsByID.keySet()) {
            arrayList.add(sessionID.getBytes());
        }
        return Collections.enumeration(arrayList);
    }

    @Override
    public SSLSession getSession(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("'sessionID' cannot be null");
        }
        return this.getSessionImpl(byArray);
    }

    @Override
    public synchronized int getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    @Override
    public synchronized int getSessionTimeout() {
        return this.sessionTimeoutSeconds;
    }

    @Override
    public synchronized void setSessionCacheSize(int n) throws IllegalArgumentException {
        int n2;
        if (this.sessionCacheSize == n) {
            return;
        }
        if (n < 0) {
            throw new IllegalArgumentException("'size' cannot be < 0");
        }
        this.sessionCacheSize = n;
        this.removeAllExpiredSessions();
        if (this.sessionCacheSize > 0 && (n2 = this.sessionsByID.size()) > this.sessionCacheSize) {
            Iterator<SessionEntry> iterator = this.sessionsByID.values().iterator();
            while (iterator.hasNext() && n2 > this.sessionCacheSize) {
                SessionEntry sessionEntry = iterator.next();
                iterator.remove();
                this.removeSessionByPeer(sessionEntry);
                --n2;
            }
        }
    }

    @Override
    public synchronized void setSessionTimeout(int n) throws IllegalArgumentException {
        if (this.sessionTimeoutSeconds == n) {
            return;
        }
        if (n < 0) {
            throw new IllegalArgumentException("'seconds' cannot be < 0");
        }
        this.sessionTimeoutSeconds = n;
        this.removeAllExpiredSessions();
    }

    private ProvSSLSessionImpl accessSession(SessionEntry sessionEntry) {
        if (sessionEntry != null) {
            long l;
            ProvSSLSessionImpl provSSLSessionImpl = (ProvSSLSessionImpl)sessionEntry.get();
            if (provSSLSessionImpl != null && !this.invalidateIfCreatedBefore(sessionEntry, this.getCreationTimeLimit(l = System.currentTimeMillis()))) {
                provSSLSessionImpl.accessedAt(l);
                return provSSLSessionImpl;
            }
            this.removeSession(sessionEntry);
        }
        return null;
    }

    private long getCreationTimeLimit(long l) {
        return this.sessionTimeoutSeconds < 1 ? Long.MIN_VALUE : l - 1000L * (long)this.sessionTimeoutSeconds;
    }

    private boolean invalidateIfCreatedBefore(SessionEntry sessionEntry, long l) {
        ProvSSLSessionImpl provSSLSessionImpl = (ProvSSLSessionImpl)sessionEntry.get();
        if (provSSLSessionImpl == null) {
            return true;
        }
        if (provSSLSessionImpl.getCreationTime() < l) {
            provSSLSessionImpl.invalidate();
        }
        return !provSSLSessionImpl.isValid();
    }

    private void processQueue() {
        SessionEntry sessionEntry;
        int n = 0;
        while ((sessionEntry = (SessionEntry)this.sessionsQueue.poll()) != null) {
            this.removeSession(sessionEntry);
            ++n;
        }
        if (n > 0) {
            LOG.fine("Processed " + n + " session entries (soft references) from the reference queue");
        }
    }

    private void removeAllExpiredSessions() {
        this.processQueue();
        long l = this.getCreationTimeLimit(System.currentTimeMillis());
        Iterator<SessionEntry> iterator = this.sessionsByID.values().iterator();
        while (iterator.hasNext()) {
            SessionEntry sessionEntry = iterator.next();
            if (!this.invalidateIfCreatedBefore(sessionEntry, l)) continue;
            iterator.remove();
            this.removeSessionByPeer(sessionEntry);
        }
    }

    private void removeSession(SessionEntry sessionEntry) {
        ProvSSLSessionContext.mapRemove(this.sessionsByID, sessionEntry.getSessionID(), sessionEntry);
        this.removeSessionByPeer(sessionEntry);
    }

    private boolean removeSessionByPeer(SessionEntry sessionEntry) {
        return ProvSSLSessionContext.mapRemove(this.sessionsByPeer, sessionEntry.getPeerKey(), sessionEntry);
    }

    private static String makePeerKey(ProvSSLSessionImpl provSSLSessionImpl) {
        return provSSLSessionImpl == null ? null : ProvSSLSessionContext.makePeerKey(provSSLSessionImpl.getPeerHost(), provSSLSessionImpl.getPeerPort());
    }

    private static String makePeerKey(String string, int n) {
        return string == null || n < 0 ? null : (string + ':' + Integer.toString(n)).toLowerCase(Locale.ENGLISH);
    }

    private static SessionID makeSessionID(byte[] byArray) {
        return byArray == null || byArray.length < 1 ? null : new SessionID(byArray);
    }

    private static <K, V> void mapAdd(Map<K, V> map, K k, V v) {
        if (map == null || v == null) {
            throw new NullPointerException();
        }
        if (k != null) {
            map.put(k, v);
        }
    }

    private static <K, V> V mapGet(Map<K, V> map, K k) {
        if (map == null) {
            throw new NullPointerException();
        }
        return k == null ? null : (V)map.get(k);
    }

    private static <K, V> boolean mapRemove(Map<K, V> map, K k, V v) {
        if (map == null || v == null) {
            throw new NullPointerException();
        }
        if (k != null) {
            V v2 = map.remove(k);
            if (v2 == v) {
                return true;
            }
            if (v2 != null) {
                map.put(k, v2);
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SessionEntry
    extends SoftReference<ProvSSLSessionImpl> {
        private final SessionID sessionID;
        private final String peerKey;

        SessionEntry(SessionID sessionID, ProvSSLSessionImpl provSSLSessionImpl, ReferenceQueue<ProvSSLSessionImpl> referenceQueue) {
            super(provSSLSessionImpl, referenceQueue);
            if (sessionID == null || provSSLSessionImpl == null || referenceQueue == null) {
                throw new NullPointerException();
            }
            this.sessionID = sessionID;
            this.peerKey = ProvSSLSessionContext.makePeerKey(provSSLSessionImpl);
        }

        public String getPeerKey() {
            return this.peerKey;
        }

        public SessionID getSessionID() {
            return this.sessionID;
        }
    }
}

