/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.DropdownListComponent;
import com.install4j.runtime.beans.formcomponents.TextComponentUtil;
import com.install4j.runtime.installer.helper.InstallerUtil;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ComboboxComponent
extends DropdownListComponent
implements TextComponentUtil.InputVerifierParameterProvider {
    private ScriptProperty inputVerifier;

    public ScriptProperty getInputVerifier() {
        return this.inputVerifier;
    }

    public void setInputVerifier(ScriptProperty inputVerifier) {
        this.inputVerifier = inputVerifier;
    }

    @Override
    protected void applyComboBoxProperties(JComboBox comboBox) {
        super.applyComboBoxProperties(comboBox);
        comboBox.setEditable(true);
        Object varValue = this.getContext().getVariable(this.getVariableName());
        if (varValue instanceof String) {
            comboBox.setSelectedItem(varValue);
        }
        TextComponentUtil.addInputVerifier(this, this.inputVerifier, (JComponent)comboBox.getEditor().getEditorComponent(), this);
    }

    @Override
    public boolean checkCompleted() {
        final JComboBox<String> comboBox = this.getComboBox();
        InputVerifier inputVerifier = ((JComponent)comboBox.getEditor().getEditorComponent()).getInputVerifier();
        if (inputVerifier != null && !inputVerifier.verify(comboBox)) {
            if (!InstallerUtil.isUnattended() && !InstallerUtil.isConsole()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ComboboxComponent.this.getFormEnvironment().makeParentGroupVisible(ComboboxComponent.this);
                        comboBox.requestFocus();
                    }
                });
            }
            return false;
        }
        this.getContext().setVariable(this.getVariableName(), this.getComboBox().getSelectedItem().toString());
        this.getContext().registerResponseFileVariable(this.getVariableName());
        return true;
    }

    @Override
    protected boolean getInitialFillHorizontal() {
        return true;
    }

    @Override
    public Object[] createInputVerifierParameters() {
        return new Object[]{this.getFormEnvironment(), this.getComboBox().getEditor().getItem()};
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        JComboBox<String> comboBox = this.getComboBox();
        InputVerifier inputVerifier = ((JComponent)comboBox.getEditor().getEditorComponent()).getInputVerifier();
        Object oldValue = comboBox.getSelectedItem();
        do {
            comboBox.setSelectedItem(oldValue);
            String newValue = console.askString(this.getConsoleLabelText(false), oldValue == null ? null : oldValue.toString());
            comboBox.setSelectedItem(newValue);
        } while (inputVerifier != null && !inputVerifier.verify(comboBox));
        return true;
    }
}

