/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.api.Util;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

public class StringUtil {
    private StringUtil() {
    }

    public static String repeat(String string, int count) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            buffer.append(string);
        }
        return buffer.toString();
    }

    public static String replace(String string, String pattern, String replace) {
        int endIndex;
        int startIndex = 0;
        StringBuilder result = new StringBuilder();
        while ((endIndex = string.indexOf(pattern, startIndex)) >= 0) {
            result.append(string.substring(startIndex, endIndex));
            result.append(replace);
            startIndex = endIndex + pattern.length();
        }
        result.append(string.substring(startIndex));
        return result.toString();
    }

    public static String replaceVariable(String string, String startPattern, String endPattern, ReplacementCallback replacementCallback) {
        return StringUtil.replaceVariable(string, startPattern, endPattern, replacementCallback, null);
    }

    public static String replaceVariable(String string, String startPattern, String endPattern, ReplacementCallback replacementCallback, Object memento) {
        int endIndex;
        int variableIndex;
        int startIndex = 0;
        StringBuilder result = new StringBuilder();
        while ((variableIndex = string.indexOf(startPattern, startIndex)) >= 0 && (endIndex = string.indexOf(endPattern, variableIndex + 1)) >= 0) {
            int nextVariableIndex = string.indexOf(startPattern, variableIndex + 1);
            if (nextVariableIndex > -1 && nextVariableIndex < endIndex) {
                result.append(string.substring(startIndex, nextVariableIndex));
                startIndex = nextVariableIndex;
                continue;
            }
            String variable = string.substring(variableIndex + startPattern.length(), endIndex);
            String replacement = replacementCallback.getReplacement(variable, memento);
            if (replacement == null) {
                result.append(string.substring(startIndex, endIndex + endPattern.length()));
            } else {
                result.append(string.substring(startIndex, variableIndex));
                result.append(replacement);
            }
            startIndex = endIndex + endPattern.length();
        }
        result.append(string.substring(startIndex));
        String resultString = result.toString();
        if (!string.equals(resultString) && resultString.contains(startPattern)) {
            return StringUtil.replaceVariable(resultString, startPattern, endPattern, replacementCallback, memento);
        }
        return resultString;
    }

    public static void splitupCommandLine(List<String> cmdList, String command) {
        StringUtil.splitupQuotedList(cmdList, command, " ");
    }

    public static void splitupQuotedList(List<String> list, String line, String delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(line, delimiter + "\"", true);
        boolean insideQuotes = false;
        StringBuilder argument = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("\"")) {
                if (insideQuotes && argument.length() > 0) {
                    list.add(argument.toString());
                    argument.setLength(0);
                }
                insideQuotes = !insideQuotes;
                continue;
            }
            if (delimiter.contains(token)) {
                if (insideQuotes) {
                    argument.append(delimiter);
                    continue;
                }
                if (argument.length() <= 0) continue;
                list.add(argument.toString());
                argument.setLength(0);
                continue;
            }
            argument.append(token);
        }
        if (argument.length() > 0) {
            list.add(argument.toString());
        }
    }

    public static String trimLineSeparators(String text) {
        return StringUtil.trimPattern(StringUtil.trimPattern(text, "\n"), "\r\n");
    }

    private static String trimPattern(String text, String pattern) {
        if (text.length() < pattern.length()) {
            return text;
        }
        int firstPosition = 0;
        int patternLength = pattern.length();
        while (text.substring(firstPosition, firstPosition + patternLength).equals(pattern)) {
            firstPosition += patternLength;
        }
        int lastPosition = text.length();
        if (firstPosition + patternLength == lastPosition) {
            return "";
        }
        while (text.substring(lastPosition - patternLength, lastPosition).equals(pattern)) {
            lastPosition -= patternLength;
        }
        return text.substring(firstPosition, lastPosition);
    }

    public static String padLeft(String val, char padChar, int length) {
        StringBuilder buffer = new StringBuilder(length);
        for (int i = 0; i < length - val.length(); ++i) {
            buffer.append(padChar);
        }
        buffer.append(val.substring(0, Math.min(length, val.length())));
        return buffer.toString();
    }

    public static String padRight(String val, char padChar, int length) {
        StringBuilder buffer = new StringBuilder(length);
        buffer.append(val.substring(0, Math.min(length, val.length())));
        for (int i = 0; i < length - val.length(); ++i) {
            buffer.append(padChar);
        }
        return buffer.toString();
    }

    public static String makeCommandLine(String[] commands) {
        if (commands == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (String command : commands) {
            buffer.append('\"');
            buffer.append(command);
            buffer.append('\"');
            buffer.append(' ');
        }
        return buffer.toString();
    }

    public static String replaceHomeDir(String fileName) {
        if (fileName.startsWith("~")) {
            fileName = Util.getUserHome() + fileName.substring(1);
        }
        return fileName;
    }

    public static String toStringWithArrays(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            Class<?> c = object.getClass();
            if (c == byte[].class) {
                return Arrays.toString((byte[])object);
            }
            if (c == short[].class) {
                return Arrays.toString((short[])object);
            }
            if (c == int[].class) {
                return Arrays.toString((int[])object);
            }
            if (c == long[].class) {
                return Arrays.toString((long[])object);
            }
            if (c == char[].class) {
                return Arrays.toString((char[])object);
            }
            if (c == float[].class) {
                return Arrays.toString((float[])object);
            }
            if (c == double[].class) {
                return Arrays.toString((double[])object);
            }
            if (c == boolean[].class) {
                return Arrays.toString((boolean[])object);
            }
            return Arrays.toString((Object[])object);
        }
        return object.toString();
    }

    public static String formatTextWithoutHtmlTags(String s) {
        if (s.contains("<html")) {
            return StringUtil.convertHtmlToText(s);
        }
        return s;
    }

    private static String convertHtmlToText(String html) {
        final StringBuffer textBuffer = new StringBuffer();
        final Stack tagStack = new Stack();
        HTMLEditorKit.ParserCallback parserCallback = new HTMLEditorKit.ParserCallback(){

            @Override
            public void handleStartTag(HTML.Tag tag, MutableAttributeSet a, int pos) {
                if (tag.equals(HTML.Tag.TITLE)) {
                    tagStack.push(new IndentedTag(tag, 0));
                } else if (tag.equals(HTML.Tag.P) || tag.equals(HTML.Tag.H1) || tag.equals(HTML.Tag.H2) || tag.equals(HTML.Tag.H3) || tag.equals(HTML.Tag.H4) || tag.equals(HTML.Tag.H5) || tag.equals(HTML.Tag.H6) || tag.equals(HTML.Tag.TH) || tag.equals(HTML.Tag.TR)) {
                    if (textBuffer.length() > 0 && textBuffer.charAt(textBuffer.length() - 1) != '\n') {
                        this.newLine();
                    }
                    this.newLine();
                } else if (tag.equals(HTML.Tag.DL) || tag.equals(HTML.Tag.DT)) {
                    this.newLine();
                } else if (tag.equals(HTML.Tag.OL) || tag.equals(HTML.Tag.UL) || tag.equals(HTML.Tag.BLOCKQUOTE) || tag.equals(HTML.Tag.DD)) {
                    tagStack.push(new IndentedTag(tag));
                    this.newLine();
                } else if (tag.equals(HTML.Tag.LI)) {
                    IndentedTag parent = (IndentedTag)tagStack.peek();
                    if (parent.getTag().equals(HTML.Tag.OL)) {
                        String order = parent.nextOrder() + ".";
                        textBuffer.append(order);
                        for (int i = 0; i < 3 - order.length(); ++i) {
                            textBuffer.append("\u00a0");
                        }
                    } else {
                        textBuffer.append("*\u00a0\u00a0");
                    }
                    tagStack.push(new IndentedTag(tag));
                }
            }

            private void newLine() {
                textBuffer.append('\n');
                for (IndentedTag indentedTag : tagStack) {
                    for (int j = 0; j < indentedTag.getIndentation(); ++j) {
                        textBuffer.append("\u00a0");
                    }
                }
            }

            @Override
            public void handleEndTag(HTML.Tag tag, int pos) {
                if (tag.equals(HTML.Tag.P) || tag.equals(HTML.Tag.H1) || tag.equals(HTML.Tag.H2) || tag.equals(HTML.Tag.H3) || tag.equals(HTML.Tag.H4) || tag.equals(HTML.Tag.H5) || tag.equals(HTML.Tag.H6) || tag.equals(HTML.Tag.TH) || tag.equals(HTML.Tag.TR)) {
                    this.newLine();
                }
                if (tag.equals(HTML.Tag.TD)) {
                    textBuffer.append("\u00a0");
                } else if (tag.equals(HTML.Tag.OL) || tag.equals(HTML.Tag.UL) || tag.equals(HTML.Tag.LI) || tag.equals(HTML.Tag.BLOCKQUOTE)) {
                    tagStack.pop();
                    this.newLine();
                } else if (tag.equals(HTML.Tag.DD) || tag.equals(HTML.Tag.TITLE)) {
                    tagStack.pop();
                }
            }

            @Override
            public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet a, int pos) {
                if (tag.equals(HTML.Tag.BR)) {
                    this.newLine();
                }
            }

            @Override
            public void handleText(char[] text, int pos) {
                if (tagStack.size() == 0 || ((IndentedTag)tagStack.peek()).getTag() != HTML.Tag.TITLE) {
                    textBuffer.append(text);
                }
            }
        };
        StringReader in = new StringReader(html);
        ParserDelegator delegator = new ParserDelegator();
        try {
            delegator.parse(in, parserCallback, true);
            return textBuffer.toString();
        }
        catch (IOException ex) {
            return html;
        }
    }

    private static class IndentedTag {
        private HTML.Tag tag;
        private int indentation;
        private int order;

        public IndentedTag(HTML.Tag tag) {
            this.tag = tag;
            this.order = 0;
        }

        public IndentedTag(HTML.Tag tag, int indentation) {
            this.tag = tag;
            this.indentation = indentation;
            this.order = 0;
        }

        public int nextOrder() {
            return ++this.order;
        }

        public HTML.Tag getTag() {
            return this.tag;
        }

        public int getIndentation() {
            return this.indentation;
        }
    }

    public static interface ReplacementCallback {
        public String getReplacement(String var1, Object var2);
    }
}

