/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.versionspecific;

import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.installer.helper.content.ProxyHelper;
import com.install4j.runtime.installer.helper.versionspecific.ConsoleAccess;
import com.install4j.runtime.installer.helper.versionspecific.NoHelper;
import com.install4j.runtime.installer.helper.versionspecific.ProxyHostInfo;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelperInterface;
import com.install4j.runtime.util.VersionCheck;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;

public abstract class VersionSpecificHelper {
    private static VersionSpecificHelperInterface helper;
    private static final String JAVA7_CLASS_NAME = "com.install4j.runtime.installer.helper.versionspecific.Java17Helper";
    private static ConsoleAccess consoleAccess;

    public static boolean isJava7Helper() {
        return helper.getClass().getName().equals(JAVA7_CLASS_NAME);
    }

    public static ProxyHostInfo getProxyHostInfo(URL url) {
        return ProxyHelper.getProxyHostInfo(url);
    }

    public static ConsoleAccess getConsoleAccess() {
        if (consoleAccess == null) {
            consoleAccess = helper.createConsoleAccess();
        }
        return consoleAccess;
    }

    public static boolean isSymbolicLink(File file) {
        return helper.isSymbolicLink(file);
    }

    public static File getSymbolicLinkTargetFile(File file) throws IOException {
        return helper.getSymbolicLinkTargetFile(file);
    }

    public static boolean createSymbolicLink(File symLink, File target) {
        try {
            helper.createSymbolicLink(symLink, target);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static String getPosixFilePermissions(File file) throws IOException {
        return helper.getPosixFilePermissions(file);
    }

    public static boolean setPosixFilePermissions(File file, String mode) {
        try {
            helper.setPosixFilePermissions(file, mode);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean setPosixFilePermissionsRecursive(File dir, String mode) {
        try {
            helper.setPosixFilePermissionsRecursive(dir, mode);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean setOwner(File file, String userAndGroup) {
        try {
            helper.setOwner(file, userAndGroup);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static TransformerFactory createTransformerFactory() {
        return helper.createTransformerFactory();
    }

    public static DocumentBuilderFactory createDocumentBuilderFactory() {
        return helper.createDocumentBuilderFactory();
    }

    public static UnixFileSystem.FileInformation getFileInformation(File file) throws IOException {
        return helper.getFileInformation(file);
    }

    public static void disablePreferencesLogging() {
        helper.disablePreferencesLogging();
    }

    static {
        String className = null;
        if (VersionCheck.checkCompatible("1.7", System.getProperty("java.version"))) {
            className = JAVA7_CLASS_NAME;
        } else {
            helper = new NoHelper();
        }
        if (className == null) {
            helper = new NoHelper();
        } else {
            try {
                helper = (VersionSpecificHelperInterface)Class.forName(className).newInstance();
            }
            catch (Throwable e) {
                helper = new NoHelper();
            }
        }
    }
}

