/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.Util;
import com.install4j.api.beans.Anchor;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.WizardContext;
import com.install4j.api.context.WizardIndex;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.beans.screens.ProgressScreen;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ActionCallback;
import com.install4j.runtime.installer.controller.CommandSink;
import com.install4j.runtime.installer.controller.ControllerCommand;
import com.install4j.runtime.installer.controller.GoBackCommand;
import com.install4j.runtime.installer.controller.GoBackInHistoryToScreenCommand;
import com.install4j.runtime.installer.controller.ReturnToken;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.FormPanel;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.GUIProgressInterface;
import com.install4j.runtime.installer.frontend.LanguageSelectionDialog;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.RollbackProgressInterface;
import com.install4j.runtime.installer.frontend.ScreenEnvelope;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.wizard.WizardBase;
import com.install4j.runtime.wizard.WizardScreen;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public abstract class WizardScreenExecutor
extends WizardBase
implements ScreenExecutor,
WizardContext {
    private GUIProgressInterface defaultProgressInterface;
    private RollbackProgressInterface rollbackProgressInterface;
    private ScreenEnvelope screenEnvelope;
    private CommandSink commandSink;
    private WizardIndex wizardIndex;
    private String wizardIndexKey;
    private Map<Screen, WizardIndexAndKey> cachedWizardIndexKeys = new HashMap<Screen, WizardIndexAndKey>();
    private boolean dialog;
    private Window parentWindow;

    public WizardScreenExecutor(boolean dialog, Window parentWindow) {
        super("");
        this.dialog = dialog;
        this.parentWindow = parentWindow;
        this.initAWT();
        this.defaultProgressInterface = new GUIProgressInterface();
        FileInstaller.getInstance().setDefaultProgressInterface(this.defaultProgressInterface);
        if (Util.isMacOS() && !InstallerUtil.isInProcess()) {
            try {
                Class.forName("com.install4j.runtime.installer.platform.macos.MacEventHandler").getMethod("init", WizardScreenExecutor.class).invoke(null, this);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public abstract String getWindowTitle();

    protected abstract Icon getDefaultHeaderIcon();

    protected String getCustomHeaderIconFileName() {
        ExternalFile file = InstallerConfig.getCurrentApplication().getCustomHeaderImage();
        if (file == null || file.getPath().length() == 0) {
            return null;
        }
        return file.getPath();
    }

    protected boolean isHeaderIconOverlap() {
        return InstallerConfig.getCurrentApplication().isHeaderIconOverlap() && this.getCustomHeaderIconFileName() != null;
    }

    protected Anchor getHeaderIconAnchor() {
        return InstallerConfig.getCurrentApplication().getHeaderIconAnchor();
    }

    @Override
    public void setNextButtonEnabled(boolean enabled) {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.setNextButtonEnabled(enabled);
        }
    }

    @Override
    public void setBackButtonEnabled(boolean enabled) {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.setPreviousButtonEnabled(enabled);
        }
    }

    @Override
    public void setCancelButtonEnabled(boolean enabled) {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.setCancelButtonEnabled(enabled);
        }
    }

    @Override
    public void setNextButtonVisible(boolean enabled) {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.setNextButtonVisible(enabled);
        }
    }

    @Override
    public void setBackButtonVisible(boolean enabled) {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.setPreviousButtonVisible(enabled);
        }
    }

    @Override
    public void setCancelButtonVisible(boolean enabled) {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.setCancelButtonVisible(enabled);
        }
    }

    @Override
    public void pressNextButton() {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.doNext();
        }
    }

    @Override
    public void pressPreviousButton() {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.doPrevious();
        }
    }

    @Override
    public void pressCancelButton() {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.doCancel();
        }
    }

    @Override
    public void focusNextButton() {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.focusNextButton();
        }
    }

    @Override
    public void setNextButtonText(String text) {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.setNextButtonText(text);
        }
    }

    @Override
    public void setPreviousButtonText(String text) {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.setPreviousButtonText(text);
        }
    }

    @Override
    public void setCancelButtonText(String text) {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.setCancelButtonText(text);
        }
    }

    public WizardIndex getWizardIndex() {
        return this.wizardIndex;
    }

    @Override
    public void setWizardIndex(WizardIndex wizardIndex) {
        this.wizardIndex = wizardIndex;
        this.wizardIndexKey = wizardIndex == null ? null : wizardIndex.getInitialKey();
    }

    @Override
    public void setWizardIndexKey(String key) {
        this.wizardIndexKey = key;
    }

    public String getWizardIndexKey() {
        return this.wizardIndexKey;
    }

    @Override
    public void register(final Screen screen, final ScreenBeanConfig config) {
        this.getContext().applyToScreen(screen, config);
        GUIHelper.invokeOnEDT(new Runnable(){

            @Override
            public void run() {
                WizardScreenExecutor.this.registerScreen(new ScreenEnvelope(WizardScreenExecutor.this, screen, config));
            }
        });
    }

    @Override
    public void execute(ScreenBeanConfig screenConfig, CommandSink commandSink, boolean previousPossible, ControllerCommand lastCommand) {
        Screen screen = screenConfig.getOrInstantiateScreen(false);
        if ((lastCommand instanceof GoBackCommand || lastCommand instanceof GoBackInHistoryToScreenCommand) && this.cachedWizardIndexKeys.containsKey(screen)) {
            WizardIndexAndKey wizardIndexAndKey = this.cachedWizardIndexKeys.get(screen);
            this.wizardIndex = wizardIndexAndKey.wizardIndex;
            this.wizardIndexKey = wizardIndexAndKey.key;
        }
        this.setCommandSink(commandSink);
        for (WizardScreen wizardScreen : this.getScreens()) {
            ScreenEnvelope screenEnvelope = (ScreenEnvelope)wizardScreen;
            if (screenEnvelope.getScreen() != screen) continue;
            if (this.screenEnvelope != null) {
                this.screenEnvelope.getScreen().deactivated();
            }
            this.screenEnvelope = screenEnvelope;
            if (!previousPossible) {
                screenEnvelope.setPreviousButtonVisible(false);
            }
            this.setScreen(screenEnvelope);
            if (!this.isShowing()) {
                if (this.dialog) {
                    this.showDialog(this.parentWindow);
                } else {
                    this.showFrame(null);
                }
            }
            return;
        }
        throw new RuntimeException("screen not registered " + screen.toString());
    }

    public void cacheWizardIndexAndKey(Screen screen) {
        this.cachedWizardIndexKeys.put(screen, new WizardIndexAndKey(this.wizardIndex, this.wizardIndexKey));
    }

    @Override
    public CommandSink getCommandSink() {
        return this.commandSink;
    }

    @Override
    public void setCommandSink(CommandSink commandSink) {
        this.commandSink = commandSink;
    }

    @Override
    public ProgressInterface getProgressInterface() {
        if (this.rollbackProgressInterface != null) {
            return this.rollbackProgressInterface;
        }
        if (this.screenEnvelope != null) {
            ProgressInterface formPanelProgressInterface;
            FormPanel formPanel = this.screenEnvelope.getFormPanel();
            if (formPanel != null && (formPanelProgressInterface = formPanel.findProgressInterface()) != null) {
                return formPanelProgressInterface;
            }
            return this.screenEnvelope.getScreen().getProgressInterface(this.defaultProgressInterface);
        }
        return this.defaultProgressInterface;
    }

    @Override
    public ProgressInterface getDefaultProgressInterface() {
        return this.defaultProgressInterface;
    }

    @Override
    public WizardContext getWizardContext() {
        return this;
    }

    @Override
    public void selectLanguage(ReturnToken returnToken) {
        new LanguageSelectionDialog(returnToken).setVisible(true);
    }

    @Override
    public boolean isUnattended() {
        return false;
    }

    @Override
    public boolean isConsole() {
        return false;
    }

    @Override
    protected int getFrameWidth() {
        String overridenWidth = this.getContext().getCompilerVariable("__internal.app." + InstallerConfig.getCurrentApplicationId() + ".width");
        if (overridenWidth != null) {
            return Integer.parseInt(overridenWidth);
        }
        return InstallerConfig.getCurrentApplication().getFrameWidth();
    }

    @Override
    protected int getFrameHeight() {
        String overridenHeight = this.getContext().getCompilerVariable("__internal.app." + InstallerConfig.getCurrentApplicationId() + ".height");
        if (overridenHeight != null) {
            return Integer.parseInt(overridenHeight);
        }
        return InstallerConfig.getCurrentApplication().getFrameHeight();
    }

    @Override
    protected boolean needsNextScreenOnVisible() {
        return false;
    }

    @Override
    protected void beforeShow(Window wizardWindow) {
        super.beforeShow(wizardWindow);
        if (wizardWindow instanceof JFrame) {
            JFrame frame = (JFrame)wizardWindow;
            frame.setTitle(this.getWindowTitle());
            frame.setResizable(InstallerConfig.getCurrentApplication().isResizable());
        } else {
            JDialog dialog = (JDialog)wizardWindow;
            dialog.setTitle(this.getWindowTitle());
            dialog.setResizable(InstallerConfig.getCurrentApplication().isResizable());
        }
    }

    @Override
    protected void beforeHide(Window wizardWindow) {
        super.beforeHide(wizardWindow);
        if (this.rollbackProgressInterface != null && this.rollbackProgressInterface.isVisible()) {
            this.rollbackProgressInterface.setVisible(false);
        }
    }

    @Override
    public boolean isSizeClientArea() {
        return InstallerConfig.getCurrentApplication().isFrameSizeClientArea();
    }

    @Override
    protected boolean isQuitOnWindowClose() {
        if (this.screenEnvelope == null) {
            return true;
        }
        return this.screenEnvelope.isCancelVisible() && this.screenEnvelope.isCancelButtonEnabled();
    }

    @Override
    public boolean isFinishOnWindowClose() {
        if (this.screenEnvelope == null) {
            return false;
        }
        return this.screenEnvelope.isFinishScreen();
    }

    @Override
    public void finishFromCloseButton() {
        this.screenEnvelope.doNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        ContextImpl.setAskingForCancel(true);
        try {
            if (GUIHelper.confirmCancel(this)) {
                this.screenEnvelope.setCancelButtonEnabled(false);
                ContextImpl.setCancelling();
                this.commandSink.returnToController(ControllerCommand.CANCEL);
            }
        }
        finally {
            ContextImpl.setAskingForCancel(false);
        }
    }

    @Override
    protected void setupComponent() {
        super.setupComponent();
        this.setMinimumSize(new Dimension(500, 300));
    }

    @Override
    public void setRollback() {
        if (this.screenEnvelope != null && this.screenEnvelope.getScreen() instanceof ProgressScreen) {
            ProgressInterface progressInterface = this.getProgressInterface();
            progressInterface.setIndeterminateProgress(false);
            progressInterface.setDetailMessage("");
            progressInterface.setStatusMessage(Messages.getMessages().getString("StatusRollback"));
            progressInterface.setPercentCompleted(0);
        } else if (this.rollbackProgressInterface == null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WizardScreenExecutor.this.rollbackProgressInterface = RollbackProgressInterface.create(WizardScreenExecutor.this.getWizardWindow());
                    WizardScreenExecutor.this.rollbackProgressInterface.setVisible(true);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void closeWindows() {
        this.finish();
    }

    @Override
    public ActionCallback getActionCallback() {
        return this.screenEnvelope;
    }

    @Override
    public void initializeLazilyLoadedScreens() {
        for (WizardScreen wizardScreen : this.getScreens()) {
            ((ScreenEnvelope)wizardScreen).initializeLazilyLoaded();
        }
    }

    public Color getHeaderBackgroundColor() {
        Color color = InstallerConfig.getCurrentApplication().getHeaderBackground();
        return color == null ? Color.WHITE : color;
    }

    public Color getHeaderForegroundColor() {
        return InstallerConfig.getCurrentApplication().getHeaderForeground();
    }

    public Icon getHeaderIcon() {
        try {
            ImageIcon headerIcon;
            String fileName = this.getCustomHeaderIconFileName();
            if (fileName != null && (headerIcon = GUIHelper.loadIcon(InstallerUtil.getInstallerFile(fileName))).getIconWidth() > 0) {
                return headerIcon;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getDefaultHeaderIcon();
    }

    private void initAWT() {
        if (SwingUtilities.isEventDispatchThread()) {
            new Button();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        new Button();
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getTargetException();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                e.printStackTrace();
            }
        }
    }

    public void disarmButtons() {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.disarmButtons();
        }
    }

    private static class WizardIndexAndKey {
        private WizardIndex wizardIndex;
        private String key;

        private WizardIndexAndKey(WizardIndex wizardIndex, String key) {
            this.wizardIndex = wizardIndex;
            this.key = key;
        }
    }
}

