/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config.update;

import com.install4j.api.update.UpdateDescriptor;
import com.install4j.api.update.UpdateDescriptorEntry;
import com.install4j.runtime.installer.config.AbstractConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.update.UpdateDescriptorEntryImpl;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.XmlHelper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UpdateDescriptorImpl
extends AbstractConfig
implements UpdateDescriptor {
    public static final String ELEMENT_UPDATE_DESCRIPTOR = "updateDescriptor";
    public static final String ATTRIBUTE_BASE_URL = "baseUrl";
    private UpdateDescriptorEntry[] entries;
    private String baseUrl = "";

    public UpdateDescriptorImpl(List<UpdateDescriptorEntryImpl> updateDescriptorEntries, String baseUrl) {
        this.baseUrl = baseUrl;
        this.entries = updateDescriptorEntries.toArray(new UpdateDescriptorEntry[updateDescriptorEntries.size()]);
    }

    public UpdateDescriptorImpl() {
    }

    @Override
    public UpdateDescriptorEntry[] getEntries() {
        return this.entries;
    }

    @Override
    public UpdateDescriptorEntry getPossibleUpdateEntry() {
        if (this.entries == null) {
            return null;
        }
        try {
            InstallerConfig config = InstallerConfig.getCurrentInstance();
            if (config == null) {
                config = InstallerConfig.getGeneralConfigFromFile(InstallerUtil.getInstallerFile("i4jparams.conf"));
            }
            String mediaSetId = config.getMediaSetId();
            String version = config.getApplicationVersion();
            for (UpdateDescriptorEntry entry : this.entries) {
                if (!entry.getTargetMediaFileId().equals(mediaSetId) || !entry.checkVersionCompatible(version)) continue;
                return entry;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void read(File file, URL descriptorUrl) throws IOException {
        URL folderURL;
        Document document = XmlHelper.parseFile(file);
        this.read(document.getDocumentElement());
        if (this.baseUrl.trim().length() > 0) {
            folderURL = new URL(this.baseUrl);
        } else {
            String path = descriptorUrl.getPath();
            int slashPos = path.lastIndexOf(47);
            if (slashPos > -1) {
                path = path.substring(0, slashPos + 1);
            }
            folderURL = new URL(descriptorUrl.getProtocol(), descriptorUrl.getHost(), descriptorUrl.getPort(), path);
        }
        for (UpdateDescriptorEntry entry : this.entries) {
            ((UpdateDescriptorEntryImpl)entry).setURL(new URL(folderURL, entry.getFileName()));
        }
    }

    @Override
    protected void read(Element element) {
        this.baseUrl = UpdateDescriptorImpl.readAttribute(element, ATTRIBUTE_BASE_URL, this.baseUrl);
        ArrayList<UpdateDescriptorEntryImpl> entryList = new ArrayList<UpdateDescriptorEntryImpl>();
        for (Element childElement : UpdateDescriptorImpl.childElements(element)) {
            UpdateDescriptorEntryImpl entry = new UpdateDescriptorEntryImpl();
            entry.read(childElement);
            entryList.add(entry);
        }
        this.entries = entryList.toArray(new UpdateDescriptorEntry[entryList.size()]);
    }
}

