/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.Util;
import com.install4j.runtime.beans.actions.InstallFilesAction;
import com.install4j.runtime.beans.actions.desktop.CreateFileAssociationAction;
import com.install4j.runtime.beans.screens.ChecklistScreen;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.frontend.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class FileAssociationsScreen
extends ChecklistScreen {
    public static final String VARIABLE_EXTENSIONS = "sys.fileAssociation.extensions";
    public static final String VARIABLE_LAUNCHERS = "sys.fileAssociation.launchers";
    private boolean showSelectionButtons = false;

    public boolean isShowSelectionButtons() {
        return this.showSelectionButtons;
    }

    public void setShowSelectionButtons(boolean showSelectionButtons) {
        this.showSelectionButtons = showSelectionButtons;
    }

    @Override
    public boolean isHidden() {
        return this.findAssociationActions().size() == 0;
    }

    @Override
    protected void save() {
        super.save();
        ArrayList<String> extensions = new ArrayList<String>();
        ArrayList<String> launchers = new ArrayList<String>();
        for (SingleAssociationPanel singleAssociationPanel : this.singleCheckPanels) {
            CreateFileAssociationAction associationAction = singleAssociationPanel.getAssociationAction();
            if (!associationAction.isSelected()) continue;
            extensions.add(associationAction.getExtension());
            launchers.add(associationAction.getLauncherId());
        }
        this.getContext().setVariable(VARIABLE_EXTENSIONS, extensions.toArray(new String[extensions.size()]));
        this.getContext().registerResponseFileVariable(VARIABLE_EXTENSIONS);
        this.getContext().setVariable(VARIABLE_LAUNCHERS, launchers.toArray(new String[launchers.size()]));
        this.getContext().registerResponseFileVariable(VARIABLE_LAUNCHERS);
    }

    private boolean isAssociationSelected(String extension, String launcherId, boolean defaultValue) {
        String[] arrayLauncher;
        String[] arrayExtensions;
        Object varExtensions = this.getContext().getVariable(VARIABLE_EXTENSIONS);
        Object varLaunchers = this.getContext().getVariable(VARIABLE_LAUNCHERS);
        if (varExtensions != null && varExtensions instanceof String[] && varLaunchers != null && varLaunchers instanceof String[] && (arrayExtensions = (String[])varExtensions).length == (arrayLauncher = (String[])varLaunchers).length) {
            for (int i = 0; i < arrayLauncher.length; ++i) {
                if (!arrayLauncher[i].equals(launcherId) || !arrayExtensions[i].equals(extension)) continue;
                return true;
            }
            return false;
        }
        return defaultValue;
    }

    @Override
    protected void addSingleChecks(GridBagConstraints gc) {
        List<CreateFileAssociationAction> associationActions = this.findAssociationActions();
        for (CreateFileAssociationAction associationAction : associationActions) {
            SingleAssociationPanel singleAssociationPanel = new SingleAssociationPanel(associationAction);
            this.singleCheckPanels.add(singleAssociationPanel);
            if (gc == null) continue;
            gc.insets.bottom = 0;
            this.checklistPanel.add((Component)singleAssociationPanel, gc);
            ++gc.gridy;
        }
    }

    private List<CreateFileAssociationAction> findAssociationActions() {
        ContextInt context = ContextImpl.getContextInt(this.getContext());
        boolean installFilesFollows = context.getExecutableActionsStartingFrom(InstallFilesAction.class, this).size() > 0;
        ArrayList<CreateFileAssociationAction> usedActions = new ArrayList<CreateFileAssociationAction>();
        List<CreateFileAssociationAction> executableActions = context.getExecutableActionsStartingFrom(CreateFileAssociationAction.class, this);
        for (CreateFileAssociationAction action : executableActions) {
            if (!installFilesFollows && !action.fileExists(this.getContext())) continue;
            if (Util.isWindowsInstaller() && action.isWindows()) {
                usedActions.add(action);
                continue;
            }
            if (!Util.isMacosInstaller() || !action.isMac()) continue;
            usedActions.add(action);
        }
        return usedActions;
    }

    @Override
    public String getTitle() {
        return this.getMessage("WizardSelectAssociations");
    }

    @Override
    public String getSubTitle() {
        return this.getMessage("SelectAssociationsDesc");
    }

    @Override
    protected void addScreenContent(JPanel panel, GridBagConstraints gc) {
        String headerMessage = this.getMessage("SelectAssociationsLabel");
        if (headerMessage.trim().length() > 0) {
            this.addDisplayTextArea(headerMessage, panel, gc);
        }
        super.addScreenContent(panel, gc);
        if (this.showSelectionButtons) {
            Box box = Box.createHorizontalBox();
            JButton selectAllButton = new JButton(Messages.getMessages().getString("SelectAll"));
            selectAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileAssociationsScreen.this.selectAllCheckboxes(true);
                }
            });
            box.add(selectAllButton);
            box.add(Box.createHorizontalStrut(5));
            JButton unselectAllButton = new JButton(Messages.getMessages().getString("SelectNone"));
            unselectAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileAssociationsScreen.this.selectAllCheckboxes(false);
                }
            });
            box.add(unselectAllButton);
            ++gc.gridy;
            gc.weighty = 0.0;
            gc.fill = 0;
            panel.add((Component)box, gc);
        }
    }

    private void selectAllCheckboxes(boolean select) {
        for (SingleAssociationPanel panel : this.singleCheckPanels) {
            panel.chkSingle.setSelected(select);
        }
    }

    protected class SingleAssociationPanel
    extends ChecklistScreen.SingleCheckPanel {
        private CreateFileAssociationAction associationAction;

        public SingleAssociationPanel(CreateFileAssociationAction associationAction) {
            this.associationAction = associationAction;
            this.setLayout(new BorderLayout());
            this.chkSingle = new JCheckBox(associationAction.getDescription() + " (*." + associationAction.getExtension() + ")", FileAssociationsScreen.this.isAssociationSelected(associationAction.getExtension(), associationAction.getLauncherId(), associationAction.isSelected()));
            this.add((Component)this.chkSingle, "West");
        }

        @Override
        public void save() {
            this.associationAction.setSelected(this.chkSingle.isSelected());
        }

        public CreateFileAssociationAction getAssociationAction() {
            return this.associationAction;
        }
    }
}

