/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.LeadingLabelComponent;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.Logger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;

public class ButtonComponent
extends LeadingLabelComponent {
    private String buttonText;
    private ExternalFile buttonIconFile;
    private ScriptProperty actionScript;
    private JButton button;

    public String getButtonText() {
        return this.buttonText;
    }

    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    public ExternalFile getButtonIconFile() {
        return this.buttonIconFile;
    }

    public void setButtonIconFile(ExternalFile buttonIconFile) {
        this.buttonIconFile = buttonIconFile;
    }

    public ScriptProperty getActionScript() {
        return this.actionScript;
    }

    public void setActionScript(ScriptProperty actionScript) {
        this.actionScript = actionScript;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.button.setText(ButtonComponent.replaceVariables(this.buttonText, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE));
    }

    @Override
    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.button != null && formEnvironment != null) {
            this.button.setName(formEnvironment.getId(this));
        }
    }

    @Override
    public JComponent createCenterComponent() {
        File actualIconFile;
        this.button = new JButton();
        if (this.buttonIconFile != null && (actualIconFile = this.getContext().getExternalFile(this.buttonIconFile, false)).exists()) {
            try {
                this.button.setIcon(GUIHelper.loadIcon(actualIconFile));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonComponent.this.doButtonClicked();
            }
        });
        return this.button;
    }

    private void doButtonClicked() {
        if (this.actionScript != null) {
            try {
                this.getContext().runScript(this.actionScript, this, new Object[]{this.getFormEnvironment()});
            }
            catch (Exception e) {
                Util.printAnnotatedStackTrace(e);
                Logger.getInstance().log(e);
            }
        }
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return false;
    }

    @Override
    public Object getConfigurationObject() {
        return this.button;
    }

    @Override
    public Class getConfigurationObjectClass() {
        return JButton.class;
    }

    @Override
    public boolean handleConsole(Console console) {
        return true;
    }
}

